/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.routing;

import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.StringReader;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;

public class SoapMessageHelper {
    private static final String TITLE_MANAGER_SERVICE = "cms/TitleManagerProxy/local";
    private static final String PRIORITY = "priority";
    private static final String PROVIDER_ID = "providerId";
    private static final String TITLE_ID = "titleId";
    private static final String ENVELOPE_TEMPLATE = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header/><soapenv:Body>WFS_MESSAGE</soapenv:Body></soapenv:Envelope>";

    public SOAPMessage generateSOAPMessage(IMessage msg) throws Exception {
        SOAPMessage message = MessageFactory.newInstance().createMessage();
        message.getMimeHeaders().addHeader("SOAPAction", "");
        WorkflowMessage wfsmsg = new WPCLConverter().convert(msg);
        String msgContent = this.generateMsgContent(msg, wfsmsg);
        String envelopeInstance = ENVELOPE_TEMPLATE.replace("WFS_MESSAGE", msgContent);
        SOAPPart soapPart = message.getSOAPPart();
        soapPart.setContent((Source)new StreamSource(new StringReader(envelopeInstance)));
        return message;
    }

    private String generateMsgContent(IMessage msg, WorkflowMessage wfsmsg) throws Exception {
        String msgContent;
        String titleId = wfsmsg.getPayload().getValue(TITLE_ID);
        if (titleId != null && titleId.trim().length() > 0) {
            this.updateWorkflowMessageByTitleId(wfsmsg, titleId);
            IMessage request = new WPCLConverter().convert(wfsmsg);
            msgContent = request.getPayload().getContent();
        } else {
            msgContent = msg.getPayload().getContent();
        }
        msgContent = msgContent.substring(msgContent.indexOf("?>") + 2);
        return msgContent;
    }

    private void updateWorkflowMessageByTitleId(WorkflowMessage wfsmsg, String titleId) {
        String providerId = wfsmsg.getPayload().getValue(PROVIDER_ID);
        if (providerId == null || providerId.trim().isEmpty()) {
            Long partnerId = this.getTitleManager().get(Long.valueOf(titleId)).getPartnerId();
            providerId = this.getPartnerManager().getPartner(partnerId).getProviderId();
        }
        wfsmsg.getPayload().putValue(PROVIDER_ID, providerId);
        if (wfsmsg.getCommand().getParameterValue(PRIORITY) == null) {
            String priority = this.getTitleManager().getPriority(Long.valueOf(titleId));
            wfsmsg.getCommand().addParameter(PRIORITY, priority);
        }
    }

    public void updateConvertedWorkflowMessage(WorkflowMessage wfsmsg) {
        String titleId = wfsmsg.getPayload().getValue(TITLE_ID);
        if (StringUtils.isNotEmpty((String)titleId)) {
            this.updateWorkflowMessageByTitleId(wfsmsg, titleId);
        }
    }

    private ITitleManager getTitleManager() {
        ITitleManager service = null;
        try {
            service = (ITitleManager)InjectionUtil.injectInstance((String)TITLE_MANAGER_SERVICE);
        }
        catch (RuntimeException e) {
            String msg = "Failed to lookup the Title Manager service(cms/TitleManagerProxy/local).";
            throw new RuntimeException(msg, e);
        }
        return service;
    }

    private IPartnerManagement getPartnerManager() {
        return (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    }
}

