/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.thread;

import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class TimeoutTaskScheduler<T>
extends Scheduler<T> {
    private ScheduledThreadPoolExecutor timeoutExecutor;
    private static final Logger LOGGER = Logger.getLogger(TimeoutTaskScheduler.class);

    public TimeoutTaskScheduler(String name) {
        this(name, 1, 1);
    }

    public TimeoutTaskScheduler(String name, int coreSize, int max) {
        super(name, coreSize, max);
        this.timeoutExecutor = new ScheduledThreadPoolExecutor(coreSize);
        this.timeoutExecutor.setMaximumPoolSize(max);
    }

    public Future<T> execute(Callable<T> task, String taskName, long taskExecutionTimeoutMS) {
        return this.schedule(() -> {
            Future<Object> future = this.timeoutExecutor.submit(() -> task.call());
            try {
                return future.get(taskExecutionTimeoutMS, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                String message = "Fail to execute the task : " + taskName + " in " + taskExecutionTimeoutMS + " ms";
                LOGGER.error((Object)message, (Throwable)e);
                future.cancel(true);
                throw new TimeoutException(message);
            }
        });
    }
}

