/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.tandbergtv.metadatamanager.DocumentDAOHelper;
import com.tandbergtv.metadatamanager.assetkey.GetAllTitleListOperator;
import com.tandbergtv.metadatamanager.assetkey.PgQueryBuilder;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.sql.AbstractSQLBuilder;
import com.tandbergtv.metadatamanager.sql.HibernateSQLQueryHelper;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.postgresql.util.PGobject;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

public class IdDAO {
    private HibernateTemplate template;
    public static String assetKeyTable = "mdm_asset_identifier";
    public static String documentIdColumn = "document_id";
    public static String assetIdColumn = "asset_id";
    public static String keysJsonColumn = "keys";
    private static final Logger logger = Logger.getLogger(IdDAO.class);
    public static String assetKeyTableUniqueIndexName = "idx_unique_mdm_identifier_";
    public static final String WARNING_MSG = "Below title(s) have duplicate identifiers, please take action to correct them: ";

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    @Transactional
    public boolean checkKeys(SearchCriteria criteria) {
        AbstractSQLBuilder selectBuilder = PgQueryBuilder.getAssetUniquenessQuery(criteria);
        Session session = this.template.getSessionFactory().getCurrentSession();
        SQLQuery query = HibernateSQLQueryHelper.createSQLQuery((org.hibernate.Session)session, selectBuilder.build(), criteria.getValueList());
        List list = HibernateSQLQueryHelper.listAndCast(query);
        return !list.isEmpty();
    }

    public void saveKeys(Map<Asset, String> data) {
        AbstractSQLBuilder insertBuilder = PgQueryBuilder.getInsertAssetKeyQuery();
        Session session = this.template.getSessionFactory().getCurrentSession();
        session.doWork(connection -> {
            Set assets = data.keySet();
            try (PreparedStatement ps = connection.prepareStatement(insertBuilder.build());){
                for (Asset asset : assets) {
                    PGobject dataObject = new PGobject();
                    dataObject.setType("json");
                    dataObject.setValue((String)data.get(asset));
                    Asset root = asset.getRoot() != null ? asset.getRoot() : asset;
                    ps.setLong(1, root.getId());
                    ps.setLong(2, asset.getId());
                    ps.setObject(3, dataObject);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        });
    }

    @Transactional
    public void deleteKeys(Long rootAssetId) {
        AbstractSQLBuilder deleteBuilder = PgQueryBuilder.getDeleteAssetKeyByDocumentIdQuery();
        Session session = this.template.getSessionFactory().getCurrentSession();
        SQLQuery query = HibernateSQLQueryHelper.createSQLQuery((org.hibernate.Session)session, deleteBuilder.build(), rootAssetId);
        query.executeUpdate();
    }

    @Transactional
    public List<Long> getDocumentId(SearchCriteria criteria) {
        AbstractSQLBuilder selectBuilder = PgQueryBuilder.getDocumentIdQuery(criteria);
        Session session = this.template.getSessionFactory().getCurrentSession();
        SQLQuery query = HibernateSQLQueryHelper.createSQLQuery((org.hibernate.Session)session, selectBuilder.build(), criteria.getValueList());
        List<BigDecimal> list = HibernateSQLQueryHelper.listAndCast(query);
        return this.castBigDecimalToLong(list);
    }

    private List<Long> castBigDecimalToLong(List<BigDecimal> list) {
        ArrayList<Long> castList = new ArrayList<Long>();
        for (BigDecimal item : list) {
            castList.add(item.longValue());
        }
        return castList;
    }

    public List<Document> getDocuments(SearchCriteria criteria) {
        String sql = PgQueryBuilder.getFullDocumentQuery(criteria).build();
        logger.info((Object)("Asset search:Search for Full Doc query = " + sql));
        return DocumentDAOHelper.getDocuments((org.hibernate.Session)this.template.getSessionFactory().getCurrentSession(), sql);
    }

    public String createUniqueIndex(String specAlias, Collection<String> ttvPaths) {
        logger.debug((Object)("Now handling spec : " + specAlias));
        String displayMsg = "";
        List<BigDecimal[]> duplicateAssetIds = this.getDuplicateAssetId(ttvPaths);
        if (!duplicateAssetIds.isEmpty()) {
            Set<Set<Long>> titleIds = this.getTitleIdsByAssetIds(duplicateAssetIds);
            displayMsg = this.getDisplayTitleIdMessage(titleIds);
            logger.warn((Object)(WARNING_MSG + displayMsg));
            List<Long> toBeRemovedAssetIds = this.getToBeRemovedAssetIds(duplicateAssetIds);
            logger.info((Object)("Following Asset Id(s) are duplicate and will be removed: " + toBeRemovedAssetIds));
            this.deleteAssetKeyByAssetIds(toBeRemovedAssetIds);
        }
        String indexName = assetKeyTableUniqueIndexName + specAlias;
        this.addUniqueIndex(indexName, ttvPaths);
        return displayMsg;
    }

    private String getDisplayTitleIdMessage(Set<Set<Long>> idSet) {
        ArrayList<String> resultMsg = new ArrayList<String>();
        for (Set<Long> ids : idSet) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("[");
            sb.append(StringUtils.join(ids, (String)","));
            sb.append("]");
            resultMsg.add(sb.toString());
        }
        return StringUtils.join(resultMsg, (String)",");
    }

    private List<Long> getToBeRemovedAssetIds(List<BigDecimal[]> duplicateList) {
        ArrayList<Long> toBeRemoved = new ArrayList<Long>();
        for (BigDecimal[] assetIdArray : duplicateList) {
            for (int i = 1; i < assetIdArray.length; ++i) {
                toBeRemoved.add(assetIdArray[i].longValue());
            }
        }
        return toBeRemoved;
    }

    private Set<Set<Long>> getTitleIdsByAssetIds(List<BigDecimal[]> assetIds) {
        HashSet<Set<Long>> titleIdsSet = new HashSet<Set<Long>>();
        Collections.sort(assetIds, (o1, o2) -> ((BigDecimal[])o1).length - ((BigDecimal[])o2).length);
        GetAllTitleListOperator operator = new GetAllTitleListOperator();
        for (BigDecimal[] ids : assetIds) {
            TreeSet<Long> titleIds = new TreeSet<Long>();
            for (BigDecimal id : ids) {
                titleIds.addAll(this.getTitleIdByAssetId(id));
            }
            operator.addTitleIdListIntoResultSet(titleIdsSet, titleIds);
        }
        return titleIdsSet;
    }

    @Transactional
    public List<Long> getTitleIdByAssetId(BigDecimal id) {
        AbstractSQLBuilder selectBuilder = PgQueryBuilder.getTitleIdFromAssetIdQuery();
        Session session = this.template.getSessionFactory().getCurrentSession();
        SQLQuery query = HibernateSQLQueryHelper.createSQLQuery((org.hibernate.Session)session, selectBuilder.build(), id);
        List<BigDecimal> list = HibernateSQLQueryHelper.listAndCast(query);
        return this.castBigDecimalToLong(list);
    }

    @Transactional
    public List<BigDecimal[]> getDuplicateAssetId(Collection<String> ttvPaths) {
        AbstractSQLBuilder selectBuilder = PgQueryBuilder.getDuplicateAssetIdQuery(ttvPaths);
        return this.executeQueryForArray(selectBuilder.build());
    }

    @Transactional
    public void deleteAssetKeyByAssetId(Long assetId) {
        AbstractSQLBuilder deleteBuilder = PgQueryBuilder.getDeleteAssetKeyByAssetIdQuery();
        Session session = this.template.getSessionFactory().getCurrentSession();
        SQLQuery query = HibernateSQLQueryHelper.createSQLQuery((org.hibernate.Session)session, deleteBuilder.build(), assetId);
        query.executeUpdate();
    }

    public void deleteAssetKeyByAssetIds(List<Long> toBeRemovedAssetIds) {
        for (Long toBeRemoved : toBeRemovedAssetIds) {
            this.deleteAssetKeyByAssetId(toBeRemoved);
        }
    }

    private List<BigDecimal[]> executeQueryForArray(final String queryStr) {
        final ArrayList<BigDecimal[]> ids = new ArrayList<BigDecimal[]>();
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                try (PreparedStatement statement = conn.prepareStatement(queryStr);){
                    ResultSet results = statement.executeQuery();
                    while (results.next()) {
                        Array array = results.getArray(1);
                        Object[] assetIds = (BigDecimal[])array.getArray();
                        Arrays.sort(assetIds);
                        ids.add(assetIds);
                    }
                }
            }
        };
        Session session = this.template.getSessionFactory().getCurrentSession();
        session.doWork(work);
        return ids;
    }

    private void addUniqueIndex(String indexName, Collection<String> ttvPaths) {
        final String sql = PgQueryBuilder.getCreateUniqueIndexOnIdentifiersQuery(indexName, ttvPaths);
        logger.debug((Object)sql);
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                try (PreparedStatement ps = conn.prepareStatement(sql);){
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        int value = 0;
                        if (rs.next()) {
                            value = rs.getInt(1);
                        }
                        if (value != 0) {
                            logger.warn((Object)"Create unique index is NOT successful, please check wfs.install_table for details.");
                        }
                    }
                }
            }
        };
        Session session = this.template.getSessionFactory().getCurrentSession();
        session.doWork(work);
    }

    public void deleteIndexes(final Set<String> indexNames) {
        Work work = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                String dropIndexSql = "drop index if exists %s";
                try (Statement st = conn.createStatement();){
                    for (String name : indexNames) {
                        st.execute(String.format(dropIndexSql, name));
                    }
                }
            }
        };
        Session session = this.template.getSessionFactory().getCurrentSession();
        session.doWork(work);
    }
}

