/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.pg;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.oracle.UpdateMetadata;
import com.tandbergtv.metadatamanager.search.MDMTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.w3c.dom.Document;

public class PgUpdateMetadata
extends UpdateMetadata {
    public PgUpdateMetadata(long documentId, Document ecmfDoc, boolean isNewRevision, boolean isOriginal) throws MetadataException {
        super(documentId, ecmfDoc, isNewRevision, isOriginal);
    }

    @Override
    protected String getInsertSelectSql(long documentId) {
        if (!this.isNewRevision) {
            return null;
        }
        StringBuilder s = new StringBuilder("INSERT into ");
        s.append(MDMTable.REVISION.getTableName());
        s.append(" (document_id, revision, document)");
        s.append(" select document_id, (xpath('/ECMFSpec/@revision',document))[1]::text::numeric(19,0), document from ");
        if (this.isOriginal) {
            s.append(MDMTable.MASTER.getTableName());
        } else {
            s.append(MDMTable.COPY.getTableName());
        }
        s.append(" mdm");
        s.append(" WHERE mdm.document_id=");
        s.append(documentId);
        return s.toString();
    }

    @Override
    protected String getUpdateSql() {
        StringBuilder s = new StringBuilder("UPDATE ");
        if (this.isOriginal) {
            s.append(MDMTable.MASTER.getTableName());
        } else {
            s.append(MDMTable.COPY.getTableName());
        }
        s.append(" SET document = ? WHERE document_Id=");
        s.append(this.documentId);
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exeUpdate(Connection con) throws SQLException {
        String updSql = this.getUpdateSql();
        logger.debug((Object)updSql);
        PreparedStatement st = con.prepareStatement(updSql);
        SQLXML xmlObj = null;
        try {
            xmlObj = con.createSQLXML();
            xmlObj.setString(this.strXml);
            st.setSQLXML(1, xmlObj);
            st.executeUpdate();
        }
        finally {
            if (xmlObj != null) {
                xmlObj.free();
            }
            if (st != null) {
                st.close();
            }
        }
    }
}

