/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import com.tandbergtv.metadatamanager.specimpl.ValidatorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class AssetValidator {
    private SpecHandlerBase parentHandler;

    public AssetValidator(SpecHandlerBase specificationHandler) {
        this.parentHandler = specificationHandler;
    }

    public void validate(Asset rootAsset) throws MetadataException {
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        for (ISpecHandler handler : handlers) {
            this.validateAssetInTree(rootAsset, handler);
        }
    }

    public void validateWithCurrentSpecification(Asset rootAsset) throws MetadataException {
        this.validateAssetInTree(rootAsset, this.parentHandler);
    }

    private void validateAssetInTree(Asset rootAsset, ISpecHandler handler) throws MetadataException {
        List<Asset> assets = this.getAssetsInTree(rootAsset);
        ArrayList<SearchCriteria> assetKeys = new ArrayList<SearchCriteria>();
        for (Asset currentAsset : assets) {
            this.validateAssetInTree(currentAsset, handler, assetKeys);
        }
    }

    private List<Asset> getAssetsInTree(Asset asset) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        this.getAssetsInTree(asset, assets);
        return assets;
    }

    private void getAssetsInTree(Asset asset, List<Asset> assets) {
        assets.add(asset);
        int currentIndex = 0;
        while (currentIndex < assets.size()) {
            Asset currentAsset;
            if ((currentAsset = assets.get(currentIndex++)).getRelations() == null) continue;
            for (Relation relation : currentAsset.getRelations()) {
                Asset target = relation.getTargetAsset();
                if (assets.contains(target)) continue;
                assets.add(target);
            }
        }
    }

    private void validateAssetInTree(Asset asset, ISpecHandler hander, Collection<SearchCriteria> assetKeys) throws MetadataException {
        SearchCriteria assetKey = this.getAssetSpecificationKey(asset, hander);
        if (assetKey == null || assetKey.isEmptyCriteria()) {
            return;
        }
        if (this.hasAssetKey(assetKeys, assetKey)) {
            String specificationName = hander.getSpecName();
            String msg = "Found multiple assets in asset tree with key " + assetKey.toString() + " for specification " + specificationName + ".";
            throw new MetadataException(msg);
        }
        assetKeys.add(assetKey);
    }

    private SearchCriteria getAssetSpecificationKey(Asset asset, ISpecHandler handler) {
        IIdentifier identifier = handler.extractId(asset);
        if (!identifier.isValidIdentifier()) {
            return null;
        }
        Map<String, String> idPaths = identifier.getTTVPaths();
        Map<String, String> identifiers = identifier.getSpecIdentifiers();
        SearchCriteria criteria = new SearchCriteria();
        for (String specificationIDXPath : idPaths.keySet()) {
            String ttvIDXPath = idPaths.get(specificationIDXPath);
            String value = identifiers.get(specificationIDXPath);
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvIDXPath)) {
                return null;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            criteria.put(ttvIDXPath, value);
        }
        return criteria;
    }

    private boolean hasAssetKey(Collection<SearchCriteria> assetKeys, SearchCriteria assetKey) {
        for (SearchCriteria currentAssetKey : assetKeys) {
            if (!assetKey.hasSameCriteria(currentAssetKey)) continue;
            return true;
        }
        return false;
    }

    private Collection<ISpecHandler> getSpecificationHandlersForValidation() {
        ValidatorHelper helper = ValidatorHelper.getInstance();
        return helper.getSpecificationHandlersForValidation();
    }
}

