/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DateParseUtil {
    private static final Logger logger = Logger.getLogger(DateParseUtil.class);
    private static final String DATE_TIME_FORMAT_WITH_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    private DateParseUtil() {
    }

    public static String getIsoDateNoMillis(Date date) {
        StringBuilder result = new StringBuilder();
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_TIME_FORMAT_WITH_TIMEZONE);
        dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        result.append(dateFormatter.format(date));
        logger.debug((Object)("isoDate: " + result.toString()));
        return result.toString();
    }

    public static Date parseStringToDate(String isoDate) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        OffsetDateTime odt = OffsetDateTime.parse(isoDate);
        Date date = Date.from(odt.toInstant());
        logger.debug((Object)("OffsetDateTime: " + odt));
        logger.debug((Object)("converted date is: " + date));
        return date;
    }
}

