/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.util;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.task.DistributedCallable;
import com.ericsson.cms.neptune.cluster.task.DistributedLocalCallable;
import com.ericsson.cms.neptune.cluster.task.DistributedMasterCallable;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang.Validate;

public final class SchedulerUtils {
    private SchedulerUtils() {
    }

    public static <T> Future<T> submitTask(Callable<T> callable, IExecutorService executorService, IClusterService clusterService) {
        Validate.notNull(callable);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)clusterService);
        Member target = null;
        if (callable instanceof DistributedMasterCallable) {
            target = clusterService.getMaster();
        }
        if (callable instanceof DistributedLocalCallable) {
            target = clusterService.getLocalMember();
        }
        if (target == null && callable instanceof DistributedCallable) {
            Object key = ((DistributedCallable)DistributedCallable.class.cast(callable)).getKey();
            if (key == null) {
                throw new RejectedExecutionException("Cannot perform the DistributedCallable without a key on this schedule method");
            }
            if (key instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)InetSocketAddress.class.cast(key);
                target = clusterService.getMemberByAddress(address);
                if (target == null) {
                    throw new RejectedExecutionException("Address unavailable: " + address);
                }
            } else {
                return executorService.submitToKeyOwner(callable, key);
            }
        }
        return target != null ? executorService.submitToMember(callable, target) : executorService.submit(callable);
    }
}

