/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.pbuilder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class PackageBuilder {
    private String destinationDir = "/hd2/migrate";
    private String fileSourceDir = "/usr/local/n2bb/simulators/pbuilder/skeleton";
    private String adiSkeleton = "/usr/local/n2bb/simulators/pbuilder/skeleton/ADI.XML";
    private String dtdSkeleton = "/usr/local/n2bb/simulators/pbuilder/skeleton/ADI.DTD";
    private String moviefile = "movie.mpg";
    private String moviefilesize = "12345";
    private String moviefilechecksum = "54321";
    private String posterfile = "poster.bmp";
    private String posterfilesize = "1234";
    private String posterfilechecksum = "54321";
    private String previewfile = "preview.mpg";
    private String previewfilesize = "1234";
    private String previewfilechecksum = "54321";
    private String licensewindowstart = "2005-10-01";
    private String licensewindowend = "2006-09-30";
    private String startNum = "1000";
    private int num_packages = 1;
    private static final int PACKAGE = 1;
    private static final int TITLE = 2;
    private static final int MOVIE = 3;
    private static final int PREVIEW = 4;
    private static final int POSTER = 5;
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static final String PACKAGE_ASSET_ID = "PACKAGE_ASSET_ID";
    private static final String TITLE_ASSET_NAME = "TITLE_ASSET_NAME";
    private static final String TITLE_ASSET_ID = "TITLE_ASSET_ID";
    private static final String MOVIE_ASSET_NAME = "MOVIE_ASSET_NAME";
    private static final String MOVIE_ASSET_ID = "MOVIE_ASSET_ID";
    private static final String MOVIE_ASSET_FILESIZE = "MOVIE_ASSET_FILESIZE";
    private static final String MOVIE_ASSET_CHECKSUM = "MOVIE_ASSET_CHECKSUM";
    private static final String MOVIE_ASSET_FILENAME = "MOVIE_ASSET_FILENAME";
    private static final String PREVIEW_ASSET_NAME = "PREVIEW_ASSET_NAME";
    private static final String PREVIEW_ASSET_ID = "PREVIEW_ASSET_ID";
    private static final String PREVIEW_ASSET_FILESIZE = "PREVIEW_ASSET_FILESIZE";
    private static final String PREVIEW_ASSET_CHECKSUM = "PREVIEW_ASSET_CHECKSUM";
    private static final String PREVIEW_ASSET_FILENAME = "PREVIEW_ASSET_FILENAME";
    private static final String POSTER_ASSET_NAME = "POSTER_ASSET_NAME";
    private static final String POSTER_ASSET_ID = "POSTER_ASSET_ID";
    private static final String POSTER_ASSET_FILESIZE = "POSTER_ASSET_FILESIZE";
    private static final String POSTER_ASSET_CHECKSUM = "POSTER_ASSET_CHECKSUM";
    private static final String POSTER_ASSET_FILENAME = "POSTER_ASSET_FILENAME";
    private static final String LICENSE_WINDOW_START = "LICENSE_WINDOW_START";
    private static final String LICENSE_WINDOW_END = "LICENSE_WINDOW_END";

    PackageBuilder(int n) {
        this.init();
        this.num_packages = n;
    }

    private void init() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("PropertyFile", "/usr/local/n2bb/simulators/packagebuilder/conf/PackageBuilder.conf");
        Properties properties2 = new Properties();
        try {
            properties2.load(new FileInputStream(string));
            this.destinationDir = properties2.getProperty("destination", "/hd2/migrate");
            this.fileSourceDir = properties2.getProperty("filesourcedir", "/usr/local/n2bb/simulators/pbuilder/skeleton");
            this.adiSkeleton = this.fileSourceDir + File.separator + properties2.getProperty("adiskeletonfile", "ADI.XML");
            this.dtdSkeleton = this.fileSourceDir + File.separator + properties2.getProperty("dtdskeletonfile", "ADI.DTD");
            this.moviefile = properties2.getProperty("moviefile", "movie.mpg");
            this.moviefilesize = properties2.getProperty("moviefilesize", "12345");
            this.moviefilechecksum = properties2.getProperty("moviefilechecksum", "54321");
            this.posterfile = properties2.getProperty("posterfile", "poster.bmp");
            this.posterfilesize = properties2.getProperty("posterfilesize", "1234");
            this.posterfilechecksum = properties2.getProperty("posterfilechecksum", "54321");
            this.previewfile = properties2.getProperty("previewfile", "preview.mpg");
            this.previewfilesize = properties2.getProperty("previewfilesize", "1234");
            this.previewfilechecksum = properties2.getProperty("previewfilechecksum", "54321");
            this.startNum = properties2.getProperty("startnum", "1000");
            this.licensewindowstart = properties2.getProperty("licensewindowstart", "2005-10-01");
            this.licensewindowend = properties2.getProperty("licensewindowend", "2006-09-30");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Configuration File '" + string + "' Not found; ");
        }
        catch (IOException iOException) {
            System.out.println("IO Exception reading configuration file ");
        }
        System.out.println("System Initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = Integer.parseInt(this.startNum);
        String string = this.fileSourceDir + File.separator + this.moviefile;
        String string2 = this.fileSourceDir + File.separator + this.previewfile;
        String string3 = this.fileSourceDir + File.separator + this.posterfile;
        File file = new File(this.destinationDir + File.separator + "PackageBuilder.log");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            for (int i = n; i < n + this.num_packages; ++i) {
                String string4 = this.destinationDir + File.separator + "Package" + i;
                System.out.println("Creating " + string4);
                File file2 = new File(string4);
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                this.writeMetadata(string4, i);
                this.writeDTD(string4, i);
                String string5 = this.destinationDir + File.separator + "Package" + i + File.separator + "movie" + i + ".mpg";
                String string6 = this.destinationDir + File.separator + "Package" + i + File.separator + "preview" + i + ".mpg";
                String string7 = this.destinationDir + File.separator + "Package" + i + File.separator + "poster" + i + ".bmp";
                this.createSymLink(string, string5);
                this.createSymLink(string2, string6);
                this.createSymLink(string3, string7);
                fileWriter.write("Package" + i + "\t" + string4 + "\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void writeMetadata(String string, int n) {
        File file = new File(this.adiSkeleton);
        File file2 = new File(this.destinationDir + File.separator + "Package" + n + File.separator + "ADI.XML");
        String string2 = new Integer(n).toString();
        try {
            String string3;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            FileWriter fileWriter = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                if (string3.contains(PACKAGE_NAME)) {
                    string4 = "Package_" + string2;
                    string3 = string3.replace(PACKAGE_NAME, string4);
                } else if (string3.contains(PACKAGE_ASSET_ID)) {
                    string4 = this.createID(1, n);
                    string3 = string3.replace(PACKAGE_ASSET_ID, string4);
                } else if (string3.contains(TITLE_ASSET_NAME)) {
                    string4 = "Package_" + string2 + "_Title";
                    string3 = string3.replace(TITLE_ASSET_NAME, string4);
                } else if (string3.contains(TITLE_ASSET_ID)) {
                    string4 = this.createID(2, n);
                    string3 = string3.replace(TITLE_ASSET_ID, string4);
                } else if (string3.contains(MOVIE_ASSET_NAME)) {
                    string4 = "Package_" + string2 + "_Movie";
                    string3 = string3.replace(MOVIE_ASSET_NAME, string4);
                } else if (string3.contains(MOVIE_ASSET_ID)) {
                    string4 = this.createID(3, n);
                    string3 = string3.replace(MOVIE_ASSET_ID, string4);
                } else if (string3.contains(MOVIE_ASSET_FILESIZE)) {
                    string3 = string3.replace(MOVIE_ASSET_FILESIZE, this.moviefilesize);
                } else if (string3.contains(MOVIE_ASSET_CHECKSUM)) {
                    string3 = string3.replace(MOVIE_ASSET_CHECKSUM, this.moviefilechecksum);
                } else if (string3.contains(MOVIE_ASSET_FILENAME)) {
                    string4 = "movie" + string2 + ".mpg";
                    string3 = string3.replace(MOVIE_ASSET_FILENAME, string4);
                } else if (string3.contains(PREVIEW_ASSET_NAME)) {
                    string4 = "Package_" + string2 + "_Preview";
                    string3 = string3.replace(PREVIEW_ASSET_NAME, string4);
                } else if (string3.contains(PREVIEW_ASSET_ID)) {
                    string4 = this.createID(4, n);
                    string3 = string3.replace(PREVIEW_ASSET_ID, string4);
                } else if (string3.contains(PREVIEW_ASSET_FILESIZE)) {
                    string3 = string3.replace(PREVIEW_ASSET_FILESIZE, this.previewfilesize);
                } else if (string3.contains(PREVIEW_ASSET_CHECKSUM)) {
                    string3 = string3.replace(PREVIEW_ASSET_CHECKSUM, this.previewfilechecksum);
                } else if (string3.contains(PREVIEW_ASSET_FILENAME)) {
                    string4 = "preview" + string2 + ".mpg";
                    string3 = string3.replace(PREVIEW_ASSET_FILENAME, string4);
                } else if (string3.contains(POSTER_ASSET_NAME)) {
                    string4 = "Package_" + string2 + "_Poster";
                    string3 = string3.replace(POSTER_ASSET_NAME, string4);
                } else if (string3.contains(POSTER_ASSET_ID)) {
                    string4 = this.createID(5, n);
                    string3 = string3.replace(POSTER_ASSET_ID, string4);
                } else if (string3.contains(POSTER_ASSET_FILESIZE)) {
                    string3 = string3.replace(POSTER_ASSET_FILESIZE, this.posterfilesize);
                } else if (string3.contains(POSTER_ASSET_CHECKSUM)) {
                    string3 = string3.replace(POSTER_ASSET_CHECKSUM, this.posterfilechecksum);
                } else if (string3.contains(POSTER_ASSET_FILENAME)) {
                    string4 = "poster" + string2 + ".bmp";
                    string3 = string3.replace(POSTER_ASSET_FILENAME, string4);
                } else if (string3.contains(LICENSE_WINDOW_START)) {
                    string3 = string3.replace(LICENSE_WINDOW_START, this.licensewindowstart);
                } else if (string3.contains(LICENSE_WINDOW_END)) {
                    string3 = string3.replace(LICENSE_WINDOW_END, this.licensewindowend);
                }
                bufferedWriter.write(string3 + "\n");
            }
            bufferedWriter.flush();
            if (fileReader != null) {
                fileReader.close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDTD(String string, int n) {
        File file = new File(this.dtdSkeleton);
        String string2 = new Integer(n).toString();
        File file2 = new File(this.destinationDir + File.separator + "Package" + string2 + File.separator + "ADI.DTD");
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String createID(int n, int n2) {
        String string = "";
        String string2 = "TTVV";
        String string3 = new Integer(n2).toString() + "1000000000000000000";
        switch (n) {
            case 1: {
                string = string2 + string3.substring(0, 15) + "1";
                break;
            }
            case 2: {
                string = string2 + string3.substring(0, 15) + "2";
                break;
            }
            case 3: {
                string = string2 + string3.substring(0, 15) + "3";
                break;
            }
            case 4: {
                string = string2 + string3.substring(0, 15) + "4";
                break;
            }
            case 5: {
                string = string2 + string3.substring(0, 15) + "5";
                break;
            }
            default: {
                System.out.println("Unknown Asset Type");
            }
        }
        return string;
    }

    public String createSymLink(String string, String string2) {
        try {
            Runtime.getRuntime().exec("ln -s " + string + " " + string2);
        }
        catch (IOException iOException) {
            System.out.println("ERROR exec 'ln -s " + string + " " + string2);
            iOException.printStackTrace();
        }
        return "/bin/bash ln -s " + string + " " + string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            PackageBuilder.usage();
        }
        PackageBuilder packageBuilder = new PackageBuilder(new Integer(stringArray[0]));
        packageBuilder.run();
    }

    static void usage() {
        System.out.println("Usage: \n");
        System.out.println("  PackageBuilder number_of_packages");
        System.exit(-1);
    }
}

