/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.pbuilder;

import com.twc.isa.PackageModule.Package;
import com.twc.isa.PackageModule.PackageFactory;
import com.twc.isa.PackageModule.PackageFactoryHelper;
import com.twc.isa.PackageModule.PackageHelper;
import com.twc.isa.ServerModule.AdministrativeState;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class PackageExporter {
    static ORB orb;
    static String packageName;
    static String url;
    static String packageFactoryName;
    static NamingContextExt m_nameCtxExt;
    static PackageFactory packageFactory;

    static int run(ORB oRB, String[] stringArray) {
        try {
            packageName = System.getProperty("PackageName");
            url = System.getProperty("URL");
            packageFactoryName = System.getProperty("PackageFactoryName");
            PackageExporter.dbg("exporting Package " + packageName + " using url " + url);
            PackageExporter.exportPackage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return 0;
    }

    public static void exportPackage() {
        try {
            PackageExporter.locateFactory();
            Package package_ = PackageHelper.narrow((Object)packageFactory.createServant(packageName));
            package_.provision(AdministrativeState.as_InService, url);
            PackageExporter.dbg(packageName + " exported ");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void locateFactory() {
        try {
            String[] stringArray = new String[]{"Factories", packageFactoryName};
            Object object = PackageExporter.getFactoryObject(stringArray);
            packageFactory = PackageFactoryHelper.narrow((Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Object getFactoryObject(String[] stringArray) throws Exception {
        NamingContextExt namingContextExt = PackageExporter.getContext(stringArray, stringArray.length - 1);
        NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent(stringArray[stringArray.length - 1], "Factory")};
        Object object = namingContextExt.resolve(nameComponentArray);
        if (object == null) {
            throw new RuntimeException("Factory was null");
        }
        return object;
    }

    private static NamingContextExt getContext(String[] stringArray, int n) throws Exception {
        NameComponent[] nameComponentArray = new NameComponent[n];
        for (int i = 0; i < n; ++i) {
            nameComponentArray[i] = new NameComponent(stringArray[i], "Context");
        }
        Object object = m_nameCtxExt.resolve(nameComponentArray);
        return NamingContextExtHelper.narrow((Object)object);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            Properties properties = new Properties();
            properties.setProperty("ORBInitRef.NameService", System.getProperty("NameService"));
            orb = ORB.init((String[])new String[0], (Properties)properties);
            Object object = orb.resolve_initial_references("NameService");
            m_nameCtxExt = NamingContextExtHelper.narrow((Object)object);
            n = PackageExporter.run(orb, stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                n = 1;
            }
        }
        System.exit(n);
    }

    static void dbg(String string) {
        System.out.println("->" + string);
    }

    static {
        packageName = "noname.pkg";
        url = "invalid.url";
        packageFactoryName = "noname.factory";
        packageFactory = null;
    }
}

