/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.imr.Admin;
import org.jacorb.imr.AdminHelper;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.AdminPackage.FileOpFailed;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.ServerStartupDaemon;
import org.jacorb.imr.ServerStartupDaemonHelper;
import org.jacorb.imr.util.ImRPOATableModel;
import org.jacorb.imr.util.ImRServerTableModel;
import org.jacorb.util.Debug;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.UserException;

public class ImRModel {
    private Admin m_admin;
    private ORB m_orb = ORB.init(new String[0], null);
    private ServerInfo[] m_servers;
    private ImRInfo m_imr_info;
    private DefaultMutableTreeNode m_top_node;
    private JTree m_tree;
    private DefaultTreeModel m_tree_model;
    private ImRPOATableModel m_poa_model;
    private ImRServerTableModel m_server_model;
    private Hashtable m_server_names;
    private JComboBox m_host_selector;
    private DefaultComboBoxModel m_host_selector_model;
    private Hashtable m_host_names;
    private RefreshThread m_refresh_thread;
    protected int m_current_refresh_interval = 20000;
    protected boolean m_refresh_disabled = false;
    private Vector m_server_nodes;
    private Vector m_poa_nodes;

    public ImRModel() {
        try {
            this.m_admin = AdminHelper.narrow(this.m_orb.resolve_initial_references("ImplementationRepository"));
        }
        catch (InvalidName invalidName) {
            Debug.output(0, "WARNING: Could not contact Impl. Repository!");
            return;
        }
        this.fetchImRInfo();
        this.m_top_node = new DefaultMutableTreeNode(this.m_imr_info);
        this.m_tree_model = new DefaultTreeModel(this.m_top_node, false);
        this.m_tree = new JTree(this.m_tree_model);
        this.m_server_model = new ImRServerTableModel(this);
        this.m_poa_model = new ImRPOATableModel();
        this.m_server_names = new Hashtable();
        this.m_server_nodes = new Vector();
        this.m_poa_nodes = new Vector();
        this.m_host_names = new Hashtable();
        this.m_host_selector_model = new DefaultComboBoxModel();
        this.m_host_selector = new JComboBox(this.m_host_selector_model);
        this.m_host_selector.setEditable(true);
        this.fetchServers();
        this.m_tree.expandRow(0);
        this.m_refresh_thread = new RefreshThread(this.m_current_refresh_interval);
    }

    public void connectTo(String string) {
        try {
            this.m_admin = AdminHelper.narrow(this.m_orb.resolve_initial_references("ImplementationRepository"));
        }
        catch (InvalidName invalidName) {
            Debug.output(0, "WARNING: Could not contact Impl. Repository!");
            return;
        }
        this.fetchImRInfo();
        this.m_top_node.setUserObject(this.m_imr_info);
        this.fetchServers();
        this.setRefreshInterval(this.m_current_refresh_interval);
    }

    public JComboBox getHostSelector() {
        return this.m_host_selector;
    }

    public TableModel getPOATableModel() {
        return this.m_poa_model;
    }

    public TableModel getServerTableModel() {
        return this.m_server_model;
    }

    public void poaTableForServer(ServerInfo serverInfo) {
        this.m_poa_model.setPOAs(serverInfo.poas);
    }

    public void fetchServers() {
        this.m_servers = this.m_admin.list_servers();
        this.m_server_model.setServers(this.m_servers);
        this.m_server_names.clear();
        int n = 0;
        while (n < this.m_servers.length) {
            this.m_server_names.put(this.m_servers[n].name, new Integer(n));
            ++n;
        }
        String string = this.m_poa_model.getServerName();
        if (string != null) {
            this.m_poa_model.setPOAs(this.m_servers[this.indexForServerName((String)string)].poas);
        }
        this.buildTree();
        this.buildHostSelectorModel();
    }

    public void removeServer(String string) {
        this.removeServer(this.indexForServerName(string));
    }

    public void removeServer(int n) {
        try {
            this.m_admin.unregister_server(this.m_servers[n].name);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.fetchServers();
    }

    public void holdServer(String string) {
        this.holdServer(this.indexForServerName(string));
    }

    public void holdServer(int n) {
        try {
            this.m_admin.hold_server(this.m_servers[n].name);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.refreshServer(n);
    }

    public void releaseServer(String string) {
        this.releaseServer(this.indexForServerName(string));
    }

    public void releaseServer(int n) {
        try {
            this.m_admin.release_server(this.m_servers[n].name);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.refreshServer(n);
    }

    public void refreshServer(String string) {
        this.refreshServer(this.indexForServerName(string));
    }

    public void refreshServer(int n) {
        try {
            ServerInfo serverInfo;
            this.m_servers[n] = serverInfo = this.m_admin.get_server_info(this.m_servers[n].name);
            this.buildServerNode(n);
            this.m_server_model.serverRefreshed(n);
            if (this.m_host_names.put(this.m_servers[n].host, this.m_servers[n].host) == null) {
                this.m_host_selector_model.addElement(this.m_servers[n].host);
            }
            if (serverInfo.name.equals(this.m_poa_model.getServerName())) {
                this.m_poa_model.setPOAs(serverInfo.poas);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void setServerDown(String string) {
        this.setServerDown(this.indexForServerName(string));
    }

    public void setServerDown(int n) {
        Registration registration = RegistrationHelper.narrow(this.m_admin);
        try {
            registration.set_server_down(this.m_servers[n].name);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.refreshServer(this.m_servers[n].name);
    }

    public void addServer(String string, String string2, String string3) {
        try {
            this.m_admin.register_server(string, string2, string3);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.fetchServers();
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public void imrShutdown(boolean bl) {
        this.disableRefresh();
        try {
            this.m_admin.shutdown(bl);
            this.m_top_node.removeAllChildren();
            this.m_servers = null;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void saveTable() {
        try {
            this.m_admin.save_server_table();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public int getRow(ServerInfo serverInfo, POAInfo pOAInfo) {
        int n = 0;
        while (n < serverInfo.poas.length) {
            if (serverInfo.poas[n] == pOAInfo) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setRefreshInterval(int n) {
        this.m_current_refresh_interval = n;
        this.m_refresh_disabled = false;
        this.m_refresh_thread.setInterval(n);
    }

    public void disableRefresh() {
        this.m_refresh_disabled = true;
        this.m_refresh_thread.setInterval(0L);
    }

    protected void updateServer(int n, String string, Object object) {
        String string2 = this.m_servers[n].host;
        String string3 = this.m_servers[n].command;
        if (object instanceof String) {
            if (string.equals("Host")) {
                string2 = (String)object;
                if (this.m_host_names.put(object, object) == null) {
                    this.m_host_selector_model.addElement(object);
                }
            } else if (string.equals("Command")) {
                string3 = (String)object;
            }
            try {
                this.m_admin.edit_server(this.m_servers[n].name, string3, string2);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else if (object instanceof Boolean) {
            if (string.equals("active")) {
                if (!((Boolean)object).booleanValue()) {
                    this.setServerDown(this.m_servers[n].name);
                }
            } else if (string.equals("holding")) {
                try {
                    if (((Boolean)object).booleanValue()) {
                        this.m_admin.hold_server(this.m_servers[n].name);
                    } else {
                        this.m_admin.release_server(this.m_servers[n].name);
                    }
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            }
        }
        this.refreshServer(this.m_servers[n].name);
    }

    private void handleException(Exception exception) {
        if (exception instanceof UserException) {
            String string = exception.toString();
            if (exception instanceof IllegalServerName) {
                string = "The specified server name is not allowed";
            } else if (exception instanceof DuplicateServerName) {
                string = "A server with name " + ((DuplicateServerName)exception).name + " has already been registered with the repository";
            } else if (exception instanceof FileOpFailed) {
                string = "The backup operation failed";
            }
            JOptionPane.showMessageDialog(new JFrame(), string, "An error occurred", 0);
        } else {
            Debug.output(2050, exception);
        }
    }

    private void buildHostSelectorModel() {
        HostInfo[] hostInfoArray = this.m_admin.list_hosts();
        int n = 0;
        while (n < hostInfoArray.length) {
            try {
                ServerStartupDaemon serverStartupDaemon = ServerStartupDaemonHelper.narrow(this.m_orb.string_to_object(hostInfoArray[n].ior_string));
                serverStartupDaemon.get_system_load();
                serverStartupDaemon._release();
                if (this.m_host_names.put(hostInfoArray[n].name, hostInfoArray[n].name) == null) {
                    this.m_host_selector_model.addElement(hostInfoArray[n].name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_servers.length) {
            if (this.m_host_names.put(this.m_servers[n2].host, this.m_servers[n2].host) == null) {
                this.m_host_selector_model.addElement(this.m_servers[n2].host);
            }
            ++n2;
        }
    }

    private int indexForServerName(String string) {
        return (Integer)this.m_server_names.get(string);
    }

    private void fetchImRInfo() {
        Registration registration = RegistrationHelper.narrow(this.m_admin);
        this.m_imr_info = registration.get_imr_info();
    }

    private void buildServerNode(int n) {
        Vector<DefaultMutableTreeNode> vector;
        DefaultMutableTreeNode defaultMutableTreeNode;
        POAInfo[] pOAInfoArray = this.m_servers[n].poas;
        if (n < this.m_server_nodes.size()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_server_nodes.elementAt(n);
            vector = (Vector<DefaultMutableTreeNode>)this.m_poa_nodes.elementAt(n);
        } else {
            defaultMutableTreeNode = new DefaultMutableTreeNode(this.m_servers[n]);
            this.m_server_nodes.addElement(defaultMutableTreeNode);
            this.m_tree_model.insertNodeInto(defaultMutableTreeNode, this.m_top_node, n);
            this.m_tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            vector = new Vector<DefaultMutableTreeNode>();
            this.m_poa_nodes.addElement(vector);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            if (n2 >= pOAInfoArray.length) break;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)vector.elementAt(n2);
            defaultMutableTreeNode2.setUserObject(pOAInfoArray[n2]);
            ++n2;
        }
        if (n2 >= pOAInfoArray.length) {
            int n3 = vector.size() - 1;
            while (n3 >= n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)vector.elementAt(n3);
                vector.removeElementAt(n3);
                this.m_tree_model.removeNodeFromParent(defaultMutableTreeNode3);
                --n3;
            }
        } else {
            int n4 = n2;
            while (n4 < pOAInfoArray.length) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(pOAInfoArray[n4]);
                vector.addElement(defaultMutableTreeNode4);
                this.m_tree_model.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode, n4);
                ++n4;
            }
        }
    }

    private void removeServerNode(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_server_nodes.elementAt(n);
        Vector vector = (Vector)this.m_poa_nodes.elementAt(n);
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)vector.elementAt(n2);
            vector.removeElementAt(n2);
            this.m_tree_model.removeNodeFromParent(defaultMutableTreeNode2);
            --n2;
        }
        this.m_server_nodes.removeElementAt(n);
        this.m_tree_model.removeNodeFromParent(defaultMutableTreeNode);
    }

    private void buildTree() {
        int n = 0;
        while (n < this.m_server_nodes.size()) {
            if (n >= this.m_servers.length) break;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_server_nodes.elementAt(n);
            defaultMutableTreeNode.setUserObject(this.m_servers[n]);
            this.buildServerNode(n);
            ++n;
        }
        if (n >= this.m_servers.length) {
            int n2 = this.m_server_nodes.size() - 1;
            while (n2 >= n) {
                this.removeServerNode(n2);
                --n2;
            }
        } else {
            int n3 = n;
            while (n3 < this.m_servers.length) {
                this.buildServerNode(n3);
                ++n3;
            }
        }
    }

    private class RefreshThread
    extends Thread {
        private long m_interval;
        private boolean m_run = true;

        public RefreshThread(long l) {
            this.m_interval = l;
            this.start();
        }

        public synchronized void run() {
            while (true) {
                if (this.m_interval <= 0L) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        ImRModel.this.handleException(exception);
                    }
                    continue;
                }
                try {
                    ImRModel.this.fetchServers();
                }
                catch (Exception exception) {
                    ImRModel.this.handleException(exception);
                }
                try {
                    this.wait(this.m_interval);
                    continue;
                }
                catch (Exception exception) {
                    ImRModel.this.handleException(exception);
                    continue;
                }
                break;
            }
        }

        public synchronized void setInterval(long l) {
            this.m_interval = l;
            this.notifyAll();
        }
    }
}

