/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.PrintStream;
import org.jacorb.orb.TypeCode;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.AliasDefHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.AttributeDescription;
import org.omg.CORBA.AttributeDescriptionHelper;
import org.omg.CORBA.AttributeMode;
import org.omg.CORBA.ConstantDescription;
import org.omg.CORBA.ConstantDescriptionHelper;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.EnumDefHelper;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.ExceptionDescription;
import org.omg.CORBA.ExceptionDescriptionHelper;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.InterfaceDescriptionHelper;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.ModuleDescription;
import org.omg.CORBA.ModuleDescriptionHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationDescriptionHelper;
import org.omg.CORBA.OperationMode;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeDescription;
import org.omg.CORBA.TypeDescriptionHelper;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionDefHelper;
import org.omg.CORBA.UnionMember;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynEnumHelper;

public class IdlWriter {
    private PrintStream ps;
    private int indent = 0;
    private ORB orb;
    private Repository ir = null;
    private DynAnyFactory factory;

    public IdlWriter(PrintStream printStream) {
        this.ps = printStream;
        try {
            this.orb = ORB.init((String[])null, null);
            this.ir = RepositoryHelper.narrow(this.orb.resolve_initial_references("InterfaceRepository"));
            this.factory = DynAnyFactoryHelper.narrow(this.orb.resolve_initial_references("DynAnyFactory"));
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
        if (this.ir == null) {
            System.err.println("No IR configured! Exiting..");
            System.exit(1);
        }
    }

    public IdlWriter(PrintStream printStream, Repository repository) {
        this.ps = printStream;
        try {
            this.orb = ORB.init((String[])null, null);
            this.ir = repository;
            this.factory = DynAnyFactoryHelper.narrow(this.orb.resolve_initial_references("DynAnyFactory"));
        }
        catch (InvalidName invalidName) {}
    }

    public void close() {
        this.ps.flush();
        this.ps.close();
    }

    private void indent(int n) {
        this.indent = n;
    }

    private void print(String string) {
        int n = 0;
        while (n < this.indent) {
            this.ps.print(" ");
            ++n;
        }
        this.ps.print(string);
    }

    public void printContained(Contained contained, int n) {
        Description description = contained.describe();
        switch (description.kind.value()) {
            case 6: {
                this.printModule(ModuleDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 5: {
                InterfaceDef interfaceDef = InterfaceDefHelper.narrow(this.ir.lookup_id(InterfaceDescriptionHelper.extract((Any)description.value).id));
                this.printInterface(interfaceDef, n + 3);
                break;
            }
            case 2: {
                this.printAttribute(AttributeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 7: {
                this.printOperation(OperationDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 4: {
                this.printException(ExceptionDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 3: {
                this.printConstant(ConstantDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 10: {
                this.printStruct(TypeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 12: {
                this.printEnum(TypeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 11: {
                this.printUnion(TypeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 9: {
                this.printAlias(TypeDescriptionHelper.extract(description.value), n + 3);
            }
        }
    }

    public void printModule(ModuleDescription moduleDescription, int n) {
        this.indent(n);
        ModuleDef moduleDef = ModuleDefHelper.narrow(this.ir.lookup_id(moduleDescription.id));
        this.print("module " + moduleDef.name() + "\n");
        this.print("{\n");
        Contained[] containedArray = moduleDef.contents(DefinitionKind.dk_all, true);
        int n2 = 0;
        while (n2 < containedArray.length) {
            this.printContained(containedArray[n2], n);
            ++n2;
        }
        this.indent(n);
        this.print("};\n\n");
    }

    public void printInterface(InterfaceDef interfaceDef, int n) {
        FullInterfaceDescription fullInterfaceDescription = interfaceDef.describe_interface();
        Contained[] containedArray = interfaceDef.contents(DefinitionKind.dk_all, true);
        this.indent(n);
        StringBuffer stringBuffer = new StringBuffer();
        if (fullInterfaceDescription.base_interfaces.length > 0) {
            stringBuffer.append(" : " + fullInterfaceDescription.base_interfaces[0]);
        }
        int n2 = 1;
        while (n2 < fullInterfaceDescription.base_interfaces.length) {
            stringBuffer.append(", " + fullInterfaceDescription.base_interfaces[n2]);
            ++n2;
        }
        this.print("interface " + fullInterfaceDescription.name + stringBuffer.toString() + "\n");
        this.print("{\n");
        int n3 = 0;
        while (n3 < containedArray.length) {
            this.printContained(containedArray[n3], n);
            ++n3;
        }
        this.indent(n);
        this.print("};\n\n");
    }

    public void printException(ExceptionDescription exceptionDescription, int n) {
        ExceptionDef exceptionDef = ExceptionDefHelper.narrow(this.ir.lookup_id(exceptionDescription.id));
        if (exceptionDef != null) {
            StructMember[] structMemberArray = exceptionDef.members();
            this.indent(n);
            this.print("exception " + exceptionDescription.name + " {" + "\n");
            this.indent(n + 3);
            int n2 = 0;
            while (n2 < structMemberArray.length) {
                this.print(this.idlTypeName(structMemberArray[n2].type) + " " + structMemberArray[n2].name + ";" + "\n");
                ++n2;
            }
            this.indent(n);
            this.print("};\n\n");
        } else {
            System.err.println("Error, could not find excpetion " + exceptionDescription.id + " in IR ");
        }
    }

    public void printStruct(TypeDescription typeDescription, int n) {
        StructDef structDef = StructDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        if (structDef != null) {
            StructMember[] structMemberArray = structDef.members();
            Contained[] containedArray = structDef.contents(DefinitionKind.dk_all, false);
            this.indent(n);
            this.print("struct " + structDef.name() + " {" + "\n");
            this.indent(n + 3);
            int n2 = 0;
            while (n2 < structMemberArray.length) {
                this.print(this.idlTypeName(structMemberArray[n2].type) + " " + structMemberArray[n2].name + ";" + "\n");
                ++n2;
            }
            int n3 = 0;
            while (n3 < containedArray.length) {
                this.printContained(containedArray[n3], n);
                ++n3;
            }
            this.indent(n);
            this.print("};\n\n");
        } else {
            System.err.println("Error, could not find struct " + structDef.id() + " in IR ");
        }
    }

    public void printConstant(ConstantDescription constantDescription, int n) {
        this.indent(n);
        StringBuffer stringBuffer = new StringBuffer("const " + this.idlTypeName(constantDescription.type) + " " + constantDescription.name + " = ");
        switch (constantDescription.type.kind().value()) {
            case 18: {
                stringBuffer.append("\"" + constantDescription.value.extract_string() + "\"");
                break;
            }
            case 27: {
                stringBuffer.append("\"" + constantDescription.value.extract_wstring() + "\"");
                break;
            }
            case 8: {
                stringBuffer.append(constantDescription.value.extract_boolean());
                break;
            }
            case 3: {
                stringBuffer.append(constantDescription.value.extract_long());
                break;
            }
            case 5: {
                stringBuffer.append(constantDescription.value.extract_ulong());
                break;
            }
            case 23: {
                stringBuffer.append(constantDescription.value.extract_longlong());
                break;
            }
            case 24: {
                stringBuffer.append(constantDescription.value.extract_ulonglong());
                break;
            }
            case 2: {
                stringBuffer.append(constantDescription.value.extract_short());
                break;
            }
            case 4: {
                stringBuffer.append(constantDescription.value.extract_ushort());
                break;
            }
            case 6: {
                stringBuffer.append(constantDescription.value.extract_float());
                break;
            }
            case 10: {
                stringBuffer.append(constantDescription.value.extract_octet());
                break;
            }
            case 9: {
                stringBuffer.append("'" + constantDescription.value.extract_char() + "'");
                break;
            }
            case 26: {
                stringBuffer.append("'" + constantDescription.value.extract_wchar() + "'");
                break;
            }
            case 28: {
                stringBuffer.append(constantDescription.value.extract_fixed());
            }
        }
        this.print(stringBuffer.toString() + ";\n\n");
    }

    public void printAttribute(AttributeDescription attributeDescription, int n) {
        this.indent(n);
        String string = "";
        if (attributeDescription.mode.equals(AttributeMode.ATTR_READONLY)) {
            string = "readonly ";
        }
        this.print(string + "attribute " + this.idlTypeName(attributeDescription.type) + " " + attributeDescription.name + ";" + "\n");
    }

    public void printEnum(TypeDescription typeDescription, int n) {
        EnumDef enumDef = EnumDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        if (enumDef != null) {
            String[] stringArray = enumDef.members();
            this.indent(n);
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray.length > 0) {
                stringBuffer.append(stringArray[0]);
            }
            int n2 = 1;
            while (n2 < stringArray.length) {
                stringBuffer.append("," + stringArray[n2]);
                ++n2;
            }
            this.print("enum " + enumDef.name() + " {" + stringBuffer + "};" + "\n\n");
        } else {
            System.err.println("Error, could not find enum " + enumDef.id() + " in IR ");
        }
    }

    public void printUnion(TypeDescription typeDescription, int n) {
        UnionDef unionDef = UnionDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        if (unionDef != null) {
            UnionMember[] unionMemberArray = unionDef.members();
            this.indent(n);
            this.print("union " + unionDef.name() + " switch ( " + this.idlTypeName(unionDef.discriminator_type()) + " )\n");
            this.print("{\n");
            this.indent(n + 4);
            int n2 = -1;
            int n3 = 0;
            while (n3 < unionMemberArray.length) {
                if (unionMemberArray[n3].label.type().kind() == TCKind.tk_octet && unionMemberArray[n3].label.extract_octet() == 0) {
                    n2 = n3;
                } else if (unionMemberArray[n3].label.type().kind() == TCKind.tk_char) {
                    this.print("case '" + unionMemberArray[n3].label.extract_char() + "' : " + this.idlTypeName(unionMemberArray[n3].type) + " " + unionMemberArray[n3].name + ";" + "\n");
                } else if (unionMemberArray[n3].label.type().kind() == TCKind.tk_enum) {
                    try {
                        DynEnum dynEnum = DynEnumHelper.narrow(this.factory.create_dyn_any(unionMemberArray[n3].label));
                        this.print("case " + dynEnum.get_as_string() + " : " + this.idlTypeName(unionMemberArray[n3].type) + " " + unionMemberArray[n3].name + ";" + "\n");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    this.print("case " + unionMemberArray[n3].label.type() + " : " + this.idlTypeName(unionMemberArray[n3].type) + " " + unionMemberArray[n3].name + ";" + "\n");
                }
                ++n3;
            }
            if (n2 != -1) {
                this.print("default : " + this.idlTypeName(unionMemberArray[n2].type) + " " + unionMemberArray[n2].name + ";" + "\n");
            }
            this.indent(n);
            this.print("};\n\n");
        } else {
            System.err.println("Error, could not find union " + unionDef.id() + " in IR ");
        }
    }

    public void printAlias(TypeDescription typeDescription, int n) {
        AliasDef aliasDef = AliasDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        this.indent(n);
        String string = this.idlTypeName(aliasDef.original_type_def().type());
        this.print("typedef " + string + " " + aliasDef.name() + ";\n\n");
    }

    public void printOperation(OperationDescription operationDescription, int n) {
        this.indent(n);
        String string = "";
        if (operationDescription.mode.equals(OperationMode.OP_ONEWAY)) {
            string = "oneway ";
        }
        this.print(string + this.idlTypeName(operationDescription.result) + " " + operationDescription.name + "(");
        this.indent(0);
        int n2 = 0;
        while (n2 < operationDescription.parameters.length - 1) {
            this.printParameter(operationDescription.parameters[n2], ",");
            ++n2;
        }
        if (operationDescription.parameters.length > 0) {
            this.printParameter(operationDescription.parameters[operationDescription.parameters.length - 1], "");
        }
        this.print(")");
        if (operationDescription.exceptions.length > 0) {
            this.print(" raises (");
            this.print(this.idlTypeName(operationDescription.exceptions[0].type));
            int n3 = 1;
            while (n3 < operationDescription.exceptions.length) {
                this.print(this.idlTypeName(operationDescription.exceptions[0].type) + ",");
                ++n3;
            }
            this.print(")");
        }
        this.print(";\n");
        this.indent(n);
    }

    public void printParameter(ParameterDescription parameterDescription, String string) {
        if (parameterDescription.mode.equals(ParameterMode.PARAM_OUT)) {
            this.print("out ");
        } else if (parameterDescription.mode.equals(ParameterMode.PARAM_INOUT)) {
            this.print("inout ");
        } else {
            this.print("in ");
        }
        this.print(this.idlTypeName(parameterDescription.type) + " " + parameterDescription.name);
        this.print(string);
    }

    private String idlTypeName(org.omg.CORBA.TypeCode typeCode) {
        return ((TypeCode)typeCode).idlTypeName();
    }
}

