/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.naming.BindingIteratorImpl;
import org.jacorb.naming.Name;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class NamingContextImpl
extends NamingContextExtPOA
implements Serializable {
    private Hashtable names = new Hashtable();
    private Hashtable contexts = new Hashtable();
    private transient POA poa;
    private transient POA rootPoa;
    private transient ORB orb;
    private int child_count;
    private boolean destroyed = false;

    public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        if (object == null) {
            throw new BAD_PARAM();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (name2 == null) {
            if (this.names.containsKey(name)) {
                Object object2 = (Object)this.names.get(name);
                if (object2._non_existent()) {
                    this.rebind(name.components(), object);
                    return;
                }
                throw new AlreadyBound();
            }
            if (this.contexts.containsKey(name)) {
                Object object3 = (Object)this.contexts.get(name);
                if (object3._non_existent()) {
                    this.unbind(name.components());
                }
                throw new AlreadyBound();
            }
            if (this.names.put(name, object) != null) {
                throw new CannotProceed(this._this(), name.components());
            }
            Debug.output(1, "Bound name: " + name.toString());
        } else {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExtHelper.narrow(this.resolve(name2.components())).bind(nameComponentArray2, object);
        }
    }

    public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        if (object == null) {
            throw new BAD_PARAM();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (this.contexts.containsKey(name)) {
            throw new NotFound(NotFoundReason.not_object, new NameComponent[]{nameComponent});
        }
        Object object2 = (Object)this.names.remove(name);
        if (object2 != null) {
            object2._release();
        }
        if (name2 == null) {
            this.names.put(name, object);
            Debug.output(1, "Re-bound name: " + name.toString());
        } else {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.resolve(name2.components()));
            if (namingContextExt == null) {
                throw new CannotProceed();
            }
            namingContextExt.rebind(nameComponentArray2, object);
        }
    }

    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        if (namingContext == null) {
            throw new BAD_PARAM();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (this.names.containsKey(name)) {
            throw new NotFound(NotFoundReason.not_context, new NameComponent[]{nameComponent});
        }
        Object object = (Object)this.contexts.remove(name);
        if (object != null) {
            object._release();
        }
        if (name2 == null) {
            this.contexts.put(name, namingContext);
            Debug.output(1, "Re-Bound context: " + name.baseNameComponent().id);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (name2 == null) {
            if (this.names.containsKey(name)) {
                Object object = (Object)this.names.get(name);
                if (!object._non_existent()) throw new AlreadyBound();
                this.unbind(name.components());
            } else if (this.contexts.containsKey(name)) {
                Object object = (Object)this.contexts.get(name);
                if (!object._non_existent()) throw new AlreadyBound();
                this.rebind_context(name.components(), namingContext);
                return;
            }
            if (this.contexts.put(name, namingContext) != null) {
                throw new CannotProceed(this._this(), name.components());
            }
            this.contexts.put(name, namingContext);
            Debug.output(1, "Bound context: " + name.toString());
            return;
        } else {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExtHelper.narrow(this.resolve(name2.components())).bind_context(nameComponentArray2, namingContext);
        }
    }

    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.new_context());
        this.bind_context(nameComponentArray, namingContextExt);
        if (namingContextExt == null) {
            throw new CannotProceed();
        }
        return namingContextExt;
    }

    private void cleanup() {
        java.lang.Object object;
        if (!Environment.isPropertyOn("jacorb.naming.purge")) {
            return;
        }
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        Enumeration enumeration = this.names.keys();
        while (enumeration.hasMoreElements()) {
            object = (Name)enumeration.nextElement();
            if (!((Object)this.names.get(object))._non_existent()) continue;
            Debug.output(1, "removing name " + ((Name)object).baseNameComponent().id);
            vector.addElement(object);
        }
        if (vector.size() > 0) {
            int n = vector.size();
            while (n-- > 0) {
                this.names.remove((Name)vector.elementAt(n));
            }
            vector.removeAllElements();
        }
        object = this.contexts.keys();
        while (object.hasMoreElements()) {
            Name name = (Name)object.nextElement();
            if (!((Object)this.contexts.get(name))._non_existent()) continue;
            Debug.output(1, "removing context " + name.baseNameComponent().id);
            vector.addElement(name);
        }
        if (vector.size() > 0) {
            int n = vector.size();
            while (n-- > 0) {
                this.contexts.remove((Name)vector.elementAt(n));
            }
            vector.removeAllElements();
        }
    }

    public void destroy() throws NotEmpty {
        if (this.destroyed) {
            return;
        }
        if (!this.names.isEmpty() || !this.contexts.isEmpty()) {
            throw new NotEmpty();
        }
        this.names = null;
        this.contexts = null;
        this.destroyed = true;
    }

    public int how_many() {
        if (this.destroyed) {
            return 0;
        }
        return this.names.size() + this.contexts.size();
    }

    private Binding[] list() {
        this.cleanup();
        int n = this.how_many();
        Enumeration enumeration = this.names.keys();
        Enumeration enumeration2 = this.contexts.keys();
        Binding[] bindingArray = new Binding[n];
        while (enumeration.hasMoreElements() && n > 0) {
            bindingArray[n - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
            --n;
        }
        while (enumeration2.hasMoreElements() && n > 0) {
            bindingArray[n - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
            --n;
        }
        return bindingArray;
    }

    public void list(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        Binding[] bindingArray;
        if (this.destroyed) {
            return;
        }
        this.cleanup();
        int n2 = this.how_many();
        Enumeration enumeration = this.names.keys();
        Enumeration enumeration2 = this.contexts.keys();
        if (n < n2) {
            int n3 = n;
            bindingArray = new Binding[n];
            while (enumeration.hasMoreElements() && n3 > 0) {
                bindingArray[n3 - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
                --n3;
            }
            while (enumeration2.hasMoreElements() && n3 > 0) {
                bindingArray[n3 - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
                --n3;
            }
            Binding[] bindingArray2 = new Binding[n2 -= n];
            while (enumeration.hasMoreElements() && n2 > 0) {
                bindingArray2[n2 - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
                --n2;
            }
            while (enumeration2.hasMoreElements() && n2 > 0) {
                bindingArray2[n2 - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
                --n2;
            }
            Object object = null;
            try {
                byte[] byArray = this.rootPoa.activate_object(new BindingIteratorImpl(bindingArray2));
                object = this.rootPoa.id_to_reference(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bindingIteratorHolder.value = BindingIteratorHelper.narrow(object);
        } else {
            bindingArray = new Binding[n2];
            while (enumeration.hasMoreElements() && n2 > 0) {
                bindingArray[n2 - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
                --n2;
            }
            while (enumeration2.hasMoreElements() && n2 > 0) {
                bindingArray[n2 - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
                --n2;
            }
        }
        bindingListHolder.value = bindingArray;
    }

    public NamingContext new_context() {
        if (this.destroyed) {
            return null;
        }
        Object object = null;
        try {
            byte[] byArray = (new String(this.poa.servant_to_id(this)) + "_ctx" + ++this.child_count).getBytes();
            object = this.poa.create_reference_with_id(byArray, "IDL:omg.org/CosNaming/NamingContextExt:1.0");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return NamingContextExtHelper.narrow(object);
    }

    public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        Name name = new Name(nameComponentArray[0]);
        if (nameComponentArray.length > 1) {
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow((Object)this.contexts.get(name));
            if (namingContextExt == null || namingContextExt._non_existent()) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
            int n = 1;
            while (n < nameComponentArray.length) {
                nameComponentArray2[n - 1] = nameComponentArray[n];
                ++n;
            }
            return namingContextExt.resolve(nameComponentArray2);
        }
        Object object = null;
        object = (Object)this.contexts.get(name);
        if (object == null) {
            object = (Object)this.names.get(name);
        }
        if (object == null || object._non_existent()) {
            throw new NotFound(NotFoundReason.missing_node, name.components());
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null) throw new InvalidName();
        if (nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (name2 != null) {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExtHelper.narrow(this.resolve(name2.components())).unbind(nameComponentArray2);
            return;
        }
        if (this.names.containsKey(name)) {
            Object object = (Object)this.names.remove(name);
            object._release();
            Debug.output(1, "Unbound: " + name.toString());
            return;
        }
        if (this.contexts.containsKey(name)) {
            Object object = (Object)this.contexts.remove(name);
            object._release();
            Debug.output(1, "Unbound: " + name.toString());
            return;
        }
        Debug.output(1, "Unbind failed for " + name.toString());
        throw new NotFound(NotFoundReason.not_context, name.components());
    }

    public POA default_POA() {
        return this.poa;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        java.lang.Object object;
        java.lang.Object object2;
        Enumeration enumeration = this.contexts.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (Name)enumeration.nextElement();
            object = (Object)this.contexts.remove(object2);
            this.contexts.put(object2, this.orb.object_to_string((Object)object));
        }
        object2 = this.names.keys();
        while (object2.hasMoreElements()) {
            object = (Name)object2.nextElement();
            Object object3 = (Object)this.names.remove(object);
            this.names.put(object, this.orb.object_to_string(object3));
        }
        objectOutputStream.defaultWriteObject();
    }

    void init(ORB oRB, POA pOA) {
        java.lang.Object object;
        java.lang.Object object2;
        this.poa = pOA;
        this.orb = oRB;
        try {
            this.rootPoa = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            invalidName.printStackTrace();
        }
        Enumeration enumeration = this.contexts.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (Name)enumeration.nextElement();
            object = (String)this.contexts.remove(object2);
            this.contexts.put(object2, oRB.string_to_object((String)object));
        }
        object2 = this.names.keys();
        while (object2.hasMoreElements()) {
            object = (Name)object2.nextElement();
            String string = (String)this.names.remove(object);
            this.names.put(object, oRB.string_to_object(string));
        }
    }

    public String to_string(NameComponent[] nameComponentArray) throws InvalidName {
        return Name.toString(nameComponentArray);
    }

    public NameComponent[] to_name(String string) throws InvalidName {
        return Name.toName(string);
    }

    public String to_url(String string, String string2) throws InvalidAddress, InvalidName {
        try {
            CorbaLoc corbaLoc = new CorbaLoc(string);
            return corbaLoc.toCorbaName(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAddress();
        }
    }

    public Object resolve_str(String string) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(string));
    }
}

