/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jacorb.orb.connection.CloseConnectionException;
import org.jacorb.orb.connection.TCP_IP_Transport;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.TRANSIENT;

public class Client_TCP_IP_Transport
extends TCP_IP_Transport {
    private String target_host;
    private int target_port;
    private SocketFactory socket_factory;
    private int timeout;
    private boolean closed;
    private boolean connected;

    public Client_TCP_IP_Transport(String string, int n, SocketFactory socketFactory) {
        block2: {
            this.target_host = null;
            this.target_port = -1;
            this.socket_factory = null;
            this.timeout = 0;
            this.closed = false;
            this.connected = false;
            this.target_host = string;
            this.target_port = n;
            this.socket_factory = socketFactory;
            this.connection_info = string + ':' + n;
            String string2 = Environment.getProperty("jacorb.connection.client_idle_timeout");
            if (string2 == null) break block2;
            try {
                this.timeout = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.output(1, "Unable to create int from string >" + string2 + '<');
                Debug.output(1, "Please check property \"jacorb.connection.client_idle_timeout\"");
            }
        }
    }

    protected synchronized void waitUntilConnected() throws IOException {
        while (!this.connected && !this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.closed) {
            throw new CloseConnectionException();
        }
    }

    protected synchronized void connect() {
        if (!this.connected) {
            Debug.output(3, "Trying to connect to " + this.connection_info);
            int n = Environment.noOfRetries();
            while (n > 0) {
                try {
                    this.socket = this.socket_factory.createSocket(this.target_host, this.target_port);
                    if (this.timeout != 0) {
                        this.socket.setSoTimeout(this.timeout);
                    }
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    Debug.output(1, "Connected to " + this.connection_info + (this.socket_factory.isSSL(this.socket) ? " via SSL" : ""));
                    this.connected = true;
                    this.notifyAll();
                    return;
                }
                catch (IOException iOException) {
                    Debug.output(1, "Retrying to connect to " + this.connection_info);
                    try {
                        Thread.sleep(Environment.retryInterval());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --n;
                }
            }
            if (n == 0) {
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    protected synchronized void close(int n) throws IOException {
        if (this.connected && this.socket != null) {
            try {
                Method method = this.socket.getClass().getMethod("shutdownOutput", new Class[0]);
                method.invoke((Object)this.socket, new Object[0]);
                method = this.socket.getClass().getMethod("shutdownInput", new Class[0]);
                method.invoke((Object)this.socket, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket.close();
            if (this.in_stream != null) {
                this.in_stream.close();
            }
            if (this.out_stream != null) {
                this.out_stream.close();
            }
            Debug.output(2, "Closed client-side TCP/IP transport to " + this.connection_info);
        }
        this.connected = false;
        if (n == 0) {
            this.closed = true;
            this.notifyAll();
        }
    }

    public boolean isSSL() {
        return this.socket_factory.isSSL(this.socket);
    }
}

