/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.CloseConnectionException;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.orb.connection.ConnectionListener;
import org.jacorb.orb.connection.MessageOutputStream;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ReplyListener;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.orb.connection.RequestListener;
import org.jacorb.orb.connection.StreamClosedException;
import org.jacorb.orb.connection.TimeOutException;
import org.jacorb.orb.connection.Transport;
import org.jacorb.util.Debug;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.GIOP.ReplyStatusType_1_2;

public final class GIOPConnection
extends OutputStream {
    private Transport transport = null;
    private RequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    private ConnectionListener connection_listener = null;
    private boolean writer_active = false;
    private Object write_sync = new Object();
    private int TCS = CodeSet.getTCSDefault();
    private int TCSW = CodeSet.getTCSWDefault();
    private boolean tcs_negotiated = false;
    private Hashtable fragments = null;
    private BufferManager buf_mg = null;

    public GIOPConnection(Transport transport, RequestListener requestListener, ReplyListener replyListener) {
        this.transport = transport;
        this.request_listener = requestListener;
        this.reply_listener = replyListener;
        this.fragments = new Hashtable();
        this.buf_mg = BufferManager.getInstance();
    }

    public final void setCodeSets(int n, int n2) {
        this.TCS = n;
        this.TCSW = n2;
        this.tcs_negotiated = true;
    }

    public final int getTCS() {
        return this.TCS;
    }

    public final int getTCSW() {
        return this.TCSW;
    }

    public final void markTCSNegotiated() {
        this.tcs_negotiated = true;
    }

    public final boolean isTCSNegotiated() {
        return this.tcs_negotiated;
    }

    private final synchronized RequestListener getRequestListener() {
        return this.request_listener;
    }

    public final synchronized void setRequestListener(RequestListener requestListener) {
        this.request_listener = requestListener;
    }

    private final synchronized ReplyListener getReplyListener() {
        return this.reply_listener;
    }

    public final synchronized void setReplyListener(ReplyListener replyListener) {
        this.reply_listener = replyListener;
    }

    public final void setConnectionListener(ConnectionListener connectionListener) {
        this.connection_listener = connectionListener;
    }

    public final Transport getTransport() {
        return this.transport;
    }

    public final void receiveMessages() throws IOException {
        block14: while (true) {
            OutputStream outputStream;
            byte[] byArray;
            block30: {
                byArray = null;
                try {
                    byArray = this.transport.getMessage();
                }
                catch (CloseConnectionException closeConnectionException) {
                    if (this.connection_listener != null) {
                        this.connection_listener.connectionClosed();
                    }
                    throw closeConnectionException;
                }
                catch (TimeOutException timeOutException) {
                    if (this.connection_listener != null) {
                        this.connection_listener.connectionTimedOut();
                    }
                }
                catch (StreamClosedException streamClosedException) {
                    if (this.connection_listener == null) break block30;
                    this.connection_listener.streamClosed();
                }
            }
            if (byArray == null) continue;
            if (Messages.getGIOPMajor(byArray) != 1) {
                Debug.output(1, "ERROR: Invalid GIOP major version encountered: " + Messages.getGIOPMajor(byArray));
                Debug.output(3, "GIOPConnection.receiveMessages()", byArray);
                continue;
            }
            int n = Messages.getMsgType(byArray);
            if (n == 7) {
                if (Messages.getGIOPMinor(byArray) == 0) {
                    Debug.output(1, "WARNING: Received a GIOP 1.0 message of type Fragment");
                    MessageOutputStream messageOutputStream = new MessageOutputStream();
                    messageOutputStream.writeGIOPMsgHeader(6, 0);
                    messageOutputStream.insertMsgSize();
                    this.sendMessage(messageOutputStream);
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                if (Messages.getGIOPMinor(byArray) == 1) {
                    Debug.output(1, "WARNING: Received a GIOP 1.1 Fragment message");
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                Integer n2 = new Integer(Messages.getRequestId(byArray));
                if (!this.fragments.containsKey(n2)) {
                    Debug.output(1, "ERROR: No previous Fragment to this one");
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                outputStream = (ByteArrayOutputStream)this.fragments.get(n2);
                ((ByteArrayOutputStream)outputStream).write(byArray, Messages.MSG_HEADER_SIZE + 4, Messages.getMsgSize(byArray) - 4);
                if (Messages.moreFragmentsFollow(byArray)) {
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                this.buf_mg.returnBuffer(byArray);
                byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                n = Messages.getMsgType(byArray);
                this.fragments.remove(n2);
            } else if (Messages.moreFragmentsFollow(byArray)) {
                if (Messages.getGIOPMinor(byArray) == 0) {
                    Debug.output(1, "WARNING: Received a GIOP 1.0 message with the \"more fragments follow\" bits set");
                    MessageOutputStream messageOutputStream = new MessageOutputStream();
                    messageOutputStream.writeGIOPMsgHeader(6, 0);
                    messageOutputStream.insertMsgSize();
                    this.sendMessage(messageOutputStream);
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                if (Messages.getGIOPMinor(byArray) == 1) {
                    if (n != 0 && n != 1) {
                        Debug.output(1, "WARNING: Received a GIOP 1.1 message of type " + n + " with the \"more fragments follow\" bits set");
                        MessageOutputStream messageOutputStream = new MessageOutputStream();
                        messageOutputStream.writeGIOPMsgHeader(6, 1);
                        messageOutputStream.insertMsgSize();
                        this.sendMessage(messageOutputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    Debug.output(1, "WARNING: Received a fragmented GIOP 1.1 message");
                    int n3 = Messages.getGIOPMinor(byArray);
                    outputStream = new ReplyOutputStream(Messages.getRequestId(byArray), ReplyStatusType_1_2.SYSTEM_EXCEPTION, n3, false);
                    SystemExceptionHelper.write((org.omg.CORBA.portable.OutputStream)outputStream, new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO));
                    this.sendMessage((MessageOutputStream)outputStream);
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                if (n == 2 || n == 5 || n == 2) {
                    Debug.output(1, "WARNING: Received a GIOP message of type " + n + " with the \"more fragments follow\" bits set, but this " + "message type isn't allowed to be fragmented");
                    MessageOutputStream messageOutputStream = new MessageOutputStream();
                    messageOutputStream.writeGIOPMsgHeader(6, 1);
                    messageOutputStream.insertMsgSize();
                    this.sendMessage(messageOutputStream);
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                Integer n4 = new Integer(Messages.getRequestId(byArray));
                if (this.fragments.containsKey(n4)) {
                    Debug.output(1, "ERROR, Received a message of type " + n + " with the more fragments follow bit set, but there is already an fragmented, incomplete message with the same request id " + n4 + "!");
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                outputStream = new ByteArrayOutputStream();
                this.fragments.put(n4, outputStream);
                ((ByteArrayOutputStream)outputStream).write(byArray, 0, Messages.MSG_HEADER_SIZE + Messages.getMsgSize(byArray));
                this.buf_mg.returnBuffer(byArray);
                continue;
            }
            switch (n) {
                case 0: {
                    this.getRequestListener().requestReceived(byArray, this);
                    continue block14;
                }
                case 1: {
                    this.getReplyListener().replyReceived(byArray, this);
                    continue block14;
                }
                case 2: {
                    this.getRequestListener().cancelRequestReceived(byArray, this);
                    continue block14;
                }
                case 3: {
                    this.getRequestListener().locateRequestReceived(byArray, this);
                    continue block14;
                }
                case 4: {
                    this.getReplyListener().locateReplyReceived(byArray, this);
                    continue block14;
                }
                case 5: {
                    this.getReplyListener().closeConnectionReceived(byArray, this);
                    continue block14;
                }
                case 6: {
                    continue block14;
                }
                case 7: {
                    continue block14;
                }
            }
            Debug.output(0, "ERROR: received message with unknown message type " + n);
            Debug.output(3, "GIOPConnection.receiveMessages()", byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void getWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            while (this.writer_active) {
                try {
                    this.write_sync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.writer_active = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            this.writer_active = false;
            this.write_sync.notifyAll();
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.transport.write(byArray, n, n2);
    }

    public final void write(int n) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void write(byte[] byArray) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void flush() throws IOException {
        throw new NO_IMPLEMENT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMessage(MessageOutputStream messageOutputStream) throws IOException {
        try {
            this.getWriteLock();
            messageOutputStream.write_to(this);
            this.transport.flush();
            Object var3_2 = null;
            this.releaseWriteLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseWriteLock();
            throw throwable;
        }
    }

    public final boolean isSSL() {
        return this.transport.isSSL();
    }

    public final void close() {
        try {
            this.transport.close();
        }
        catch (IOException iOException) {
            Debug.output(1, iOException);
        }
    }
}

