/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import org.jacorb.orb.connection.MessageInputStream;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.portable.RemarshalException;

public class ReplyPlaceholder {
    private boolean ready;
    private boolean communicationException;
    private boolean remarshalException;
    private boolean timeoutException;
    private MessageInputStream in;
    private int timeout;

    public ReplyPlaceholder() {
        block2: {
            this.ready = false;
            this.communicationException = false;
            this.remarshalException = false;
            this.timeoutException = false;
            this.in = null;
            this.timeout = -1;
            String string = Environment.getProperty("jacorb.client.pending_reply_timeout");
            if (string == null) break block2;
            try {
                this.timeout = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.output(1, "Unable to create int from string >" + string + '<');
                Debug.output(1, "Please check property \"jacorb.client.pending_reply_timeout\"");
            }
        }
    }

    public synchronized void replyReceived(MessageInputStream messageInputStream) {
        if (!this.timeoutException) {
            this.in = messageInputStream;
            this.ready = true;
            this.notifyAll();
        }
    }

    public synchronized void cancel() {
        this.communicationException = true;
        this.ready = true;
        this.notify();
    }

    public synchronized void retry() {
        this.remarshalException = true;
        this.ready = true;
        this.notify();
    }

    public synchronized void timeout() {
        this.timeoutException = true;
        this.ready = true;
        this.notify();
    }

    public synchronized MessageInputStream getInputStream() throws RemarshalException {
        while (!this.ready) {
            try {
                if (this.timeout > 0) {
                    this.wait(this.timeout);
                    if (this.ready) continue;
                    this.ready = true;
                    this.timeoutException = true;
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.remarshalException) {
            throw new RemarshalException();
        }
        if (this.communicationException) {
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.timeoutException) {
            throw new IMP_LIMIT("Client timeout reached.");
        }
        return this.in;
    }
}

