/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.IOException;
import java.util.StringTokenizer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.LocateReplyOutputStream;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.orb.connection.RequestInputStream;
import org.jacorb.orb.connection.RequestListener;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class ServerRequestListener
implements RequestListener {
    private ORB orb = null;
    private org.jacorb.poa.POA rootPOA = null;
    private boolean require_ssl = false;

    public ServerRequestListener(org.omg.CORBA.ORB oRB, POA pOA) {
        this.orb = (ORB)oRB;
        this.rootPOA = (org.jacorb.poa.POA)pOA;
        if (Environment.isPropertyOn("jacorb.security.support_ssl")) {
            int n = Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16);
            this.require_ssl = Environment.isPropertyOn("jacorb.security.support_ssl") && (n & 0x60) != 0;
        }
    }

    public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Object object;
        RequestInputStream requestInputStream = new RequestInputStream(this.orb, byArray);
        if (this.require_ssl && !gIOPConnection.isSSL()) {
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false);
            Debug.output(2, "About to reject request because connection is not SSL.");
            SystemExceptionHelper.write(replyOutputStream, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
            try {
                gIOPConnection.sendMessage(replyOutputStream);
            }
            catch (IOException iOException) {
                Debug.output(1, iOException);
            }
            return;
        }
        if (!gIOPConnection.isTCSNegotiated()) {
            if (requestInputStream.getGIOPMinor() == 0) {
                gIOPConnection.markTCSNegotiated();
            } else {
                object = CodeSet.getCodeSetContext(requestInputStream.req_hdr.service_context);
                if (object != null) {
                    gIOPConnection.setCodeSets(((CodeSetContext)object).char_data, ((CodeSetContext)object).wchar_data);
                    Debug.output(3, "Received CodeSetContext. Using " + CodeSet.csName(((CodeSetContext)object).char_data) + " as TCS and " + CodeSet.csName(((CodeSetContext)object).wchar_data) + " as TCSW");
                }
            }
        }
        requestInputStream.setCodeSet(gIOPConnection.getTCS(), gIOPConnection.getTCSW());
        object = null;
        try {
            object = new ServerRequest(this.orb, requestInputStream, gIOPConnection);
        }
        catch (POAInternalError pOAInternalError) {
            Debug.output(1, "WARNING: Received a request with a non-jacorb object key");
            if (requestInputStream.isLocateRequest()) {
                LocateReplyOutputStream locateReplyOutputStream = new LocateReplyOutputStream(requestInputStream.req_hdr.request_id, 0, requestInputStream.getGIOPMinor());
                try {
                    gIOPConnection.sendMessage(locateReplyOutputStream);
                }
                catch (IOException iOException) {
                    Debug.output(1, iOException);
                }
            } else {
                ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false);
                SystemExceptionHelper.write(replyOutputStream, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                try {
                    gIOPConnection.sendMessage(replyOutputStream);
                }
                catch (IOException iOException) {
                    Debug.output(1, iOException);
                }
            }
            return;
        }
        this.orb.getBasicAdapter().replyPending();
        this.deliverRequest((ServerRequest)object);
    }

    public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        this.requestReceived(byArray, gIOPConnection);
    }

    public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
    }

    /*
     * Unable to fully structure code
     */
    private void deliverRequest(ServerRequest var1_1) {
        var2_2 = this.rootPOA;
        try {
            var3_3 = POAUtil.extractPOAName(var1_1.objectKey());
            var4_5 = new StringTokenizer(var3_3, "/");
            var5_7 = new String[var4_5.countTokens()];
            var6_9 = 0;
            while (var4_5.hasMoreTokens()) {
                var5_7[var6_9] = var4_5.nextToken();
                ++var6_9;
            }
            var7_10 = 0;
            while (var7_10 < var5_7.length) {
                block10: {
                    if (var5_7[var7_10].equals("")) break;
                    try {
                        var2_2 = var2_2._getChildPOA(var5_7[var7_10]);
                        break block10;
                    }
                    catch (ParentIsHolding var8_11) {
                        var9_12 = new String[var5_7.length - var7_10];
                        var10_13 = 0;
                        ** while (var10_13 < var7_10)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var9_12[var10_13] = var5_7[var10_13 + var7_10];
                        ++var10_13;
                        continue;
                    }
lbl24:
                    // 1 sources

                    var1_1.setRemainingPOAName(var9_12);
                    break;
                }
                ++var7_10;
            }
            if (var2_2 == null) {
                throw new Error("request POA null!");
            }
            var2_2._invoke(var1_1);
        }
        catch (WrongAdapter var3_4) {
            var1_1.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            var1_1.reply();
        }
        catch (SystemException var4_6) {
            var1_1.setSystemException(var4_6);
            var1_1.reply();
        }
        catch (Throwable var5_8) {
            var1_1.setSystemException(new UNKNOWN(var5_8.toString()));
            var1_1.reply();
            var5_8.printStackTrace();
        }
    }
}

