/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.StreamClosedException;
import org.jacorb.orb.connection.TimeOutException;
import org.jacorb.orb.connection.Transport;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public abstract class TCP_IP_Transport
implements Transport {
    public static final int GIOP_CONNECTION_CLOSED = 0;
    public static final int READ_TIMED_OUT = 1;
    public static final int STREAM_CLOSED = 2;
    protected InputStream in_stream = null;
    protected OutputStream out_stream = null;
    private byte[] msg_header = new byte[Messages.MSG_HEADER_SIZE];
    private BufferManager buff_mg = BufferManager.getInstance();
    private ByteArrayOutputStream b_out = null;
    private boolean dump_incoming = false;
    String connection_info;
    Socket socket;

    public TCP_IP_Transport() {
        String string = Environment.getProperty("jacorb.debug.dump_outgoing_messages", "off");
        if ("on".equals(string)) {
            this.b_out = new ByteArrayOutputStream();
        }
        String string2 = Environment.getProperty("jacorb.debug.dump_incoming_messages", "off");
        this.dump_incoming = "on".equals(string2);
    }

    protected abstract void connect();

    protected abstract void waitUntilConnected() throws IOException;

    protected abstract void close(int var1) throws IOException;

    public void close() throws IOException {
        this.close(0);
    }

    private final int readToBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            try {
                n4 = this.in_stream.read(byArray, n + n3, n2 - n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.socket.getSoTimeout() != 0) {
                    Debug.output(1, "Socket timed out with timeout period of " + this.socket.getSoTimeout());
                }
                this.close(1);
                throw new TimeOutException("Socket read timed out");
            }
            catch (SocketException socketException) {
                this.close(2);
                throw new StreamClosedException("Socket stream closed");
            }
            if (n4 < 0) {
                this.close(2);
                throw new StreamClosedException("Socket stream closed");
            }
            n3 += n4;
        }
        return n3;
    }

    public byte[] getMessage() throws IOException {
        this.waitUntilConnected();
        int n = this.readToBuffer(this.msg_header, 0, Messages.MSG_HEADER_SIZE);
        if (n == -1) {
            return null;
        }
        if (n != Messages.MSG_HEADER_SIZE) {
            return null;
        }
        if ((char)this.msg_header[0] == 'G' && (char)this.msg_header[1] == 'I' && (char)this.msg_header[2] == 'O' && (char)this.msg_header[3] == 'P') {
            int n2 = Messages.getMsgSize(this.msg_header);
            if (n2 < 0) {
                Debug.output(1, "ERROR: Negative GIOP message size: " + n2);
                Debug.output(3, "TCP_IP_GIOPTransport.getMessage()", this.msg_header, 0, n);
                return null;
            }
            byte[] byArray = this.buff_mg.getBuffer(n2 + Messages.MSG_HEADER_SIZE);
            System.arraycopy(this.msg_header, 0, byArray, 0, Messages.MSG_HEADER_SIZE);
            n = this.readToBuffer(byArray, Messages.MSG_HEADER_SIZE, n2);
            if (n == -1) {
                return null;
            }
            if (n != n2) {
                Debug.output(1, "ERROR: Failed to read GIOP message");
                Debug.output(1, n2 - n + " Bytes less than the expected " + n2 + " Bytes");
                Debug.output(3, "TCP_IP_GIOPTransport.getMessage()", byArray, 0, n);
                return null;
            }
            if (this.dump_incoming) {
                Debug.output(1, "getMessage()", byArray, 0, n + Messages.MSG_HEADER_SIZE);
            }
            return byArray;
        }
        Debug.output(1, "ERROR: Failed to read GIOP message");
        Debug.output(1, "Magic start doesn't match");
        Debug.output(3, "TCP_IP_GIOPTransport.getMessage()", this.msg_header);
        return null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.connect();
        this.out_stream.write(byArray, n, n2);
        if (this.b_out != null) {
            this.b_out.write(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        if (this.b_out != null) {
            byte[] byArray = this.b_out.toByteArray();
            Debug.output(1, "sendMessages()", byArray);
            this.b_out.reset();
        }
        this.out_stream.flush();
    }
}

