/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class PortRangeSocketFactory
implements SocketFactory {
    private int portMin = this.getPortProperty("jacorb.net.socket_factory.port.min");
    private int portMax = this.getPortProperty("jacorb.net.socket_factory.port.max");
    public static final String MIN_PROP = "jacorb.net.socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.socket_factory.port.max";

    public PortRangeSocketFactory() {
        if (this.portMin >= this.portMax) {
            throw new RuntimeException("PortRangeSocketFactory: minimum port number not less than maximum");
        }
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        int n2 = this.portMin;
        while (n2 <= this.portMax) {
            try {
                Socket socket = new Socket(string, n, inetAddress, n2);
                Debug.output(2, "PortRangeSocketFactory: Created socket between " + inetAddress.getHostAddress() + ":" + n2 + " and " + string + ":" + n);
                return socket;
            }
            catch (IOException iOException) {
                ++n2;
            }
        }
        Debug.output(257, "Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + string + ":" + n);
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public boolean isSSL(Socket socket) {
        return false;
    }

    private int getPortProperty(String string) {
        int n;
        String string2 = Environment.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            throw new RuntimeException("PortRangeSocketFactory: " + string + " property not set");
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("PortRangeSocketFactory: " + string + " invalid port number");
        }
        if (n < 0) {
            n += 65536;
        }
        if (n <= 0 || n > 65535) {
            throw new RuntimeException("PortRangeSocketFactory: " + string + " invalid port number");
        }
        return n;
    }
}

