/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ParsedIOR;
import org.omg.CORBA.ORB;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;

public class FixIOR {
    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length != 3) {
            System.err.println("Usage: fixior host port ior_file");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[2];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        String string3 = bufferedReader.readLine();
        bufferedReader.close();
        if (!string3.startsWith("IOR:")) {
            System.err.println("IOR must be in the standard IOR URL format");
            System.exit(1);
        }
        if ((n = Integer.parseInt(stringArray[1])) > Short.MAX_VALUE) {
            n -= 65536;
        }
        short s = (short)n;
        ORB oRB = ORB.init(stringArray, null);
        ParsedIOR parsedIOR = new ParsedIOR(string3);
        IOR iOR = parsedIOR.getIOR();
        TaggedProfile[] taggedProfileArray = iOR.profiles;
        int n2 = 0;
        while (n2 < taggedProfileArray.length) {
            if (taggedProfileArray[n2].tag == 0) {
                CDRInputStream cDRInputStream = new CDRInputStream(oRB, taggedProfileArray[n2].profile_data);
                cDRInputStream.openEncapsulatedArray();
                ProfileBody_1_0 profileBody_1_0 = ProfileBody_1_0Helper.read(cDRInputStream);
                cDRInputStream.close();
                CDROutputStream cDROutputStream = new CDROutputStream();
                cDROutputStream.beginEncapsulatedArray();
                if (profileBody_1_0.iiop_version.minor > 0) {
                    cDRInputStream = new CDRInputStream(oRB, taggedProfileArray[n2].profile_data);
                    cDRInputStream.openEncapsulatedArray();
                    ProfileBody_1_1 profileBody_1_1 = ProfileBody_1_1Helper.read(cDRInputStream);
                    cDRInputStream.close();
                    profileBody_1_1.host = string;
                    profileBody_1_1.port = s;
                    ProfileBody_1_1Helper.write(cDROutputStream, profileBody_1_1);
                } else {
                    profileBody_1_0.host = string;
                    profileBody_1_0.port = s;
                    ProfileBody_1_0Helper.write(cDROutputStream, profileBody_1_0);
                }
                taggedProfileArray[n2].profile_data = cDROutputStream.getBufferCopy();
            }
            ++n2;
        }
        parsedIOR = new ParsedIOR(iOR);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string2)));
        bufferedWriter.write(parsedIOR.getIORString());
        bufferedWriter.close();
    }

    private FixIOR() {
    }
}

