/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class SSLServerSocketFactory
implements org.jacorb.orb.factory.SSLServerSocketFactory {
    private ServerSocketFactory factory = this.createServerSocketFactory();
    private boolean mutual_auth = false;
    private boolean change_roles = false;
    private String[] cipher_suites = null;

    public SSLServerSocketFactory(ORB oRB) {
        StringTokenizer stringTokenizer;
        int n;
        if (this.factory == null) {
            Debug.output(1, "ERROR: Unable to create ServerSocketFactory!");
        }
        if ((Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16) & 0x40) != 0) {
            this.mutual_auth = true;
        }
        this.change_roles = Environment.isPropertyOn("jacorb.security.change_ssl_roles");
        String string = Environment.getProperty("jacorb.security.ssl.server.cipher_suites");
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[n];
            while (stringTokenizer.hasMoreElements()) {
                this.cipher_suites[--n] = stringTokenizer.nextToken();
            }
        }
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n);
        sSLServerSocket.setNeedClientAuth(this.mutual_auth);
        if (this.cipher_suites != null) {
            sSLServerSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2);
        sSLServerSocket.setNeedClientAuth(this.mutual_auth);
        if (this.cipher_suites != null) {
            sSLServerSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2, inetAddress);
        sSLServerSocket.setNeedClientAuth(this.mutual_auth);
        if (this.cipher_suites != null) {
            sSLServerSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        return sSLServerSocket;
    }

    public boolean isSSL(ServerSocket serverSocket) {
        return serverSocket instanceof SSLServerSocket;
    }

    public void switchToClientMode(Socket socket) {
        if (this.change_roles) {
            ((SSLSocket)socket).setUseClientMode(true);
        }
    }

    private ServerSocketFactory createServerSocketFactory() {
        Security.addProvider((java.security.Provider)new Provider());
        try {
            String string;
            String string2 = Environment.getProperty("jacorb.security.keystore");
            if (string2 == null) {
                System.out.print("Please enter key store file name: ");
                string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            if ((string = Environment.getProperty("jacorb.security.keystore_password")) == null) {
                System.out.print("Please enter store pass phrase: ");
                string = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            KeyStore keyStore = KeyStoreUtil.getKeyStore(string2, string.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, string.toCharArray());
            TrustManagerFactory trustManagerFactory = null;
            if ((Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16) & 0x40) != 0) {
                trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                if (Environment.isPropertyOn("jacorb.security.jsse.trustees_from_ks")) {
                    trustManagerFactory.init(keyStore);
                } else {
                    trustManagerFactory.init((KeyStore)null);
                }
            }
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), null);
            return sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            Debug.output(1, exception);
            return null;
        }
    }
}

