/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class SSLSocketFactory
implements org.jacorb.orb.factory.SocketFactory {
    private SocketFactory factory = this.createSocketFactory();
    private boolean change_roles = false;
    private String[] cipher_suites = null;

    public SSLSocketFactory(ORB oRB) {
        StringTokenizer stringTokenizer;
        int n;
        if (this.factory == null) {
            Debug.output(1, "ERROR: Unable to create ServerSocketFactory!");
        }
        this.change_roles = Environment.isPropertyOn("jacorb.security.change_ssl_roles");
        String string = Environment.getProperty("jacorb.security.ssl.client.cipher_suites");
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[n];
            while (stringTokenizer.hasMoreElements()) {
                this.cipher_suites[--n] = stringTokenizer.nextToken();
            }
        }
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.factory.createSocket(string, n);
        if (this.change_roles) {
            sSLSocket.setUseClientMode(false);
        }
        if (this.cipher_suites != null) {
            sSLSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        return sSLSocket;
    }

    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    private SocketFactory createSocketFactory() {
        try {
            Object object;
            Object object2;
            KeyManagerFactory keyManagerFactory = null;
            KeyStore keyStore = null;
            if (Environment.isPropertyOn("jacorb.security.jsse.trustees_from_ks") || (Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16) & 0x40) != 0) {
                object2 = Environment.getProperty("jacorb.security.keystore");
                if (object2 == null) {
                    System.out.print("Please enter key store file name: ");
                    object2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
                }
                if ((object = Environment.getProperty("jacorb.security.keystore_password")) == null) {
                    System.out.print("Please enter store pass phrase: ");
                    object = new BufferedReader(new InputStreamReader(System.in)).readLine();
                }
                keyStore = KeyStoreUtil.getKeyStore((String)object2, ((String)object).toCharArray());
                if ((Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16) & 0x40) != 0) {
                    keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(keyStore, ((String)object).toCharArray());
                }
            }
            object2 = TrustManagerFactory.getInstance("SunX509");
            if (keyStore != null && Environment.isPropertyOn("jacorb.security.jsse.trustees_from_ks")) {
                ((TrustManagerFactory)object2).init(keyStore);
            } else {
                ((TrustManagerFactory)object2).init((KeyStore)null);
            }
            object = SSLContext.getInstance("TLS");
            ((SSLContext)object).init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), ((TrustManagerFactory)object2).getTrustManagers(), null);
            return ((SSLContext)object).getSocketFactory();
        }
        catch (Exception exception) {
            Debug.output(1, exception);
            return null;
        }
    }
}

