/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.Server_TCP_IP_Transport;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.ReceivedCredentialsImpl;
import org.jacorb.security.level2.SecAttributeManager;
import org.jacorb.util.Debug;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Current;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = null;
    private CurrentImpl current = null;
    private SecAttributeManager attrib_mgr = null;
    private AttributeType type = null;

    public ServerInvocationInterceptor(Current current) {
        this(current, DEFAULT_NAME);
    }

    public ServerInvocationInterceptor(Current current, String string) {
        this.current = (CurrentImpl)current;
        this.name = string;
        this.attrib_mgr = SecAttributeManager.getInstance();
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        ServerRequest serverRequest = ((ServerRequestInfoImpl)serverRequestInfo).request;
        GIOPConnection gIOPConnection = serverRequest.getConnection();
        if (gIOPConnection == null) {
            Debug.output(3, "target has no connection!");
            return;
        }
        if (!gIOPConnection.isSSL()) {
            return;
        }
        Server_TCP_IP_Transport server_TCP_IP_Transport = (Server_TCP_IP_Transport)gIOPConnection.getTransport();
        SSLSocket sSLSocket = (SSLSocket)server_TCP_IP_Transport.getSocket();
        KeyAndCert keyAndCert = null;
        try {
            keyAndCert = new KeyAndCert(null, sSLSocket.getSession().getPeerCertificates());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            Debug.output(2, sSLPeerUnverifiedException);
            return;
        }
        if (keyAndCert.chain == null) {
            Debug.output(2, "Client sent no certificate chain!");
            return;
        }
        SecAttribute[] secAttributeArray = new SecAttribute[]{this.attrib_mgr.createAttribute(keyAndCert, this.type)};
        this.current.set_received_credentials(new ReceivedCredentialsImpl(secAttributeArray));
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.current.remove_received_credentials();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.current.remove_received_credentials();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.current.remove_received_credentials();
    }
}

