/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.typemgr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.jacorb.trading.client.typemgr.LexException;

public class Lex {
    private StringBuffer m_input;
    private int m_token = 0;
    private StringBuffer m_buffer = new StringBuffer();
    private String m_lexeme = null;
    private int m_pos = 0;
    private int m_line = 1;
    private Hashtable m_literals = new Hashtable();
    private boolean m_eof = false;
    public static final int ERROR = 0;
    public static final int END = 1;
    public static final int LBRACE = 2;
    public static final int RBRACE = 3;
    public static final int LANGLE = 4;
    public static final int RANGLE = 5;
    public static final int COLON = 6;
    public static final int DOUBLECOLON = 7;
    public static final int SEMICOLON = 8;
    public static final int COMMA = 9;
    public static final int SERVICE = 10;
    public static final int INTERFACE = 11;
    public static final int IDENT = 12;
    public static final int MANDATORY = 13;
    public static final int READONLY = 14;
    public static final int PROPERTY = 15;
    public static final int UNSIGNED = 16;
    public static final int BOOLEAN = 17;
    public static final int CHAR = 18;
    public static final int SHORT = 19;
    public static final int LONG = 20;
    public static final int FLOAT = 21;
    public static final int DOUBLE = 22;
    public static final int STRING = 23;
    public static final int SEQUENCE = 24;
    public static final int OTHER = 25;

    private Lex() {
    }

    public Lex(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.m_input = new StringBuffer();
        boolean bl = false;
        char[] cArray = new char[512];
        while (!bl) {
            try {
                int n = bufferedReader.read(cArray);
                if (n < 0) {
                    bl = true;
                    continue;
                }
                this.m_input.append(cArray, 0, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_literals.put("service", new Integer(10));
        this.m_literals.put("interface", new Integer(11));
        this.m_literals.put("mandatory", new Integer(13));
        this.m_literals.put("readonly", new Integer(14));
        this.m_literals.put("property", new Integer(15));
        this.m_literals.put("unsigned", new Integer(16));
        this.m_literals.put("boolean", new Integer(17));
        this.m_literals.put("char", new Integer(18));
        this.m_literals.put("short", new Integer(19));
        this.m_literals.put("long", new Integer(20));
        this.m_literals.put("float", new Integer(21));
        this.m_literals.put("double", new Integer(22));
        this.m_literals.put("string", new Integer(23));
        this.m_literals.put("sequence", new Integer(24));
        this.m_literals.put("other", new Integer(25));
    }

    /*
     * Unable to fully structure code
     */
    public void nextToken() throws LexException {
        var1_1 = 0;
        var2_2 = false;
        this.clearLexeme();
        block11: while (!var2_2) {
            var3_3 = this.nextChar();
            if (this.eof()) {
                var1_1 = 1;
                break;
            }
            switch (var3_3) {
                case '{': {
                    var1_1 = 2;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl61
                }
                case '}': {
                    var1_1 = 3;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl61
                }
                case '<': {
                    var1_1 = 4;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl61
                }
                case '>': {
                    var1_1 = 5;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl61
                }
                case ':': {
                    this.addLexeme(var3_3);
                    var3_3 = this.nextChar();
                    if (var3_3 != ':') {
                        this.pushBack(var3_3);
                        var1_1 = 6;
                        var2_2 = true;
                    } else {
                        var1_1 = 7;
                        this.addLexeme(var3_3);
                        var2_2 = true;
                    }
                    ** GOTO lbl61
                }
                case ';': {
                    var1_1 = 8;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl61
                }
                case ',': {
                    var1_1 = 9;
                    var2_2 = true;
                    this.addLexeme(var3_3);
                    ** GOTO lbl61
                }
                case '/': {
                    var3_3 = this.nextChar();
                    if (var3_3 != '/') {
                        throw new LexException("expected comment", this.m_line);
                    }
                    while ((var3_3 = this.nextChar()) != '\n') {
                    }
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
lbl61:
                // 9 sources

                default: {
                    if (var2_2) continue block11;
                    if (var3_3 == '_' || Character.isLetter(var3_3)) ** GOTO lbl67
                    throw new LexException("unexpected input", this.m_line);
lbl-1000:
                    // 1 sources

                    {
                        this.addLexeme(var3_3);
                        var3_3 = this.nextChar();
lbl67:
                        // 2 sources

                        ** while (this.isIdent((char)var3_3) && !this.eof())
                    }
lbl68:
                    // 1 sources

                    if (!this.eof()) {
                        this.pushBack(var3_3);
                    }
                    var1_1 = (var5_5 = (Integer)this.m_literals.get(var4_4 = this.getLexeme())) == null ? 12 : var5_5;
                    var2_2 = true;
                }
            }
        }
        this.m_token = var1_1;
    }

    public int getToken() {
        return this.m_token;
    }

    public String getLexeme() {
        if (this.m_lexeme == null) {
            this.m_lexeme = this.m_buffer.toString();
        }
        return this.m_lexeme;
    }

    public int getLine() {
        return this.m_line;
    }

    protected boolean eof() {
        return this.m_eof;
    }

    protected char nextChar() {
        char c = '\u0000';
        if (this.m_pos < this.m_input.length()) {
            c = this.m_input.charAt(this.m_pos);
            ++this.m_pos;
            if (c == '\n') {
                ++this.m_line;
            }
        } else {
            this.m_eof = true;
        }
        return c;
    }

    protected void pushBack(char c) {
        if (c != '\u0000') {
            --this.m_pos;
        }
    }

    protected boolean isIdent(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    protected void clearLexeme() {
        this.m_lexeme = null;
        this.m_buffer.setLength(0);
    }

    protected void addLexeme(char c) {
        this.m_buffer.append(c);
    }
}

