/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.AddNode;
import org.jacorb.trading.constraint.AndNode;
import org.jacorb.trading.constraint.DivideNode;
import org.jacorb.trading.constraint.EqNode;
import org.jacorb.trading.constraint.ExistNode;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.GeNode;
import org.jacorb.trading.constraint.GtNode;
import org.jacorb.trading.constraint.InNode;
import org.jacorb.trading.constraint.LeNode;
import org.jacorb.trading.constraint.Lex;
import org.jacorb.trading.constraint.LiteralNode;
import org.jacorb.trading.constraint.LtNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.MultiplyNode;
import org.jacorb.trading.constraint.NegNode;
import org.jacorb.trading.constraint.NeqNode;
import org.jacorb.trading.constraint.NotNode;
import org.jacorb.trading.constraint.OrNode;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.constraint.PropertyNode;
import org.jacorb.trading.constraint.PropertySchema;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.SubstrNode;
import org.jacorb.trading.constraint.SubtractNode;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueType;

public class Expression {
    private PropertySchema m_schema;
    private ExprNode m_root;

    private Expression() {
    }

    public Expression(PropertySchema propertySchema) {
        this.m_schema = propertySchema;
    }

    public ValueType parse(Lex lex) throws ParseException {
        this.m_root = null;
        this.m_root = this.parseBoolOr(lex);
        if (this.m_root == null) {
            throw new ParseException("invalid input");
        }
        if (lex.getToken() != 1) {
            throw new ParseException("unexpected input");
        }
        return this.m_root.getType();
    }

    public Value evaluate(PropertySource propertySource) {
        Value value = null;
        try {
            value = this.m_root.evaluate(propertySource);
        }
        catch (MissingPropertyException missingPropertyException) {
        }
        catch (ArithmeticException arithmeticException) {}
        return value;
    }

    protected ExprNode parseBoolean(Lex lex) throws ParseException {
        LiteralNode literalNode = null;
        int n = lex.getToken();
        if (n == 21 || n == 22) {
            literalNode = new LiteralNode(0, lex.getLexeme());
            lex.nextToken();
        }
        return literalNode;
    }

    protected ExprNode parseString(Lex lex) throws ParseException {
        LiteralNode literalNode = null;
        int n = lex.getToken();
        if (n == 23) {
            literalNode = new LiteralNode(2, lex.getLexeme());
            lex.nextToken();
        }
        return literalNode;
    }

    protected ExprNode parseNumber(Lex lex) throws ParseException {
        LiteralNode literalNode = null;
        int n = lex.getToken();
        if (n == 24) {
            literalNode = new LiteralNode(1, lex.getLexeme());
            lex.nextToken();
        }
        return literalNode;
    }

    protected ExprNode parseFactor(Lex lex) throws ParseException {
        ExprNode exprNode = null;
        int n = lex.getToken();
        if (n == 2) {
            lex.nextToken();
            exprNode = this.parseBoolOr(lex);
            if (lex.getToken() != 3) {
                throw new ParseException("missing closing parenthesis");
            }
            lex.nextToken();
        } else if (n == 4) {
            lex.nextToken();
            ExprNode exprNode2 = this.parseIdent(lex, false);
            if (exprNode2 == null) {
                throw new ParseException("operand to 'exist' must be a property");
            }
            exprNode = new ExistNode(exprNode2);
        } else if (n == 20) {
            exprNode = this.parseIdent(lex, true);
        } else if (n == 24) {
            exprNode = this.parseNumber(lex);
        } else if (n == 5) {
            lex.nextToken();
            ExprNode exprNode3 = null;
            if (lex.getToken() == 24) {
                exprNode3 = this.parseNumber(lex);
            } else if (lex.getToken() == 20) {
                exprNode3 = this.parseIdent(lex, true);
            }
            if (exprNode3 == null) {
                throw new ParseException("operand to unary '-' must be a number");
            }
            exprNode = new NegNode(exprNode3);
        } else if (n == 23) {
            exprNode = this.parseString(lex);
        } else if (n == 21 || n == 22) {
            exprNode = this.parseBoolean(lex);
        } else {
            throw new ParseException("unexpected factor '" + lex.getLexeme() + "'");
        }
        return exprNode;
    }

    protected ExprNode parseFactorNot(Lex lex) throws ParseException {
        ExprNode exprNode = null;
        int n = lex.getToken();
        if (n == 6) {
            lex.nextToken();
            ExprNode exprNode2 = this.parseFactor(lex);
            ValueType valueType = exprNode2.getType();
            if (!ValueType.isCompatible(valueType.getId(), 0) || valueType.isSequence()) {
                throw new ParseException("operand to 'not' must be a boolean expression");
            }
            exprNode = new NotNode(exprNode2);
        } else {
            exprNode = this.parseFactor(lex);
        }
        return exprNode;
    }

    protected ExprNode parseTerm(Lex lex) throws ParseException {
        ExprNode exprNode = this.parseFactorNot(lex);
        int n = lex.getToken();
        while (n == 7 || n == 8) {
            String string = lex.getLexeme();
            lex.nextToken();
            ExprNode exprNode2 = this.parseFactorNot(lex);
            if (!exprNode.getType().isNumber() || !exprNode2.getType().isNumber() || exprNode.getType().isSequence() || exprNode2.getType().isSequence()) {
                throw new ParseException("operands to '" + string + "' must be numeric");
            }
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode2.getType().getId())) {
                throw new ParseException("operands to '" + string + "' are not compatible");
            }
            exprNode = n == 7 ? new MultiplyNode(exprNode, exprNode2) : new DivideNode(exprNode, exprNode2);
            n = lex.getToken();
        }
        return exprNode;
    }

    protected ExprNode parseExpr(Lex lex) throws ParseException {
        ExprNode exprNode = this.parseTerm(lex);
        int n = lex.getToken();
        while (n == 9 || n == 5) {
            String string = lex.getLexeme();
            lex.nextToken();
            ExprNode exprNode2 = this.parseTerm(lex);
            if (!exprNode.getType().isNumber() || !exprNode2.getType().isNumber() || exprNode.getType().isSequence() || exprNode2.getType().isSequence()) {
                throw new ParseException("operands to '" + string + "' must be numeric");
            }
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode2.getType().getId())) {
                throw new ParseException("operands to '" + string + "' are not compatible");
            }
            exprNode = n == 9 ? new AddNode(exprNode, exprNode2) : new SubtractNode(exprNode, exprNode2);
            n = lex.getToken();
        }
        return exprNode;
    }

    protected ExprNode parseIdent(Lex lex, boolean bl) throws ParseException {
        PropertyNode propertyNode = null;
        int n = lex.getToken();
        if (n == 20) {
            String string = lex.getLexeme();
            ValueType valueType = this.m_schema.getPropertyType(string);
            if (valueType == null) {
                if (bl) {
                    throw new ParseException("unknown property '" + string + "'");
                }
                valueType = new ValueType(9);
            }
            propertyNode = new PropertyNode(string, valueType);
            lex.nextToken();
        }
        return propertyNode;
    }

    protected ExprNode parseExprTwiddle(Lex lex) throws ParseException {
        ExprNode exprNode = this.parseExpr(lex);
        int n = lex.getToken();
        if (n == 10) {
            lex.nextToken();
            ExprNode exprNode2 = this.parseExpr(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), 8) || !ValueType.isCompatible(exprNode2.getType().getId(), 8)) {
                throw new ParseException("operands to '~' must be strings");
            }
            if (exprNode.getType().isSequence() || exprNode2.getType().isSequence()) {
                throw new ParseException("sequence not allowed as operand to '~'");
            }
            exprNode = new SubstrNode(exprNode, exprNode2);
        }
        return exprNode;
    }

    protected ExprNode parseExprIn(Lex lex) throws ParseException {
        ExprNode exprNode = this.parseExprTwiddle(lex);
        int n = lex.getToken();
        if (n == 11) {
            lex.nextToken();
            ExprNode exprNode2 = this.parseIdent(lex, true);
            if (exprNode2 == null) {
                throw new ParseException("right operand to 'in' must be a property");
            }
            if (!exprNode2.getType().isSequence()) {
                throw new ParseException("right operand to 'in' must be a sequence property");
            }
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode2.getType().getId())) {
                throw new ParseException("operands to 'in' are not compatible");
            }
            exprNode = new InNode(exprNode, exprNode2);
        }
        return exprNode;
    }

    protected ExprNode parseBoolCompare(Lex lex) throws ParseException {
        ExprNode exprNode = this.parseExprIn(lex);
        int n = lex.getToken();
        if (n == 12) {
            lex.nextToken();
            ExprNode exprNode2 = this.parseExprIn(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode2.getType().getId()) || exprNode.getType().isSequence() || exprNode2.getType().isSequence()) {
                throw new ParseException("operands to '==' are not compatible");
            }
            exprNode = new EqNode(exprNode, exprNode2);
        } else if (n == 13) {
            lex.nextToken();
            ExprNode exprNode3 = this.parseExprIn(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode3.getType().getId()) || exprNode.getType().isSequence() || exprNode3.getType().isSequence()) {
                throw new ParseException("operands to '!=' are not compatible");
            }
            exprNode = new NeqNode(exprNode, exprNode3);
        } else if (n == 14) {
            lex.nextToken();
            ExprNode exprNode4 = this.parseExprIn(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode4.getType().getId()) || exprNode.getType().isSequence() || exprNode4.getType().isSequence()) {
                throw new ParseException("operands to '<' are not compatible");
            }
            exprNode = new LtNode(exprNode, exprNode4);
        } else if (n == 15) {
            lex.nextToken();
            ExprNode exprNode5 = this.parseExprIn(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode5.getType().getId()) || exprNode.getType().isSequence() || exprNode5.getType().isSequence()) {
                throw new ParseException("operands to '<=' are not compatible");
            }
            exprNode = new LeNode(exprNode, exprNode5);
        } else if (n == 16) {
            lex.nextToken();
            ExprNode exprNode6 = this.parseExprIn(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode6.getType().getId()) || exprNode.getType().isSequence() || exprNode6.getType().isSequence()) {
                throw new ParseException("operands to '>' are not compatible");
            }
            exprNode = new GtNode(exprNode, exprNode6);
        } else if (n == 17) {
            lex.nextToken();
            ExprNode exprNode7 = this.parseExprIn(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), exprNode7.getType().getId()) || exprNode.getType().isSequence() || exprNode7.getType().isSequence()) {
                throw new ParseException("operands to '>=' are not compatible");
            }
            exprNode = new GeNode(exprNode, exprNode7);
        }
        return exprNode;
    }

    protected ExprNode parseBoolAnd(Lex lex) throws ParseException {
        ExprNode exprNode = this.parseBoolCompare(lex);
        while (lex.getToken() == 18) {
            lex.nextToken();
            ExprNode exprNode2 = this.parseBoolCompare(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), 0) || !ValueType.isCompatible(exprNode2.getType().getId(), 0) || exprNode.getType().isSequence() || exprNode2.getType().isSequence()) {
                throw new ParseException("operands to 'and' must be boolean expressions");
            }
            exprNode = new AndNode(exprNode, exprNode2);
        }
        return exprNode;
    }

    protected ExprNode parseBoolOr(Lex lex) throws ParseException {
        ExprNode exprNode = this.parseBoolAnd(lex);
        while (lex.getToken() == 19) {
            lex.nextToken();
            ExprNode exprNode2 = this.parseBoolAnd(lex);
            if (!ValueType.isCompatible(exprNode.getType().getId(), 0) || !ValueType.isCompatible(exprNode2.getType().getId(), 0) || exprNode.getType().isSequence() || exprNode2.getType().isSequence()) {
                throw new ParseException("operands to 'or' must be boolean expressions");
            }
            exprNode = new OrNode(exprNode, exprNode2);
        }
        return exprNode;
    }
}

