/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.trading.constraint.Constraint;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.constraint.Preference;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.ImportAttrib;
import org.jacorb.trading.impl.LinkImpl;
import org.jacorb.trading.impl.OfferEvaluator;
import org.jacorb.trading.impl.OfferIteratorImpl;
import org.jacorb.trading.impl.ProxySourceAdapter;
import org.jacorb.trading.impl.SchemaAdapter;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.jacorb.trading.util.PropUtil;
import org.jacorb.trading.util.QueryContainer;
import org.jacorb.trading.util.QueryPropagator;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.FollowOptionHelper;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.LinkPackage.LinkInfo;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupPOA;
import org.omg.CosTrading.LookupPackage.IllegalPolicyName;
import org.omg.CosTrading.LookupPackage.IllegalPreference;
import org.omg.CosTrading.LookupPackage.InvalidPolicyValue;
import org.omg.CosTrading.LookupPackage.PolicyTypeMismatch;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIterator;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class LookupImpl
extends LookupPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private ImportAttrib m_import;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;
    private LinkImpl m_link_if;
    private static int m_query_counter;
    private Hashtable m_query_cache_lookup;
    private Vector m_query_cache_queue;
    private int m_query_cache_max;
    private QueryPropagator m_query_distrib;
    private LinkInfo[] m_links_cache;
    private static int count;
    private boolean m_debug;
    private int m_debug_verbosity;

    private LookupImpl() {
        this.m_query_cache_max = 100;
        this.m_debug = false;
        this.m_debug_verbosity = 2;
    }

    public LookupImpl(TraderComp traderComp, SupportAttrib supportAttrib, ImportAttrib importAttrib, OfferDatabase offerDatabase, LinkImpl linkImpl) {
        block8: {
            this.m_query_cache_max = 100;
            this.m_debug = false;
            this.m_debug_verbosity = 2;
            this.m_traderComp = traderComp;
            this.m_support = supportAttrib;
            this.m_import = importAttrib;
            this.m_db = offerDatabase;
            Object object = supportAttrib.getTypeRepos();
            this.m_repos = ServiceTypeRepositoryHelper.narrow(object);
            this.m_link_if = linkImpl;
            String string = Environment.getProperty("jtrader.impl.cache_max");
            if (string != null) {
                try {
                    this.m_query_cache_max = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    Debug.output(2, exception);
                }
            }
            this.m_query_cache_lookup = new Hashtable((int)(1.3333333333333333 * (double)this.m_query_cache_max) + 10);
            this.m_query_cache_queue = new Vector(this.m_query_cache_max + 2);
            this.m_query_distrib = new QueryPropagator();
            String string2 = Environment.getProperty("jtrader.debug");
            if (string2 != null) {
                try {
                    this.m_debug = Boolean.valueOf(string2);
                }
                catch (Exception exception) {
                    Debug.output(2, exception);
                }
            }
            if ((string2 = Environment.getProperty("jtrader.debug_verbosity")) == null) break block8;
            try {
                this.m_debug_verbosity = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
    }

    public String _object_name() {
        return "TradingService";
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    public int def_search_card() {
        return this.m_import.getDefSearchCard();
    }

    public int max_search_card() {
        return this.m_import.getMaxSearchCard();
    }

    public int def_match_card() {
        return this.m_import.getDefMatchCard();
    }

    public int max_match_card() {
        return this.m_import.getMaxMatchCard();
    }

    public int def_return_card() {
        return this.m_import.getDefReturnCard();
    }

    public int max_return_card() {
        return this.m_import.getMaxReturnCard();
    }

    public int max_list() {
        return this.m_import.getMaxList();
    }

    public int def_hop_count() {
        return this.m_import.getDefHopCount();
    }

    public int max_hop_count() {
        return this.m_import.getMaxHopCount();
    }

    public FollowOption def_follow_policy() {
        return this.m_import.getDefFollowPolicy();
    }

    public FollowOption max_follow_policy() {
        return this.m_import.getMaxFollowPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String string, String string2, String string3, Policy[] policyArray, SpecifiedProps specifiedProps, int n, OfferSeqHolder offerSeqHolder, OfferIteratorHolder offerIteratorHolder, PolicyNameSeqHolder policyNameSeqHolder) throws IllegalServiceType, UnknownServiceType, IllegalConstraint, IllegalPreference, IllegalPolicyName, PolicyTypeMismatch, InvalidPolicyValue, IllegalPropertyName, DuplicatePropertyName, DuplicatePolicyName {
        int n2;
        java.lang.Object object;
        Policy[] policyArray2;
        int n3 = count++;
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "### query started: " + n3);
        }
        TypeStruct typeStruct = this.m_repos.fully_describe_type(string);
        Hashtable<String, Any> hashtable = new Hashtable<String, Any>();
        int n4 = 0;
        while (n4 < policyArray.length) {
            if (hashtable.containsKey(policyArray[n4].name)) {
                throw new DuplicatePolicyName(policyArray[n4].name);
            }
            hashtable.put(policyArray[n4].name, policyArray[n4].value);
            ++n4;
        }
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "### check id: " + n3);
        }
        String string4 = this.getPolicyValue(hashtable, "request_id", new String());
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        if (string4.length() == 0) {
            policyArray2 = new StringBuffer(new String(this.admin_if().request_id_stem()));
            policyArray2.append(m_query_counter++);
            object = new Policy();
            ((Policy)object).name = "request_id";
            ((Policy)object).value = this._orb().create_any();
            ((Policy)object).value.insert_string(policyArray2.toString());
            vector.addElement(object);
            string4 = policyArray2.toString();
        }
        if (this.queryAlreadyEncountered(string4)) {
            offerSeqHolder.value = new Offer[0];
            policyNameSeqHolder.value = new String[0];
            if (this.m_debug) {
                Debug.output(this.m_debug_verbosity, "### Refused query request. Reason: Query was already executed");
            }
            if (this.m_debug) {
                Debug.output(this.m_debug_verbosity, "### Returned from query " + n3);
            }
            return;
        }
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "### passed id check: " + n3);
        }
        if (!hashtable.containsKey("hop_count")) {
            policyArray2 = new Policy();
            policyArray2.name = "hop_count";
            policyArray2.value = this._orb().create_any();
            policyArray2.value.insert_ulong(this.def_hop_count());
            vector.addElement(policyArray2);
            hashtable.put("hop_count", policyArray2.value);
        }
        if (vector.size() > 0) {
            policyArray2 = new Policy[policyArray.length + vector.size()];
            System.arraycopy(policyArray, 0, policyArray2, 0, policyArray.length);
            object = vector.elements();
            n2 = policyArray.length;
            while (object.hasMoreElements()) {
                policyArray2[n2++] = (Policy)object.nextElement();
            }
            policyArray = policyArray2;
        }
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "### passed policy gen: " + n3);
        }
        int n5 = this.getPolicyValue(hashtable, "search_card", this.def_search_card(), this.max_search_card());
        int n6 = this.getPolicyValue(hashtable, "match_card", this.def_match_card(), this.max_match_card());
        n2 = this.getPolicyValue(hashtable, "return_card", this.def_return_card(), this.max_return_card());
        boolean bl = this.getPolicyValue(hashtable, "exact_type_match", false);
        boolean bl2 = !this.supports_dynamic_properties() ? false : this.getPolicyValue(hashtable, "use_dynamic_properties", true);
        boolean bl3 = !this.supports_modifiable_properties() ? false : this.getPolicyValue(hashtable, "use_modifiable_properties", true);
        boolean bl4 = !this.supports_proxy_offers() ? false : this.getPolicyValue(hashtable, "use_proxy_offers", true);
        FollowOption followOption = this.getPolicyValue(hashtable, "link_follow_rule", this.def_follow_policy(), this.max_follow_policy());
        int n7 = this.getPolicyValue(hashtable, "hop_count", this.def_hop_count(), this.max_hop_count());
        Any any = (Any)hashtable.get("hop_count");
        any.insert_ulong(any.extract_ulong() - 1);
        QueryContainer queryContainer = new QueryContainer(string, string2, string3, policyArray, specifiedProps, n, null);
        Vector vector2 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "++++++++++++++++++++++++ distribution started");
        }
        if (n7 > 0 && followOption.value() == FollowOption.always.value()) {
            this.distributeQuery(vector2, queryContainer, followOption, hashtable2);
        }
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "++++++++++++++++++++++++ distribution finished");
        }
        if (string3 == null || string3.trim().length() == 0) {
            string3 = "first";
        }
        SchemaAdapter schemaAdapter = new SchemaAdapter(typeStruct);
        Constraint constraint = new Constraint(schemaAdapter);
        Preference preference = new Preference(schemaAdapter);
        try {
            constraint.parse(string2);
        }
        catch (ParseException parseException) {
            System.out.println("Illegal constraint '" + string2 + "'");
            System.out.println(parseException.getMessage());
            throw new IllegalConstraint(string2);
        }
        try {
            preference.parse(string3);
        }
        catch (ParseException parseException) {
            System.out.println("Illegal preference '" + string3 + "'");
            System.out.println(parseException.getMessage());
            throw new IllegalPreference(string3);
        }
        Vector<String> vector3 = new Vector<String>();
        vector3.addElement(string);
        if (!bl) {
            this.findCompatibleTypes(string, vector3);
        }
        try {
            java.lang.Object object2;
            java.lang.Object object3;
            int n8;
            int n9;
            java.lang.Object object4;
            java.lang.Object object5;
            Serializable serializable;
            Enumeration<java.lang.Object> enumeration;
            Cloneable cloneable;
            java.lang.Object object6;
            this.m_db.begin(0);
            int n10 = 0;
            Vector<java.lang.Object> vector4 = new Vector<java.lang.Object>();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements() && n10 < n5) {
                object6 = (String)enumeration2.nextElement();
                cloneable = this.m_db.getOffers((String)object6);
                if (cloneable == null) continue;
                enumeration = ((Hashtable)cloneable).elements();
                while (enumeration.hasMoreElements() && n10 < n5) {
                    serializable = (OfferInfo)enumeration.nextElement();
                    object5 = new SourceAdapter(((OfferInfo)serializable).reference, ((OfferInfo)serializable).properties);
                    if (!this.considerOffer((SourceAdapter)object5, bl2, bl3, typeStruct)) continue;
                    vector4.addElement(object5);
                    ++n10;
                }
            }
            if (bl4) {
                enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements() && n10 < n5) {
                    object6 = (String)enumeration2.nextElement();
                    cloneable = this.m_db.getProxyOffers((String)object6);
                    if (cloneable == null) continue;
                    enumeration = ((Hashtable)cloneable).elements();
                    while (enumeration.hasMoreElements() && n10 < n5) {
                        serializable = (ProxyInfo)enumeration.nextElement();
                        object5 = new ProxySourceAdapter((ProxyInfo)serializable);
                        if (!this.considerOffer((SourceAdapter)object5, bl2, bl3, typeStruct)) continue;
                        vector4.addElement(object5);
                        ++n10;
                    }
                }
            }
            if (((Vector)(cloneable = ((OfferEvaluator)(object6 = new OfferEvaluator(string, constraint, string3, policyArray, specifiedProps, vector4, n6))).getResults())).size() == 0 && n7 > 0 && followOption.value() >= FollowOption.if_no_local.value()) {
                this.distributeQuery(vector2, queryContainer, followOption, hashtable2);
            }
            enumeration = vector2.elements();
            serializable = new Vector();
            object5 = new Vector();
            while (enumeration.hasMoreElements()) {
                QueryContainer queryContainer2;
                block56: {
                    queryContainer2 = (QueryContainer)enumeration.nextElement();
                    try {
                        if (this.m_debug) {
                            Debug.output(this.m_debug_verbosity, "+++++++++++++++Lookup, going to wait for " + queryContainer2.no);
                        }
                        queryContainer2.resultReady();
                        if (!this.m_debug) break block56;
                        Debug.output(this.m_debug_verbosity, "+++++++++++++++Lookup, finished waiting for " + queryContainer2.no);
                    }
                    catch (Exception exception) {
                        Debug.output(2, exception);
                        continue;
                    }
                }
                UserException userException = queryContainer2.getException();
                if (userException != null) {
                    Debug.output(2, userException);
                    ((Vector)serializable).addElement(queryContainer2);
                    continue;
                }
                object4 = queryContainer2.getOffers();
                if (((OfferSeqHolder)object4).value == null || ((OfferSeqHolder)object4).value.length == 0) {
                    ((Vector)serializable).addElement(queryContainer2);
                    continue;
                }
                n9 = 0;
                while (n9 < ((OfferSeqHolder)object4).value.length) {
                    ((Vector)cloneable).addElement(((OfferSeqHolder)object4).value[n9]);
                    ++n9;
                }
                PolicyNameSeqHolder policyNameSeqHolder2 = queryContainer2.getLimits();
                if (policyNameSeqHolder2.value == null) continue;
                n8 = 0;
                while (n8 < policyNameSeqHolder2.value.length) {
                    ((Vector)object5).addElement(policyNameSeqHolder2.value[n8]);
                    ++n8;
                }
            }
            int n11 = 0;
            while (n11 < ((Vector)serializable).size()) {
                vector2.removeElement(((Vector)serializable).elementAt(n11));
                ++n11;
            }
            int n12 = ((Vector)cloneable).size();
            object4 = preference.order((Vector)cloneable);
            n9 = Math.min(n12, n2);
            int n13 = Math.min(n9, n);
            offerSeqHolder.value = new Offer[n13];
            n8 = 0;
            enumeration2 = ((Vector)object4).elements();
            while (enumeration2.hasMoreElements() && n8 < n13) {
                object3 = enumeration2.nextElement();
                if (object3 instanceof Offer) {
                    offerSeqHolder.value[n8] = (Offer)object3;
                } else {
                    object2 = (SourceAdapter)object3;
                    offerSeqHolder.value[n8] = new Offer();
                    offerSeqHolder.value[n8].reference = ((SourceAdapter)object2).getObject();
                    offerSeqHolder.value[n8].properties = ((SourceAdapter)object2).getProperties(specifiedProps);
                }
                ++n8;
            }
            if (n13 < n9) {
                Offer[] offerArray;
                java.lang.Object object7;
                java.lang.Object object8;
                int n14 = n9 - n13;
                object2 = new Vector(n14);
                int n15 = 0;
                while (enumeration2.hasMoreElements() && n15 < n14) {
                    object8 = enumeration2.nextElement();
                    if (object8 instanceof Offer) {
                        ((Vector)object2).addElement(object8);
                    } else {
                        object7 = (Offer[])object8;
                        offerArray = new Offer();
                        offerArray.reference = ((SourceAdapter)object7).getObject();
                        offerArray.properties = ((SourceAdapter)object7).getProperties(specifiedProps);
                        ((Vector)object2).addElement(offerArray);
                    }
                    ++n15;
                }
                enumeration = vector2.elements();
                while (n15 < n14 && enumeration.hasMoreElements()) {
                    ++n15;
                    object8 = (QueryContainer)enumeration.nextElement();
                    object7 = ((QueryContainer)object8).getItr();
                    if (((OfferIteratorHolder)object7).value == null) continue;
                    offerArray = null;
                    try {
                        offerArray = ((OfferIteratorImpl)((java.lang.Object)((OfferIteratorHolder)object7).value)).getOffers();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (offerArray == null) {
                        OfferIterator offerIterator = ((OfferIteratorHolder)object7).value;
                        OfferSeqHolder offerSeqHolder2 = new OfferSeqHolder();
                        offerIterator.next_n(n14 - n15, offerSeqHolder2);
                        offerArray = offerSeqHolder2.value;
                    }
                    int n16 = 0;
                    while (n16 < offerArray.length && n15 < n14) {
                        ++n15;
                        ((Vector)object2).addElement(offerArray[n16++]);
                    }
                }
                object8 = ((Vector)object2).elements();
                object7 = new Offer[((Vector)object2).size()];
                int n17 = 0;
                while (object8.hasMoreElements()) {
                    object7[n17++] = (Offer)object8.nextElement();
                }
                OfferIteratorImpl offerIteratorImpl = new OfferIteratorImpl((Offer[])object7, 0);
                offerIteratorImpl._this_object(this._orb());
                offerIteratorHolder.value = offerIteratorImpl._this();
                if (this.m_debug) {
                    Debug.output(this.m_debug_verbosity, "Returned " + ((java.lang.Object)object7).length + " offers via Iterator");
                }
            }
            object3 = ((Vector)object5).elements();
            policyNameSeqHolder.value = new String[((Vector)object5).size()];
            int n18 = 0;
            while (object3.hasMoreElements()) {
                policyNameSeqHolder.value[n18++] = (String)object3.nextElement();
            }
            if (this.m_debug) {
                Debug.output(this.m_debug_verbosity, "Returned " + offerSeqHolder.value.length + " offers");
            }
            if (this.m_debug) {
                Debug.output(this.m_debug_verbosity, "### Returned from query " + n3);
            }
            java.lang.Object var56_69 = null;
            this.m_db.end();
        }
        catch (Throwable throwable) {
            java.lang.Object var56_70 = null;
            this.m_db.end();
            throw throwable;
        }
    }

    private boolean queryAlreadyEncountered(String string) {
        boolean bl = this.m_query_cache_lookup.containsKey(string);
        if (!bl) {
            this.m_query_cache_lookup.put(string, string);
            this.m_query_cache_queue.addElement(string);
            if (this.m_query_cache_queue.size() > this.m_query_cache_max) {
                java.lang.Object e = this.m_query_cache_queue.firstElement();
                this.m_query_cache_queue.removeElementAt(0);
                this.m_query_cache_lookup.remove(e);
            }
        }
        return bl;
    }

    protected FollowOption getPolicyValue(Hashtable hashtable, String string, FollowOption followOption, FollowOption followOption2) throws PolicyTypeMismatch, InvalidPolicyValue {
        FollowOption followOption3 = followOption;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                TypeCode typeCode = FollowOptionHelper.type();
                if (!typeCode.equal(any.type())) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                followOption3 = FollowOptionHelper.extract(any);
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        return FollowOption.from_int(Math.min(followOption3.value(), followOption2.value()));
    }

    private void updateLinks() {
        if (this.m_link_if.linksChanged()) {
            this.m_links_cache = this.m_link_if.getLinks();
        }
    }

    private void distributeQuery(Vector vector, QueryContainer queryContainer, FollowOption followOption, Hashtable hashtable) {
        this.updateLinks();
        LinkInfo[] linkInfoArray = this.m_links_cache;
        int n = 0;
        while (n < linkInfoArray.length) {
            if (linkInfoArray[n].limiting_follow_rule.value() >= followOption.value() && !hashtable.containsKey(linkInfoArray[n].target)) {
                QueryContainer queryContainer2 = new QueryContainer(queryContainer, linkInfoArray[n].target);
                vector.addElement(queryContainer2);
                this.m_query_distrib.putWork(queryContainer2);
                hashtable.put(linkInfoArray[n].target, linkInfoArray[n].target);
            }
            ++n;
        }
    }

    protected int getPolicyValue(Hashtable hashtable, String string, int n, int n2) throws PolicyTypeMismatch, InvalidPolicyValue {
        int n3 = n;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                if (any.type().kind() != TCKind.tk_ulong) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                n3 = any.extract_ulong();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        n3 = Math.min(n3, n2);
        return n3;
    }

    protected boolean getPolicyValue(Hashtable hashtable, String string, boolean bl) throws PolicyTypeMismatch, InvalidPolicyValue {
        boolean bl2 = bl;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                if (any.type().kind() != TCKind.tk_boolean) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                bl2 = any.extract_boolean();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        return bl2;
    }

    protected String getPolicyValue(Hashtable hashtable, String string, String string2) throws PolicyTypeMismatch, InvalidPolicyValue {
        String string3 = string2;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                if (any.type().kind() != TCKind.tk_string) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                string3 = any.extract_string();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        return string3;
    }

    protected void findCompatibleTypes(String string, Vector vector) {
        SpecifiedServiceTypes specifiedServiceTypes = new SpecifiedServiceTypes();
        specifiedServiceTypes.__default();
        String[] stringArray = this.m_repos.list_types(specifiedServiceTypes);
        int n = 0;
        while (n < stringArray.length) {
            try {
                TypeStruct typeStruct = this.m_repos.fully_describe_type(stringArray[n]);
                int n2 = 0;
                while (n2 < typeStruct.super_types.length) {
                    if (string.equals(typeStruct.super_types[n2])) {
                        if (!vector.contains(stringArray[n])) {
                            vector.addElement(stringArray[n]);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (IllegalServiceType illegalServiceType) {
            }
            catch (UnknownServiceType unknownServiceType) {
                // empty catch block
            }
            ++n;
        }
    }

    protected boolean considerOffer(SourceAdapter sourceAdapter, boolean bl, boolean bl2, TypeStruct typeStruct) {
        Property[] propertyArray;
        if (!bl && PropUtil.hasDynamicProperties(propertyArray = sourceAdapter.getProperties())) {
            return false;
        }
        if (!bl2) {
            int n = 0;
            while (n < typeStruct.props.length) {
                if ((typeStruct.props[n].mode == PropertyMode.PROP_NORMAL || typeStruct.props[n].mode == PropertyMode.PROP_MANDATORY) && sourceAdapter.exists(typeStruct.props[n].name)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    static {
        count = 0;
    }
}

