/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.trading.constraint.Constraint;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.OfferUtil;
import org.jacorb.trading.impl.SchemaAdapter;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.Contained;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.SystemException;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalOfferId;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.NotImplemented;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPOA;
import org.omg.CosTrading.RegisterPackage.IllegalTraderName;
import org.omg.CosTrading.RegisterPackage.InterfaceTypeMismatch;
import org.omg.CosTrading.RegisterPackage.InvalidObjectRef;
import org.omg.CosTrading.RegisterPackage.MandatoryProperty;
import org.omg.CosTrading.RegisterPackage.NoMatchingOffers;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTrading.RegisterPackage.ProxyOfferId;
import org.omg.CosTrading.RegisterPackage.ReadonlyProperty;
import org.omg.CosTrading.RegisterPackage.RegisterNotSupported;
import org.omg.CosTrading.RegisterPackage.UnknownPropertyName;
import org.omg.CosTrading.RegisterPackage.UnknownTraderName;
import org.omg.CosTrading.UnknownOfferId;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class RegisterImpl
extends RegisterPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;
    private Repository m_interfaceRepos;

    private RegisterImpl() {
    }

    public RegisterImpl(TraderComp traderComp, SupportAttrib supportAttrib, OfferDatabase offerDatabase, Repository repository) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_db = offerDatabase;
        this.m_interfaceRepos = repository;
        Object object = supportAttrib.getTypeRepos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(object);
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(Object object, String string, Property[] propertyArray) throws InvalidObjectRef, IllegalServiceType, UnknownServiceType, InterfaceTypeMismatch, IllegalPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MissingMandatoryProperty, DuplicatePropertyName {
        String string2 = null;
        if (object == null) {
            throw new InvalidObjectRef(object);
        }
        TypeStruct typeStruct = this.m_repos.fully_describe_type(string);
        if (typeStruct.masked) {
            throw new UnknownServiceType(string);
        }
        this.validateInterface(object, string, typeStruct);
        OfferUtil.validateProperties(this.m_db, propertyArray, string, typeStruct);
        this.m_db.begin(1);
        try {
            string2 = this.m_db.create(string, object, propertyArray);
            java.lang.Object var7_6 = null;
            this.m_db.end();
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            this.m_db.end();
            throw throwable;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdraw(String string) throws IllegalOfferId, UnknownOfferId, ProxyOfferId {
        if (!this.m_db.validateOfferId(string)) {
            throw new IllegalOfferId(string);
        }
        this.m_db.begin(1);
        try {
            if (!this.m_db.exists(string)) {
                throw new UnknownOfferId(string);
            }
            if (this.m_db.isProxy(string)) {
                throw new ProxyOfferId(string);
            }
            this.m_db.remove(string);
            java.lang.Object var3_2 = null;
            this.m_db.end();
        }
        catch (Throwable throwable) {
            java.lang.Object var3_3 = null;
            this.m_db.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfferInfo describe(String string) throws IllegalOfferId, UnknownOfferId, ProxyOfferId {
        OfferInfo offerInfo;
        if (!this.m_db.validateOfferId(string)) {
            throw new IllegalOfferId(string);
        }
        this.m_db.begin(0);
        try {
            if (!this.m_db.exists(string)) {
                throw new UnknownOfferId(string);
            }
            if (this.m_db.isProxy(string)) {
                throw new ProxyOfferId(string);
            }
            offerInfo = this.m_db.describe(string);
            java.lang.Object var4_3 = null;
            this.m_db.end();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            this.m_db.end();
            throw throwable;
        }
        return offerInfo;
    }

    public void modify(String string, String[] stringArray, Property[] propertyArray) throws NotImplemented, IllegalOfferId, UnknownOfferId, ProxyOfferId, IllegalPropertyName, UnknownPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MandatoryProperty, ReadonlyProperty, DuplicatePropertyName {
        if (!this.m_support.getModifiableProperties()) {
            throw new NotImplemented();
        }
        if (!this.m_db.validateOfferId(string)) {
            throw new IllegalOfferId(string);
        }
        try {
            try {
                this.m_db.begin(1);
                if (!this.m_db.exists(string)) {
                    throw new UnknownOfferId(string);
                }
                if (this.m_db.isProxy(string)) {
                    throw new ProxyOfferId(string);
                }
                String string2 = this.m_db.whichService(string);
                TypeStruct typeStruct = this.m_repos.fully_describe_type(string2);
                OfferInfo offerInfo = this.m_db.describe(string);
                this.checkDelete(stringArray, string2, typeStruct, offerInfo);
                this.checkModify(propertyArray, string2, typeStruct, offerInfo);
                Vector<Property> vector = new Vector<Property>();
                int n = 0;
                while (n < propertyArray.length) {
                    vector.addElement(propertyArray[n]);
                    ++n;
                }
                int n2 = 0;
                while (n2 < offerInfo.properties.length) {
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < stringArray.length && !bl) {
                        if (offerInfo.properties[n2].name.equals(stringArray[n3])) {
                            bl = true;
                        }
                        ++n3;
                    }
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements() && !bl) {
                        Property property = (Property)enumeration.nextElement();
                        if (!offerInfo.properties[n2].name.equals(property.name)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        vector.addElement(offerInfo.properties[n2]);
                    }
                    ++n2;
                }
                Property[] propertyArray2 = new Property[vector.size()];
                vector.copyInto(propertyArray2);
                this.m_db.modify(string, propertyArray2);
            }
            catch (IllegalServiceType illegalServiceType) {
                throw new UnknownOfferId(string);
            }
            catch (UnknownServiceType unknownServiceType) {
                throw new UnknownOfferId(string);
            }
            java.lang.Object var15_17 = null;
            this.m_db.end();
        }
        catch (Throwable throwable) {
            java.lang.Object var15_18 = null;
            this.m_db.end();
            throw throwable;
        }
    }

    public void withdraw_using_constraint(String string, String string2) throws IllegalServiceType, UnknownServiceType, IllegalConstraint, NoMatchingOffers {
        TypeStruct typeStruct = this.m_repos.fully_describe_type(string);
        SchemaAdapter schemaAdapter = new SchemaAdapter(typeStruct);
        Constraint constraint = new Constraint(schemaAdapter);
        int n = 0;
        try {
            block6: {
                try {
                    this.m_db.begin(1);
                    constraint.parse(string2);
                    Hashtable hashtable = this.m_db.getOffers(string);
                    if (hashtable == null) break block6;
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        OfferInfo offerInfo = (OfferInfo)hashtable.get(string3);
                        SourceAdapter sourceAdapter = new SourceAdapter(offerInfo.reference, offerInfo.properties);
                        if (!constraint.evaluate(sourceAdapter)) continue;
                        this.m_db.remove(string3);
                        ++n;
                    }
                }
                catch (ParseException parseException) {
                    System.out.println("Illegal constraint '" + string2 + "'");
                    System.out.println(parseException.getMessage());
                    throw new IllegalConstraint(string2);
                }
            }
            java.lang.Object var13_13 = null;
            this.m_db.end();
        }
        catch (Throwable throwable) {
            java.lang.Object var13_14 = null;
            this.m_db.end();
            throw throwable;
        }
        if (n == 0) {
            throw new NoMatchingOffers(string2);
        }
    }

    public Register resolve(String[] stringArray) throws IllegalTraderName, UnknownTraderName, RegisterNotSupported {
        throw new RegisterNotSupported(stringArray);
    }

    protected void validateInterface(Object object, String string, TypeStruct typeStruct) throws InterfaceTypeMismatch {
        block3: {
            if (this.m_interfaceRepos == null) break block3;
            try {
                String string2;
                InterfaceDef interfaceDef = InterfaceDefHelper.narrow(object._get_interface_def());
                Contained contained = this.m_interfaceRepos.lookup(typeStruct.if_name);
                if (interfaceDef != null && contained != null && !interfaceDef.is_a(string2 = contained.id())) {
                    throw new InterfaceTypeMismatch(string, object);
                }
            }
            catch (SystemException systemException) {}
        }
    }

    protected void checkDelete(String[] stringArray, String string, TypeStruct typeStruct, OfferInfo offerInfo) throws IllegalPropertyName, UnknownPropertyName, MandatoryProperty, ReadonlyProperty, DuplicatePropertyName {
        Hashtable<String, Property> hashtable = new Hashtable<String, Property>();
        int n = 0;
        while (n < offerInfo.properties.length) {
            hashtable.put(offerInfo.properties[n].name, offerInfo.properties[n]);
            ++n;
        }
        Hashtable<String, PropStruct> hashtable2 = new Hashtable<String, PropStruct>();
        int n2 = 0;
        while (n2 < typeStruct.props.length) {
            hashtable2.put(typeStruct.props[n2].name, typeStruct.props[n2]);
            ++n2;
        }
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string2 = stringArray[n3];
            if (hashtable3.containsKey(string2)) {
                throw new DuplicatePropertyName(string2);
            }
            hashtable3.put(string2, string2);
            Property property = (Property)hashtable.get(string2);
            if (property != null) {
                PropStruct propStruct = (PropStruct)hashtable2.get(string2);
                if (propStruct != null && OfferUtil.isMandatory(propStruct.mode)) {
                    throw new MandatoryProperty(string, string2);
                }
            } else {
                throw new UnknownPropertyName(string2);
            }
            ++n3;
        }
    }

    protected void checkModify(Property[] propertyArray, String string, TypeStruct typeStruct, OfferInfo offerInfo) throws IllegalPropertyName, UnknownPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, ReadonlyProperty, DuplicatePropertyName {
        Hashtable<String, Property> hashtable = new Hashtable<String, Property>();
        int n = 0;
        while (n < propertyArray.length) {
            hashtable.put(propertyArray[n].name, propertyArray[n]);
            ++n;
        }
        Hashtable<String, Property> hashtable2 = new Hashtable<String, Property>();
        int n2 = 0;
        while (n2 < offerInfo.properties.length) {
            hashtable2.put(offerInfo.properties[n2].name, offerInfo.properties[n2]);
            ++n2;
        }
        Hashtable<String, PropStruct> hashtable3 = new Hashtable<String, PropStruct>();
        int n3 = 0;
        while (n3 < typeStruct.props.length) {
            hashtable3.put(typeStruct.props[n3].name, typeStruct.props[n3]);
            ++n3;
        }
        Hashtable<String, Property> hashtable4 = new Hashtable<String, Property>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            if (hashtable4.containsKey(property.name)) {
                throw new DuplicatePropertyName(property.name);
            }
            hashtable4.put(property.name, property);
            PropStruct propStruct = (PropStruct)hashtable3.get(property.name);
            if (propStruct == null) {
                throw new UnknownPropertyName(property.name);
            }
            if (hashtable2.containsKey(property.name) && OfferUtil.isReadonly(propStruct.mode)) {
                throw new ReadonlyProperty(string, property.name);
            }
            OfferUtil.checkProperty(string, property, propStruct);
        }
    }
}

