/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import org.jacorb.transaction.Sleeper;
import org.omg.CORBA.INTERNAL;

public class Timer
extends Thread {
    private boolean stoped = true;
    private Channel[] channels;
    private int top;

    Timer(int n) {
        this.channels = new Channel[n];
        int n2 = 0;
        while (n2 < this.channels.length) {
            this.channels[n2] = null;
            ++n2;
        }
        this.top = 0;
        this.start();
    }

    private int find_free() {
        int n = 0;
        while (n < this.channels.length) {
            if (this.channels[n] == null) {
                return n;
            }
            ++n;
        }
        throw new INTERNAL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            if (!this.stoped) {
                this.stoped = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void go() {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            if (this.stoped) {
                this.stoped = false;
                this.resume();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add_channel(Sleeper sleeper, int n) {
        if (n <= 0) {
            throw new INTERNAL();
        }
        Channel channel = new Channel(sleeper, n);
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            int n2 = this.find_free();
            if (n2 > this.top) {
                throw new INTERNAL();
            }
            if (n2 == this.top) {
                ++this.top;
            }
            this.channels[n2] = channel;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.go();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy_channel(int n) {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            this.channels[n] = null;
            if (this.top - 1 == n) {
                --this.top;
            }
            if (this.top == 0) {
                this.stoped = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill_channel(Sleeper sleeper) {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            int n = 0;
            while (n < this.top) {
                if (this.channels[n] != null && this.channels[n].slp == sleeper) {
                    this.destroy_channel(n);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void count() {
        int n = this.top;
        int n2 = 0;
        while (n2 < n) {
            if (this.channels[n2] != null && this.channels[n2].time != 0) {
                --this.channels[n2].time;
                if (this.channels[n2].time == 0) {
                    this.channels[n2].slp.wakeup();
                }
            }
            ++n2;
        }
    }

    public void run() {
        try {
            while (true) {
                if (this.stoped) {
                    this.suspend();
                    continue;
                }
                Thread.sleep(1000L);
                this.count();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
            return;
        }
    }

    class Channel {
        Sleeper slp;
        int time;

        Channel(Sleeper sleeper, int n) {
            this.slp = sleeper;
            this.time = n;
        }
    }
}

