/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.PrintWriter;
import org.jacorb.util.AssertionViolation;
import org.jacorb.util.Environment;

public final class Debug {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static StringBuffer sb = new StringBuffer();
    private static int _verbosity;
    private static int _category;
    private static PrintWriter _log_file_out;
    public static final int QUIET = 0;
    public static final int IMPORTANT = 1;
    public static final int INFORMATION = 2;
    public static final int DEBUG1 = 3;
    public static final int ORB_CONNECT = 256;
    public static final int ORB_MISC = 512;
    public static final int POA = 1024;
    public static final int IMR = 2048;
    public static final int DSI = 4096;
    public static final int DII = 8192;
    public static final int INTERCEPTOR = 16384;
    public static final int DOMAIN = 32768;
    public static final int PROXY = 65536;
    public static final int COMPILER = 131072;
    public static final int TOOLS = 262144;
    public static final int NAMING = 0x1000000;
    public static final int TRADING = 0x2000000;
    public static final int EVENTS = 0x4000000;
    public static final int TRANSACTION = 0x8000000;
    public static final int SECURITY = 0x10000000;

    public static final void initialize() {
        _verbosity = Environment.verbosityLevel() & 0xFF;
        _category = Environment.verbosityLevel() & 0xFFFFFF00;
        if (_category == 0) {
            _category = -256;
        }
        _log_file_out = Environment.logFileOut();
    }

    public static boolean canOutput(int n) {
        int n2 = n & 0xFFFFFF00;
        int n3 = n & 0xFF;
        if (n2 == 0) {
            n2 = -256;
        }
        return (n2 & _category) != 0 && n3 <= _verbosity;
    }

    public static final void output(int n, String string) {
        if (Debug.canOutput(n)) {
            if (_log_file_out == null) {
                System.out.println("[ " + string + " ]");
            } else {
                _log_file_out.println("[ " + Environment.time() + "> " + string + " ]");
                _log_file_out.flush();
            }
        }
    }

    public static synchronized void output(int n, String string, byte[] byArray) {
        Debug.output(n, string, byArray, 0, byArray.length);
    }

    public static synchronized void output(int n, String string, byte[] byArray, int n2) {
        Debug.output(n, string, byArray, 0, n2);
    }

    public static synchronized void output(int n, String string, byte[] byArray, int n2, int n3) {
        if (Debug.canOutput(n)) {
            System.out.print("\nHexdump [" + string + "] len=" + n3 + "," + byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = n2;
            while (n4 < n2 + n3) {
                if (n4 % 16 == 0) {
                    System.out.println(stringBuffer);
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(Debug.toAscii(byArray[n4]));
                System.out.print(Debug.toHex(byArray[n4]));
                if (n4 % 4 == 3) {
                    stringBuffer.append(' ');
                    System.out.print(' ');
                }
                ++n4;
            }
            if (n3 % 16 != 0) {
                int n5 = 0;
                int n6 = 16 - n3 % 16;
                n5 = n6 * 3;
                n5 += n6 / 4;
                int n7 = 0;
                while (n7 < n5) {
                    stringBuffer.insert(0, ' ');
                    ++n7;
                }
            }
            System.out.println(stringBuffer);
        }
    }

    public static final String toHex(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = by >> 4 & 0xF;
        stringBuffer.append(lookup[n]);
        int n2 = by & 0xF;
        stringBuffer.append(lookup[n2]);
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }

    public static final char toAscii(byte by) {
        if (by > 31 && by < 127) {
            return (char)by;
        }
        return '.';
    }

    public static final void output(int n, Throwable throwable) {
        if (Debug.canOutput(n)) {
            if (_log_file_out == null || n == 0) {
                System.out.println("############################ StackTrace ############################");
                throwable.printStackTrace(System.out);
                System.out.println("####################################################################");
            }
            if (_log_file_out != null) {
                _log_file_out.println("############################ StackTrace ############################");
                throwable.printStackTrace(_log_file_out);
                _log_file_out.println("####################################################################");
                _log_file_out.flush();
            }
        }
    }

    public static void printTrace(int n) {
        if (Debug.canOutput(n)) {
            try {
                throw new RuntimeException();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void myAssert(int n, boolean bl, String string) {
        if (Debug.canOutput(n) && !bl) {
            throw new AssertionViolation(string);
        }
    }

    public static void myAssert(boolean bl, String string) {
        Debug.myAssert(1, bl, string);
    }

    static {
        _log_file_out = Environment.logFileOut();
        Debug.initialize();
    }
}

