/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.tracing;

import java.util.Calendar;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.RecursionAwareCI;
import org.jacorb.util.tracing.Request;
import org.jacorb.util.tracing.RequestHelper;
import org.jacorb.util.tracing.Timer;
import org.jacorb.util.tracing.TraceData;
import org.jacorb.util.tracing.TracingService;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;

public class ClientTraceInterceptor
extends RecursionAwareCI {
    private static final int TRACE_POLICY_TYPE = 303;
    private static final String TRACE = "trace";
    private static final String OFF = "off";
    private Calendar date = Calendar.getInstance();
    private TracingService tracer;
    private int myTraceId;
    private Codec codec;
    private Request current_request = null;
    private int slot_id;
    private Timer timer;

    public ClientTraceInterceptor(Codec codec, int n, TracingService tracingService) {
        super(true);
        this.tracer = tracingService;
        this.codec = codec;
        this.slot_id = n;
        this.myTraceId = tracingService.get_id();
        this.timer = new Timer();
        System.out.println(" ********************************** ");
        System.out.println("          My id: " + this.myTraceId);
        System.out.println(" ********************************** ");
    }

    public String name() {
        return "ClientTraceInterceptor";
    }

    public void destroy() {
    }

    public void do_send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        try {
            if (clientRequestInfo.response_expected()) {
                IDLEntity iDLEntity;
                System.out.println("request: call to op " + clientRequestInfo.operation());
                this.current_request = new Request(this.myTraceId, clientRequestInfo.effective_target().hashCode() << 32 | (this.myTraceId & 0xFFFF) << 16 | clientRequestInfo.request_id() & 0xFFFF);
                Any any = clientRequestInfo.get_slot(this.slot_id);
                if (any.type().kind().value() != 0) {
                    iDLEntity = RequestHelper.extract(any);
                    this.tracer.registerSubTrace((Request)iDLEntity, this.current_request);
                }
                iDLEntity = ((ClientRequestInfoImpl)clientRequestInfo).orb.create_any();
                RequestHelper.insert((Any)iDLEntity, this.current_request);
                ServiceContext serviceContext = new ServiceContext(0x7F00FF00, this.codec.encode((Any)iDLEntity));
                this.timer.start(clientRequestInfo.request_id(), clientRequestInfo.target());
                clientRequestInfo.add_request_service_context(serviceContext, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void do_send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void do_receive_reply(ClientRequestInfo clientRequestInfo) {
        try {
            System.out.println("reply: return from op " + clientRequestInfo.operation());
            long l = this.timer.stop(clientRequestInfo.request_id(), clientRequestInfo.target());
            this.tracer.logTraceAtPoint(this.current_request, clientRequestInfo.operation(), l, 0L);
            TraceData traceData = this.tracer.getTrace(this.current_request);
            System.out.println("-- Trace for request " + clientRequestInfo.operation() + " (rid:" + clientRequestInfo.request_id() + ") -- ");
            this.printTrace(traceData, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void do_receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void do_receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    private void printTrace(TraceData traceData, String string) {
        System.out.println(string + " Request originator: " + traceData.tracer_id);
        System.out.println(string + " Operation: " + traceData.operation);
        System.out.println(string + " Time: " + traceData.client_time + " msecs");
        int n = 0;
        while (n < traceData.subtrace.length) {
            System.out.println(string + "\tsubtrace " + n + " >>>");
            this.printTrace(traceData.subtrace[n], string + '\t');
            System.out.println(string + "\t<<< subtrace " + n);
            ++n;
        }
    }
}

