/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadata.search.utils;

import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.model.Asset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.postgresql.util.PGobject;

public class DbAssetIdHandler {
    Connection con;
    private static final Logger logger = Logger.getLogger(DbAssetIdHandler.class);

    public DbAssetIdHandler(Connection con) {
        this.con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchInsert(List<Map<Asset, String>> batchAssetKeys) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(IdDAO.assetKeyTable);
        sb.append("(");
        sb.append(IdDAO.documentIdColumn);
        sb.append(",");
        sb.append(IdDAO.assetIdColumn);
        sb.append(",");
        sb.append(IdDAO.keysJsonColumn);
        sb.append(")");
        sb.append(" values (?1,?2,?3)");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            for (Map<Asset, String> assetKeys : batchAssetKeys) {
                Set<Asset> assets = assetKeys.keySet();
                for (Asset asset : assets) {
                    PGobject dataObject = new PGobject();
                    dataObject.setType("json");
                    dataObject.setValue(assetKeys.get(asset));
                    Asset root = asset.getRoot() != null ? asset.getRoot() : asset;
                    ps.setLong(1, root.getId());
                    ps.setLong(2, asset.getId());
                    ps.setObject(3, dataObject);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchDelete(List<Long> docIds) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ");
        sb.append(IdDAO.assetKeyTable);
        sb.append(" where ");
        sb.append(IdDAO.documentIdColumn);
        sb.append("=?1");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            for (Long docId : docIds) {
                ps.setLong(1, docId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }
}

