/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadata.search.utils;

import com.ericsson.metadata.search.utils.DbAssetIdHandler;
import com.ericsson.metadata.search.utils.DbDocHandler;
import com.ericsson.metadata.search.utils.ResynchSpecIds;
import com.tandbergtv.metadatamanager.assetkey.AssetKeyHandler;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.util.binder.ECMFBinder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class IdSyncTask
implements Callable<Integer> {
    int batchNum;
    List<Long> docIds;
    List<Long> titleIds;
    ResynchSpecIds master;
    private static final Logger logger = Logger.getLogger(IdSyncTask.class);

    public IdSyncTask(ResynchSpecIds master, int batchNum, List<Long> docIds, List<Long> titleIds) {
        this.master = master;
        this.batchNum = batchNum;
        this.docIds = docIds;
        this.titleIds = titleIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        logger.info((Object)("Processing batch #" + this.batchNum + " for Title IDS = " + this.titleIds.toString()));
        int count = 0;
        long t0 = System.currentTimeMillis();
        Connection con = this.master.getConnection();
        try {
            DbDocHandler src = new DbDocHandler(con);
            DbAssetIdHandler sink = new DbAssetIdHandler(con);
            long t1 = System.currentTimeMillis();
            List<Document> docs = src.queryDoc(this.docIds);
            if (docs.isEmpty()) {
                logger.info((Object)("Failed to get metadata for the following title IDs:" + this.titleIds.toString()));
                Integer n = count;
                return n;
            }
            ArrayList<Map<Asset, String>> batchAssetKeys = new ArrayList<Map<Asset, String>>();
            for (Document doc : docs) {
                List rootAssets = new ECMFBinder().bind(doc);
                Asset rootAsset = (Asset)rootAssets.get(0);
                Map updData = AssetKeyHandler.getDataForUpdate((Asset)rootAsset);
                ++count;
                if (updData.isEmpty()) continue;
                batchAssetKeys.add(updData);
                if (!logger.isDebugEnabled()) continue;
                Set assets = updData.keySet();
                for (Asset a : assets) {
                    logger.debug((Object)("Asset ID=" + a.getId() + " json=" + (String)updData.get(a)));
                }
            }
            long t2 = System.currentTimeMillis();
            if (!batchAssetKeys.isEmpty()) {
                sink.executeBatchInsert(batchAssetKeys);
            } else {
                logger.info((Object)("No asset keys for the following Title IDs:" + this.titleIds.toString()));
            }
            long t3 = System.currentTimeMillis();
            logger.info((Object)("Completed batch #" + this.batchNum + " size=" + this.docIds.size() + " connection=" + (t1 - t0) + "  get/convert=" + (t2 - t1) + " ms  update=" + (t3 - t2) + " ms"));
        }
        finally {
            this.master.closeConnection(con);
        }
        return count;
    }
}

