/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadata.search.utils;

import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.assetkey.PgFieldAllIndexInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PgIndexInfo {
    public static final String TABLE_NAME = "TABLE_NAME";
    Connection con;
    private static final Logger logger = Logger.getLogger(PgIndexInfo.class);

    public PgIndexInfo(Connection con) {
        this.con = con;
    }

    public Collection<List<String>> getIndexedFields() {
        Collection<List<String>> indexedXpaths = new ArrayList<List<String>>();
        try {
            Map allUniqueIndexs = (Map)PgFieldAllIndexInfo.getAllIndexes((Connection)this.con).get(PgFieldAllIndexInfo.UNIQUE_INDEX);
            if (allUniqueIndexs != null && !allUniqueIndexs.isEmpty()) {
                indexedXpaths = allUniqueIndexs.values();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return indexedXpaths;
    }

    private boolean checkTable(String tableName) {
        try {
            DatabaseMetaData dbmd = this.con.getMetaData();
            String[] tableTypes = new String[]{"TABLE"};
            ResultSet indexList = dbmd.getTables(null, null, null, tableTypes);
            while (indexList.next()) {
                if (!tableName.equalsIgnoreCase(indexList.getString(TABLE_NAME))) continue;
                return true;
            }
            indexList.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(List<String> ddls) throws SQLException {
        try (Statement st = null;){
            st = this.con.createStatement();
            for (String ddl : ddls) {
                st.addBatch(ddl);
                logger.info((Object)("Executing " + ddl));
            }
            st.executeBatch();
        }
    }

    public void prepareAssetKeyTable() {
        ArrayList<String> ddlList = new ArrayList<String>();
        boolean exist = this.checkTable(IdDAO.assetKeyTable);
        Long start = System.currentTimeMillis();
        try {
            if (!exist) {
                String errorMessage = "Table MDM_ASSET_IDENTIFIER does not exist. This is a CRITICAL database issue, please contact Support to recover the table.";
                logger.error((Object)errorMessage);
                throw new RuntimeException(errorMessage);
            }
            ddlList.add(this.getTruncateTableSql());
            ddlList.addAll(this.getDropIndexSql());
            this.execute(ddlList);
            logger.info((Object)("take " + (System.currentTimeMillis() - start) + " milliseconds to prepare asset key table"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String getTruncateTableSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("truncate table wfs.");
        sb.append(IdDAO.assetKeyTable);
        return sb.toString();
    }

    private Set<String> getDropIndexSql() throws SQLException {
        HashSet<String> dropIndexSqlSet = new HashSet<String>();
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = dbmd.getIndexInfo(null, "wfs", IdDAO.assetKeyTable, false, false);
        while (rs.next()) {
            if (rs.getBoolean("NON_UNIQUE") || IdDAO.assetIdColumn.equalsIgnoreCase(rs.getString("COLUMN_NAME"))) continue;
            dropIndexSqlSet.add("drop index wfs." + rs.getString("INDEX_NAME"));
        }
        return dropIndexSqlSet;
    }
}

