/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadata.search.utils;

import com.ericsson.metadata.search.utils.IdSyncTask;
import com.ericsson.metadata.search.utils.PgIndexInfo;
import com.ericsson.metadata.search.utils.SlimSpecBuilder;
import com.tandbergtv.metadatamanager.JPFActivator;
import com.tandbergtv.metadatamanager.assetkey.AssetKeyManager;
import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ValidatorHelper;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ResynchSpecIds {
    private static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    private static final Logger logger = Logger.getLogger(ResynchSpecIds.class);
    private static String jdbcDriver;
    private static String url;
    private static String user;
    private static String pwd;
    private static boolean forceOption;
    private static int batchSize;
    private static int numThreads;
    private ExecutorService executor;
    private int batchNum = 0;
    private Collection<ISpecHandler> uniqueSpecHandlers;
    private List<Future<Integer>> resultList = new ArrayList<Future<Integer>>();
    private IdDAO idDAO;
    private ApplicationContext context;

    public ResynchSpecIds() throws Exception {
        this.setUp();
    }

    private Connection getNonPooledConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection(url, user, pwd);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RuntimeException("Error connecting to database");
        }
        return conn;
    }

    public Connection getConnection() {
        return this.getNonPooledConnection();
    }

    public void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"cannot close connection", (Throwable)e);
        }
    }

    private void setUp() throws Exception {
        PropertyConfigurator.configure((String)"conf/log4j.properties");
        ResynchSpecIds.readProperties("conf/specids.properties");
        Class.forName(jdbcDriver);
        this.context = new ClassPathXmlApplicationContext(new String[]{"com/ericsson/metadata/search/utils/sync_context.xml"});
        this.idDAO = (IdDAO)this.context.getBean(IdDAO.class);
        Properties properties = new Properties();
        String installFolder = "/opt/tandbergtv/cms/plugins";
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, installFolder);
        JPFActivator activator = new JPFActivator();
        activator.start(properties);
        SlimSpecBuilder builder = new SlimSpecBuilder(activator.getPluginManager(), this.context);
        builder.buildSpecifications();
        Map specHandlerMap = SpecHandlerFactory.getHandlers();
        logger.info((Object)"Found the following Metadata Specifications:");
        for (ISpecHandler handler : specHandlerMap.values()) {
            logger.info((Object)("---- " + handler.getSpecName()));
        }
        this.uniqueSpecHandlers = ValidatorHelper.getInstance().getSpecificationHandlersForValidation();
        logger.info((Object)"Metadata Specification keys:");
        for (ISpecHandler handler : this.uniqueSpecHandlers) {
            logger.info((Object)("---- " + handler.getSpecName()));
        }
        this.executor = Executors.newFixedThreadPool(numThreads);
        logger.info((Object)("Batch Size=" + batchSize + " # of Threads=" + numThreads));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchAndAssignTask() {
        String sql = "select t.mdmdocid,t.id_ from pmm_title t, mdm_metadata m where m.document_id=t.mdmdocid and t.titlestatusid<>5 and t.originaltitle_id is null order by mdmdocid asc";
        Connection conn = this.getConnection();
        try (PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rset = stmt.executeQuery();){
            ArrayList<Long> docIds = new ArrayList<Long>();
            ArrayList<Long> titleIds = new ArrayList<Long>();
            int count = 0;
            while (rset.next()) {
                Long docId = rset.getLong(1);
                Long titleId = rset.getLong(2);
                if (docId != null) {
                    docIds.add(docId);
                    titleIds.add(titleId);
                    ++count;
                }
                if (count < batchSize) continue;
                this.submit(docIds, titleIds);
                count = 0;
                docIds = new ArrayList();
                titleIds = new ArrayList();
            }
            if (!docIds.isEmpty()) {
                this.submit(docIds, titleIds);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void submit(List<Long> docIds, List<Long> titleIds) {
        ++this.batchNum;
        IdSyncTask hardWorker = new IdSyncTask(this, this.batchNum, docIds, titleIds);
        Future<Integer> submit = this.executor.submit(hardWorker);
        this.resultList.add(submit);
    }

    private void retrieveResults() {
        int total = 0;
        for (Future<Integer> future : this.resultList) {
            try {
                total += future.get().intValue();
            }
            catch (InterruptedException e) {
                logger.error((Object)("Cannot get result from future " + future.toString()), (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.info((Object)("# Batches processed = " + this.batchNum));
        logger.info((Object)("Total # titles processed = " + total));
        this.executor.shutdown();
    }

    private void loadByBatches() {
        this.batchNum = 0;
        long start = System.currentTimeMillis();
        this.batchAndAssignTask();
        this.retrieveResults();
        logger.info((Object)("Time taken to load asset identifiers from titles = " + (System.currentTimeMillis() - start) / 1000L + " seconds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForMatch() {
        Collection<List<String>> curIndexedXpaths;
        boolean isMatch = true;
        Set xpaths = AssetKeyManager.getInstance().getAllSpecIdXpaths();
        logger.info((Object)("All Spec ID xpaths=" + xpaths.toString()));
        Connection conn = this.getConnection();
        try {
            PgIndexInfo indexInfo = new PgIndexInfo(conn);
            curIndexedXpaths = indexInfo.getIndexedFields();
        }
        finally {
            this.closeConnection(conn);
        }
        if (curIndexedXpaths == null || curIndexedXpaths.isEmpty()) {
            logger.info((Object)"There is NO unique index at all. Start working...");
            return false;
        }
        for (ISpecHandler spec : this.uniqueSpecHandlers) {
            Collection<String> ttvPaths = spec.getIdentifier().getTTVPaths().values();
            if (this.isUniqueIndexSyncWithPlugins(ttvPaths, curIndexedXpaths)) continue;
            logger.info((Object)String.format("Metadata Specification : %s don't have matched unique index. The ttvpaths are : %s", spec.getSpecDisplayName(), ttvPaths.toString()));
            logger.info((Object)"Start working...");
            isMatch = false;
            break;
        }
        return isMatch;
    }

    private boolean isUniqueIndexSyncWithPlugins(Collection<String> ttvPath, Collection<List<String>> uniqueIndexs) {
        boolean result = false;
        for (List<String> indexes : uniqueIndexs) {
            if (!indexes.containsAll(ttvPath) || !ttvPath.containsAll(indexes)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resync() {
        logger.info((Object)("forceOption=" + forceOption));
        long start = System.currentTimeMillis();
        boolean matched = this.checkForMatch();
        if (matched && !forceOption) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            PgIndexInfo indexInfo = new PgIndexInfo(conn);
            indexInfo.prepareAssetKeyTable();
            this.closeConnection(conn);
            this.loadByBatches();
            conn = this.getConnection();
            Transaction tx = this.getSessionFactory().getCurrentSession().beginTransaction();
            logger.info((Object)"Creating indexes....");
            for (ISpecHandler specHandler : this.uniqueSpecHandlers) {
                Collection ttvPaths = specHandler.getIdentifier().getTTVPaths().values();
                this.idDAO.createUniqueIndex(specHandler.getSpecName(), ttvPaths);
            }
            tx.commit();
            logger.info((Object)"Spec ID sync operation completed.");
            logger.info((Object)("Total time taken = " + (System.currentTimeMillis() - start) / 1000L + " seconds"));
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private SessionFactory getSessionFactory() {
        return (SessionFactory)this.context.getBean("sessionFactory");
    }

    private static void readProperties(String propertyFile) {
        Properties prop = new Properties();
        try {
            String numThreadsProperty;
            File f = new File(propertyFile);
            if (!f.exists()) {
                propertyFile = "conf/" + propertyFile;
            }
            FileInputStream fis = new FileInputStream(propertyFile);
            prop.load(fis);
            jdbcDriver = prop.getProperty("jdbc.driverClassName");
            if (url == null) {
                url = prop.getProperty("jdbc.connectionUrl");
            }
            user = prop.getProperty("jdbc.username");
            pwd = prop.getProperty("jdbc.password");
            String batchSizeProperty = prop.getProperty("syncspecids_batchSize");
            if (batchSizeProperty != null) {
                batchSize = Integer.parseInt(batchSizeProperty);
            }
            if ((numThreadsProperty = prop.getProperty("syncspecids_numThreads")) != null) {
                numThreads = Integer.parseInt(numThreadsProperty);
            }
            logger.info((Object)("jdbcDriver=" + jdbcDriver));
            logger.info((Object)("url=" + url));
            logger.info((Object)("user=" + user));
            logger.info((Object)("batchSize=" + batchSize));
            logger.info((Object)("numThreads=" + numThreads));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException("Error reading property file");
        }
    }

    private static boolean checkForForceOption(String arg) {
        if ("-force".equalsIgnoreCase(arg)) {
            forceOption = true;
        }
        return forceOption;
    }

    private static void setUrl(String dbServer) {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:postgresql://");
        sb.append(dbServer);
        sb.append(":5432/ttv");
        url = sb.toString();
    }

    private static void parseCmdLineOptions(String[] args) {
        if (args.length > 1) {
            logger.info((Object)("options=" + args[0] + " " + args[1]));
            ResynchSpecIds.setUrl(args[0]);
            ResynchSpecIds.checkForForceOption(args[1]);
        } else if (args.length == 1) {
            logger.info((Object)("options=" + Arrays.toString(args)));
            if (!ResynchSpecIds.checkForForceOption(args[0])) {
                ResynchSpecIds.setUrl(args[0]);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Job started ....");
        if (args != null) {
            ResynchSpecIds.parseCmdLineOptions(args);
        }
        ResynchSpecIds loader = new ResynchSpecIds();
        loader.resync();
        System.out.println("Job completed.");
        System.exit(0);
    }

    static {
        url = null;
        forceOption = false;
        batchSize = 10;
        numThreads = 2;
    }
}

