/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.cms.search.ElasticSearchService;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.utils.title.ResyncElasticSearchTitlesUtil;
import com.ericsson.utils.title.SaveTitleIdsWork;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.DefaultTitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.Work;
import org.springframework.context.ApplicationContext;

public class PersistenceUtil {
    private static ITitlePersistenceService titlePersistenceService;

    private PersistenceUtil() {
    }

    private static void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    public static void closeContext() {
        PersistenceUtil.stopService(IElasticSearchService.class);
        PersistenceUtil.stopService(ITitleManager.class);
        PersistenceUtil.stopService(ITitlePersistenceService.class);
    }

    private static void stopService(Class claz) {
        try {
            Service service = (Service)ServiceRegistry.getDefault().lookup(claz);
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeContext(String[] configFiles) {
        ApplicationContextHelper helper = ApplicationContextHelper.getInstance((String[])configFiles);
        ApplicationContext context = helper.getContext();
        ITTVDataModelHandler assetDataModelHandler = (ITTVDataModelHandler)context.getBean("TTVSpecHandler");
        PersistenceUtil.addService((Service)new DefaultTitlePersistenceService(assetDataModelHandler));
        ElasticSearchService esService = new ElasticSearchService();
        esService.setCacheAssetsRequiringFiles(true);
        PersistenceUtil.addService((Service)esService);
        PersistenceUtil.addService((Service)new TitleManager());
        HibernateContext.getContext().initializeContext();
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        try {
            DataTypeMappingReader dt = DataTypeMappingReader.getInstance();
            ICustomFieldPersistenceService cfs = CustomFieldPersistenceService.getInstance((ApplicationContext)context);
            dt.refreshCustomFieldDataTypeMap(cfs.getAllGroups());
        }
        finally {
            trans.commit();
        }
    }

    public static void saveTitleIds(int numShards, int batchSize, Date fromDate, String specificTitleIds) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.getTransaction();
        try {
            trans = session.beginTransaction();
            session.doWork((Work)new SaveTitleIdsWork(numShards, batchSize, fromDate, specificTitleIds));
            trans.commit();
        }
        catch (TransactionException te) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Fail to commit saveTitleIds() transaction, going to rollack transaction. The commit exception:" + te.getMessage());
            trans.rollback();
        }
    }

    public static Title getTitleFromDB(long titleId) {
        try {
            return PersistenceUtil.getTitlePersistenceService().get((Serializable)Long.valueOf(titleId));
        }
        catch (TitlePersistenceException ex) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Skipping title " + titleId + ", error:" + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public static int saveTitleInElasticSearch(List<Title> titles) throws Exception {
        IElasticSearchService esService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        return esService.saveTitleInBulk(titles);
    }

    public static int removeTitleInElasticSearch(List<Title> titles) throws Exception {
        IElasticSearchService esService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        return esService.deleteTitleInBulk(titles);
    }

    private static ITitlePersistenceService getTitlePersistenceService() {
        if (titlePersistenceService == null) {
            titlePersistenceService = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        }
        return titlePersistenceService;
    }
}

