/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessUtil {
    private static final String BIN_SH = "/bin/sh";
    private static final Logger logger = Logger.getLogger(ProcessUtil.class);

    public static List<ProcInfo> getProcessList(String name) {
        ArrayList<ProcInfo> processes = new ArrayList<ProcInfo>();
        try {
            String line;
            String[] cmd = new String[]{BIN_SH, "-c", "ps -eo pid,cmd | grep " + name + " | grep -v grep"};
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                ProcInfo info = new ProcInfo();
                int idx = line.indexOf(" java");
                if (idx <= 0) {
                    logger.info((Object)("Could not extract process ID. " + line));
                    continue;
                }
                String strProcId = line.substring(0, idx).trim();
                info.procId = Integer.parseInt(strProcId);
                idx = line.lastIndexOf(32);
                info.idFileName = line.substring(idx + 1).trim();
                processes.add(info);
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Collections.sort(processes);
        return processes;
    }

    public static void printProcessList(List<ProcInfo> list) {
        logger.info((Object)"===========================================");
        logger.info((Object)"     PID          File Name");
        logger.info((Object)"===========================================");
        for (ProcInfo info : list) {
            logger.info((Object)String.format("%9d     %s\n", info.procId, info.idFileName));
        }
        logger.info((Object)"===========================================");
    }

    public static boolean kill(int procId) {
        Process p;
        try {
            String[] cmd = new String[]{BIN_SH, "-c", "kill " + procId};
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return true;
        }
        try (BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
            String line;
            while ((line = err.readLine()) != null) {
                logger.error((Object)line);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return true;
    }

    public static int getProcessId(Process process) {
        if (ProcessUtil.isLinux()) {
            try {
                Class<?> clazz = Class.forName("java.lang.UNIXProcess");
                Field field = clazz.getDeclaredField("pid");
                field.setAccessible(true);
                return (Integer)field.get(process);
            }
            catch (Exception e) {
                throw new UnknownError("get ProcessId failed " + e.getMessage());
            }
        }
        throw new UnsupportedOperationException("Not support get pid in current OS yet");
    }

    public static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Linux");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProcessRunning(Integer pid) {
        Process p;
        if (pid == null) {
            return false;
        }
        try {
            String[] cmd = new String[]{BIN_SH, "-c", "ps --no-heading " + pid + " | wc -l"};
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!"1".equals(line.trim()));
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return false;
    }

    public static class ProcInfo
    implements Comparable<ProcInfo> {
        public int procId;
        public String idFileName;

        @Override
        public int compareTo(ProcInfo o) {
            return this.procId - o.procId;
        }
    }
}

