/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.utils.title.ResyncElasticSearchTitlesUtil;
import com.ericsson.utils.title.ResyncManagerMain;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;

public class PropertiesUtil {
    static final SimpleDateFormat colonDF = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss");
    static final SimpleDateFormat spaceDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final Logger logger = Logger.getLogger(PropertiesUtil.class);
    private static final String LAST_SUCCESS_FULL_RUN_DEF = "2000-01-01:00:00:00";
    private static final String LAST_DB_REPLICATION_DEF = "2000-01-01:00:00:00";
    private static final int PARALLEL_BATCH_DEF = 10;
    private static final int BATCH_SIZE_DEF = 1000;
    private static final int NUM_TO_ABORT_DEF = 2;
    private static final int STATUS_CHECK_INITIAL_DELAY_DEF = 6;
    private static final int TIMEOUT_MINS_DEF = 5;
    private static final int QUERY_SECS_DEF = 20;
    public static final String ES_INDEX_DOC_ID = "1";
    public static final String ES_SYNC_INDEX = "lastsyncindex";
    public static final String ES_TYPE = "_doc";
    public static final String START_SYNC_DATE = "startSyncDate";
    public static final String END_SYNC_DATE = "endSyncDate";
    public static final String KEY_LAST_SUCCESSFUL_RUN = "lastSuccessfulRun";
    public static final String KEY_LAST_DB_REPLICATION = "lastDBReplication";
    public static final String KEY_CURRENT_RUNTIME = "currentRuntime";
    public static final String KEY_CURRENT_HOST = "currentHost";
    public static final String KEY_WORKFLOW_RUNTIME = "workflowRuntime";
    public static final String KEY_IS_CLEANING = "isCleaning";
    public static final String KEY_TITLE_SYNC_PID = "titleSyncPid";
    public static final String KEY_WORKFLOW_SYNC_PID = "workflowSyncPid";
    private static final String KEY_PARALLEL_BATCH = "parallelBatches";
    private static final String KEY_BATCH_SIZE = "batchSize";
    private static final String KEY_NUM_TO_ABORT = "numberToAbort";
    private static final String KEY_STATUS_CHECK_INITIAL_DELAY = "statusCheckInitialDelay";
    private static final String KEY_TIMEOUT_MINS = "timeoutMinutes";
    private static final String KEY_QUERY_SECS = "querySeconds";
    public static final String TIMESTAMP_PROPERTIES = "/opt/tandbergtv/cms/scripts/sync_utils/conf/timestamp.properties";
    private static Properties props;
    private static final String WARN_USE_DEFAULT_WHEN_NOT_SET = "WARN: %s is not set in sync.properties, will use default value %s";
    private static final String WARN_USE_DEFAULT_WHEN_PARSE_FAILED = "WARN: Failed to parse %s=%s in sync.properties, will use default %s=%s";
    private static final String WARN_USE_DEFAULT_WHEN_INVALID = "WARN: Invalid %s=%s in sync.properties, will use default %s=%s";
    private static final String WARN_USE_MAX_WHEN_EXCEED_MAX = "WARN: %s=%s in sync.properties exceeds the maximum value, will use maximum %s=%s";
    private static final String MSG_KEY_VALUE = "%s: %s";

    private PropertiesUtil() {
    }

    public static Properties getSyncProperties() {
        if (props != null) {
            return props;
        }
        props = new Properties();
        try (InputStream is = ResyncManagerMain.class.getClassLoader().getResourceAsStream("sync.properties");){
            if (is == null) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Could not load 'sync.properties' from classpath.");
            } else {
                props.load(is);
            }
        }
        catch (Exception ex) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Could not load 'sync.properties' from classpath. " + ex.getMessage());
        }
        return props;
    }

    public static boolean isCurrentHost() {
        String hostname;
        Properties timeProps;
        try {
            timeProps = PropertiesUtil.readTimeProperties();
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return true;
        }
        String currentHost = timeProps.getProperty(KEY_CURRENT_HOST);
        return currentHost == null || currentHost.equals(hostname);
    }

    public static boolean isCleaning() {
        Properties timeProps;
        try {
            timeProps = PropertiesUtil.readTimeProperties();
        }
        catch (Exception e) {
            return false;
        }
        String isCleaning = timeProps.getProperty(KEY_IS_CLEANING);
        return StringUtils.isNotEmpty((String)isCleaning);
    }

    public static Properties readTimeProperties() throws Exception {
        Properties props;
        try (InputStream is = ResyncManagerMain.class.getClassLoader().getResourceAsStream("timestamp.properties");){
            props = new Properties();
            if (is == null) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Could not load 'timestamp.properties' from classpath. Will create a new timestamp.properties ");
                props.setProperty(KEY_LAST_SUCCESSFUL_RUN, "2000-01-01:00:00:00");
                props.setProperty(KEY_LAST_DB_REPLICATION, "2000-01-01:00:00:00");
                PropertiesUtil.saveTimeProperties(props);
            } else {
                props.load(is);
            }
        }
        catch (Exception ex) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Could not load 'timestamp.properties' from classpath. " + ex.getMessage());
            throw ex;
        }
        return props;
    }

    public static void updateTimeProperties(TransportClient client) throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        String newRep = props.getProperty(START_SYNC_DATE);
        String currentRun = props.getProperty(KEY_CURRENT_RUNTIME);
        if (newRep != null) {
            props.setProperty(KEY_LAST_SUCCESSFUL_RUN, newRep);
            props.setProperty(KEY_LAST_DB_REPLICATION, newRep);
            try {
                HashMap<String, Object> value = new HashMap<String, Object>(2);
                value.put(END_SYNC_DATE, spaceDF.format(new Date()));
                value.put("status", "Successful");
                PropertiesUtil.publishReplicationTimeToEs(client, value);
            }
            catch (Exception e) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("ERROR: Failed to publish endSyncDate to ES: " + e.getMessage());
                return;
            }
        } else if (currentRun != null) {
            props.setProperty(KEY_LAST_SUCCESSFUL_RUN, currentRun);
        }
        props.remove(KEY_CURRENT_HOST);
        props.remove(KEY_CURRENT_RUNTIME);
        props.remove(START_SYNC_DATE);
        props.remove(KEY_WORKFLOW_RUNTIME);
        props.remove(KEY_TITLE_SYNC_PID);
        props.remove(KEY_WORKFLOW_SYNC_PID);
        PropertiesUtil.saveTimeProperties(props);
    }

    public static void updateTimeProperties(String key, Object value) throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        props.put(key, value.toString());
        PropertiesUtil.saveTimeProperties(props);
    }

    public static void removeKeyInTimeProperties(String key) throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        props.remove(key);
        PropertiesUtil.saveTimeProperties(props);
    }

    public static String getStringFromTimeProperties(String key) {
        try {
            Properties props = PropertiesUtil.readTimeProperties();
            return props.getProperty(key);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static Integer getIntFromTimeProperties(String key) {
        String value = PropertiesUtil.getStringFromTimeProperties(key);
        if (!StringUtils.isNumeric((String)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public static void resetTimeProperties() throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        String lastRun = props.getProperty(KEY_LAST_SUCCESSFUL_RUN);
        String lastRep = props.getProperty(KEY_LAST_DB_REPLICATION);
        props = new Properties();
        if (lastRun == null) {
            props.setProperty(KEY_LAST_SUCCESSFUL_RUN, "2000-01-01:00:00:00");
        } else {
            props.setProperty(KEY_LAST_SUCCESSFUL_RUN, lastRun);
        }
        if (lastRep == null) {
            props.setProperty(KEY_LAST_DB_REPLICATION, "2000-01-01:00:00:00");
        } else {
            props.setProperty(KEY_LAST_DB_REPLICATION, lastRep);
        }
        PropertiesUtil.saveTimeProperties(props);
    }

    public static void saveTimeProperties(Properties props) throws Exception {
        File file = new File(TIMESTAMP_PROPERTIES);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Could not create /opt/tandbergtv/cms/scripts/sync_utils/conf/timestamp.properties");
                    return;
                }
            }
            catch (IOException e) {
                ResyncElasticSearchTitlesUtil.printConsoleLog(String.format("ERROR: create %s error: %s", TIMESTAMP_PROPERTIES, e.getMessage()));
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            props.store(writer, null);
        }
        catch (Exception ex) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("ERROR: Could not write to /opt/tandbergtv/cms/scripts/sync_utils/conf/timestamp.properties. " + ex.getMessage());
            throw ex;
        }
    }

    static void publishReplicationTimeToEs(TransportClient client, String field, String value) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(field, value);
        PropertiesUtil.publishReplicationTimeToEs(client, map);
    }

    static void publishReplicationTimeToEs(TransportClient client, Map<String, Object> map) throws Exception {
        ResyncElasticSearchTitlesUtil.printConsoleLog(String.format("Publishing %s to ES index: %s", map.toString(), ES_SYNC_INDEX));
        IndexRequest indexRequest = (IndexRequest)client.prepareIndex(ES_SYNC_INDEX, ES_TYPE, ES_INDEX_DOC_ID).setSource(map).request();
        UpdateResponse response = (UpdateResponse)client.prepareUpdate(ES_SYNC_INDEX, ES_TYPE, ES_INDEX_DOC_ID).setDoc(map).setUpsert(indexRequest).execute().actionGet();
        if (response == null || !response.getId().equals(ES_INDEX_DOC_ID)) {
            throw new Exception(String.format("Error: Could't write %s to ES index: %s", map.toString(), ES_SYNC_INDEX));
        }
    }

    public static int getBatchSize() {
        return PropertiesUtil.getCommonIntValueByKey(KEY_BATCH_SIZE, 1000, null);
    }

    public static int getNumberToAbort() {
        return PropertiesUtil.getCommonIntValueByKey(KEY_NUM_TO_ABORT, 2, null);
    }

    public static int getStatusCheckInitialDelay() {
        return PropertiesUtil.getCommonIntValueByKey(KEY_STATUS_CHECK_INITIAL_DELAY, 6, null);
    }

    public static int getTimeoutMinutes() {
        return PropertiesUtil.getCommonIntValueByKey(KEY_TIMEOUT_MINS, 5, null);
    }

    public static int getQuerySeconds() {
        return PropertiesUtil.getCommonIntValueByKey(KEY_QUERY_SECS, 20, null);
    }

    public static int getParallelBatches() {
        return PropertiesUtil.getCommonIntValueByKey(KEY_PARALLEL_BATCH, 10, 100);
    }

    public static Date getModifiedSinceDate(String modifiedSince) throws Exception {
        Date date = null;
        String modifiedSinceDateStr = modifiedSince;
        if (StringUtils.isEmpty((String)modifiedSinceDateStr)) {
            modifiedSinceDateStr = PropertiesUtil.getSyncProperties().getProperty("modifiedSince");
        }
        if (!StringUtils.isEmpty((String)modifiedSinceDateStr)) {
            date = PropertiesUtil.parseDate(colonDF, modifiedSinceDateStr);
            if (date == null) {
                date = PropertiesUtil.parseDate(spaceDF, modifiedSinceDateStr);
            }
            if (date == null) {
                throw new Exception("Invalid date format: " + modifiedSinceDateStr);
            }
        }
        return date;
    }

    private static Date parseDate(SimpleDateFormat format, String strDate) {
        try {
            return format.parse(strDate);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static int getCommonIntValueByKey(String key, int defVal, Integer maxVal) {
        int value = defVal;
        String str = PropertiesUtil.getSyncProperties().getProperty(key);
        if (StringUtils.isBlank((String)str)) {
            ResyncElasticSearchTitlesUtil.printConsoleLog(String.format(WARN_USE_DEFAULT_WHEN_NOT_SET, key, defVal));
        } else {
            try {
                value = Integer.parseInt(str.trim());
            }
            catch (Exception ex) {
                ResyncElasticSearchTitlesUtil.printConsoleLog(String.format(WARN_USE_DEFAULT_WHEN_PARSE_FAILED, key, str, key, defVal));
            }
        }
        if (value < 1) {
            ResyncElasticSearchTitlesUtil.printConsoleLog(String.format(WARN_USE_DEFAULT_WHEN_INVALID, key, str, key, defVal));
            value = defVal;
        }
        if (maxVal != null && value > maxVal) {
            ResyncElasticSearchTitlesUtil.printConsoleLog(String.format(WARN_USE_MAX_WHEN_EXCEED_MAX, key, str, key, maxVal));
            value = maxVal;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog(String.format(MSG_KEY_VALUE, key, value));
        return value;
    }
}

