/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.utils.title.PersistenceUtil;
import com.ericsson.utils.title.ProcessUtil;
import com.ericsson.utils.title.PropertiesUtil;
import com.ericsson.utils.title.TimeMetrics;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.springframework.util.CollectionUtils;

public class ResyncElasticSearchTitlesUtil {
    private static final Logger logger = Logger.getLogger(ResyncElasticSearchTitlesUtil.class);
    private static final String[] SPRING_CONTEXT_CONFIG = new String[]{"com/tandbergtv/cms/search/utils/SyncHibernateContext.xml"};
    private int numToAbort;
    private String connectionUrl;
    private int batchSize;
    private int parallelBatches;

    public ResyncElasticSearchTitlesUtil(String databaseHost, String databasePort) {
        this.connectionUrl = "jdbc:postgresql://" + databaseHost + ":" + databasePort + "/ttv";
        this.init();
    }

    private void init() {
        try {
            if (this.connectionUrl != null) {
                System.setProperty("jdbc.connectionUrl", this.connectionUrl);
            }
            PersistenceUtil.initializeContext(SPRING_CONTEXT_CONFIG);
            this.numToAbort = PropertiesUtil.getNumberToAbort();
            this.batchSize = PropertiesUtil.getBatchSize();
            this.parallelBatches = PropertiesUtil.getParallelBatches();
        }
        catch (Exception e) {
            logger.error((Object)e);
            System.exit(-1);
        }
    }

    public void close() {
        PersistenceUtil.closeContext();
    }

    public void startTitlesResync(Date modifiedSinceDate, String titleIds, String titleIdsFilePath) throws Exception {
        List<Integer> workFiles;
        List<ProcessUtil.ProcInfo> list = ResyncElasticSearchTitlesUtil.getResyncElasticSearchTitlesMainProcess();
        if (!list.isEmpty()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync utility is running.");
            ProcessUtil.printProcessList(list);
            return;
        }
        if (!ResyncElasticSearchTitlesUtil.validateDatabase()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Invalid Database Properties.");
            return;
        }
        String specificTitleIds = this.getSpecificTitleIds(titleIds, titleIdsFilePath);
        if (StringUtils.isNotEmpty((String)specificTitleIds)) {
            ResyncElasticSearchTitlesUtil.cleanWorkFiles();
        }
        if ((workFiles = ResyncElasticSearchTitlesUtil.getWorkFiles()).isEmpty()) {
            this.generateTitleIdFiles(modifiedSinceDate, specificTitleIds);
        } else {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resuming resync...");
        }
        boolean result = this.startProcessTitleIds();
        if (result) {
            logger.info((Object)"Finished, titles sync is successful.");
            this.close();
            System.exit(0);
        } else {
            logger.info((Object)"Finished, titles sync is aborted.");
            this.close();
            System.exit(1);
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Done.");
    }

    private void generateTitleIdFiles(Date modifiedSinceDate, String specificTitleIds) {
        ResyncElasticSearchTitlesUtil.printConsoleLog("Generating title ID files...");
        if (modifiedSinceDate != null && StringUtils.isEmpty((String)specificTitleIds)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ResyncElasticSearchTitlesUtil.printConsoleLog("Will only sync titles created or modified since " + df.format(modifiedSinceDate));
        }
        this.saveTitleIds(this.parallelBatches, this.batchSize, modifiedSinceDate, specificTitleIds);
    }

    private void saveTitleIds(int numFiles, int batchSize, Date fromDate, String specificTitleIds) {
        logger.info((Object)("Saving title IDs for " + numFiles + " concurrent threads..."));
        long t1 = System.currentTimeMillis();
        PersistenceUtil.saveTitleIds(numFiles, batchSize, fromDate, specificTitleIds);
        long t2 = System.currentTimeMillis();
        logger.info((Object)("Done in " + (t2 - t1) + " ms."));
    }

    public boolean startProcessTitleIds() throws Exception {
        List<Integer> workFiles = ResyncElasticSearchTitlesUtil.getWorkFiles();
        if (CollectionUtils.isEmpty(workFiles)) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("No title need to be processed, end title sync process.");
            return true;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Starting " + this.parallelBatches + " threads to process title id...");
        ExecutorService executorService = Executors.newFixedThreadPool(workFiles.size());
        ArrayList<Callable<Boolean>> taskList = new ArrayList<Callable<Boolean>>();
        for (int i = 0; i < workFiles.size(); ++i) {
            String fileName = "work/titleIds-" + workFiles.get(i) + ".txt";
            String logFileName = "log/titleIds-" + workFiles.get(i) + ".log";
            taskList.add(() -> this.processTitleIds(fileName, logFileName));
        }
        List futures = executorService.invokeAll(taskList);
        for (Future future : futures) {
            if (((Boolean)future.get()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean processTitleIds(String fileName, String logFileName) throws Exception {
        PrintWriter logFileWriter = this.getLogPrintWriter(logFileName);
        TimeMetrics tm = new TimeMetrics();
        int numFailedTitles = 0;
        String statusFileName = fileName + ".stat";
        RandomAccessFile statusFile = new RandomAccessFile(statusFileName, "rw");
        String failedTitlesFileName = fileName + ".failed";
        File failedTitlesFile = new File(failedTitlesFileName);
        ArrayList<String> prevFailedTitleIds = new ArrayList();
        if (failedTitlesFile.exists()) {
            prevFailedTitleIds = this.getPreviousFailedTitleIds(failedTitlesFileName);
            failedTitlesFile.delete();
        }
        FileWriter failedTitleFileWriter = new FileWriter(failedTitlesFile);
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        if (!CollectionUtils.isEmpty(prevFailedTitleIds) && !this.recoverFailedTitleIds(fileName, reader, failedTitleFileWriter, prevFailedTitleIds, tm, logFileWriter, numFailedTitles, statusFile)) {
            return false;
        }
        if (!this.syncTitleIds(reader, failedTitleFileWriter, tm, logFileWriter, numFailedTitles, statusFile)) {
            return false;
        }
        reader.close();
        statusFile.seek(0L);
        statusFile.writeUTF("FINISH");
        failedTitleFileWriter.close();
        statusFile.close();
        return true;
    }

    private boolean syncTitleIds(BufferedReader reader, FileWriter failedTitleFileWriter, TimeMetrics tm, PrintWriter logFileWriter, int numFailedTitles, RandomAccessFile statusFile) throws Exception {
        long t1 = System.currentTimeMillis();
        ArrayList<Long> titleIdList = new ArrayList<Long>();
        String line = reader.readLine();
        long lineCount = 0L;
        while (line != null) {
            if ((line = line.trim()).length() < 1) continue;
            ++lineCount;
            titleIdList.add(Long.parseLong(line));
            line = reader.readLine();
            if (titleIdList.size() < this.batchSize && line != null) continue;
            if (!this.batchProcessTitleId(titleIdList, reader, failedTitleFileWriter, tm, logFileWriter, numFailedTitles, statusFile)) {
                return false;
            }
            this.printProgress(lineCount, t1, tm, logFileWriter);
        }
        return true;
    }

    private boolean recoverFailedTitleIds(String fileName, BufferedReader reader, FileWriter failedTitleFileWriter, List<String> prevFailedTitleIds, TimeMetrics tm, PrintWriter logFileWriter, int numFailedTitles, RandomAccessFile statusFile) throws Exception {
        if (statusFile.length() == 0L) {
            return true;
        }
        logFileWriter.println("Trying to recover...");
        statusFile.seek(0L);
        String lastProcessedId = statusFile.readUTF();
        if (lastProcessedId.contains("FINISH")) {
            logFileWriter.println(fileName + " already finished.");
            reader.close();
            failedTitleFileWriter.close();
            return true;
        }
        logFileWriter.println("Last processed title id = " + lastProcessedId);
        long lineCount = 0L;
        ArrayList<Long> titleIdList = new ArrayList<Long>();
        String line = reader.readLine();
        while (line != null) {
            ++lineCount;
            boolean isLastProcessedId = lastProcessedId.equals(line);
            if (prevFailedTitleIds.contains(line)) {
                titleIdList.add(Long.parseLong(line));
            }
            line = reader.readLine();
            if ((titleIdList.size() >= this.batchSize || isLastProcessedId || line == null) && !this.batchProcessTitleId(titleIdList, reader, failedTitleFileWriter, tm, logFileWriter, numFailedTitles, statusFile)) {
                return false;
            }
            if (!isLastProcessedId) continue;
            logFileWriter.println("Skipped " + lineCount + " title IDs.");
            break;
        }
        return true;
    }

    private boolean batchProcessTitleId(List<Long> titleIdList, BufferedReader reader, FileWriter failedTitleFileWriter, TimeMetrics tm, PrintWriter logFileWriter, int numFailedTitles, RandomAccessFile statusFile) throws Exception {
        logFileWriter.println("Processing titleIds = " + titleIdList);
        if (!this.batchSaveOrDeleteTitles(titleIdList, tm, failedTitleFileWriter, logFileWriter, numFailedTitles, statusFile)) {
            reader.close();
            failedTitleFileWriter.close();
            logFileWriter.close();
            statusFile.close();
            return false;
        }
        titleIdList.clear();
        return true;
    }

    private boolean batchSaveOrDeleteTitles(List<Long> titleIdList, TimeMetrics tm, FileWriter failedTitleFileWriter, PrintWriter logFileWriter, int numFailedTitles, RandomAccessFile statusFile) throws Exception {
        boolean titleProcessed = true;
        ArrayList<Long> addTitleIdList = new ArrayList<Long>();
        ArrayList<Long> deleteTitleIdList = new ArrayList<Long>();
        titleIdList.stream().forEach(titleId -> {
            if (titleId > 0L) {
                addTitleIdList.add((Long)titleId);
            }
            if (titleId < 0L) {
                deleteTitleIdList.add(Math.abs(titleId));
            }
        });
        try {
            if (!CollectionUtils.isEmpty(addTitleIdList)) {
                numFailedTitles += this.addTitle(addTitleIdList, tm, statusFile);
            }
            if (!CollectionUtils.isEmpty(deleteTitleIdList)) {
                numFailedTitles += this.deleteTitle(deleteTitleIdList, tm, statusFile);
            }
            if (numFailedTitles > this.numToAbort) {
                logger.info((Object)("Aborting - too many failures, failed title count: " + numFailedTitles));
                titleProcessed = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            titleProcessed = false;
        }
        if (!titleProcessed) {
            logFileWriter.println("Could not save titles " + titleIdList);
            failedTitleFileWriter.write(StringUtils.join(titleIdList, (String)"\n") + "\n");
        }
        return titleProcessed;
    }

    private int addTitle(List<Long> titleIdList, TimeMetrics tm, RandomAccessFile statusFile) throws Exception {
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.getTransaction();
        int failedTitleCount = 0;
        try {
            trans = session.beginTransaction();
            long t1 = System.currentTimeMillis();
            List<Title> titleList = this.getTitleList(titleIdList);
            long t2 = System.currentTimeMillis();
            long dbTime = t2 - t1;
            failedTitleCount = PersistenceUtil.saveTitleInElasticSearch(titleList);
            long t3 = System.currentTimeMillis();
            long esTime = t3 - t2;
            tm.count += titleIdList.size();
            tm.db += dbTime;
            tm.es += esTime;
            statusFile.seek(0L);
            statusFile.writeUTF(String.valueOf(titleIdList.get(titleIdList.size() - 1)));
            trans.commit();
        }
        catch (TransactionException te) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Fail to commit addTitle() transaction, going to rollack transaction. The commit exception:" + te.getMessage());
            trans.rollback();
        }
        return failedTitleCount;
    }

    private int deleteTitle(List<Long> titleIdList, TimeMetrics tm, RandomAccessFile statusFile) throws Exception {
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.getTransaction();
        int failedTitleCount = 0;
        try {
            trans = session.beginTransaction();
            long t1 = System.currentTimeMillis();
            List<Title> titleList = this.getTitleList(titleIdList);
            long t2 = System.currentTimeMillis();
            long dbTime = t2 - t1;
            failedTitleCount = PersistenceUtil.removeTitleInElasticSearch(titleList);
            long t3 = System.currentTimeMillis();
            long esTime = t3 - t2;
            tm.count += titleIdList.size();
            tm.db += dbTime;
            tm.es += esTime;
            String strTitleId = "-" + titleIdList.get(titleIdList.size() - 1);
            statusFile.seek(0L);
            statusFile.writeUTF(strTitleId);
            trans.commit();
        }
        catch (TransactionException te) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Fail to commit deleteTitle() transaction, going to rollack transaction. The commit exception:" + te.getMessage());
            trans.rollback();
        }
        return failedTitleCount;
    }

    private List<Title> getTitleList(List<Long> titleIdList) {
        ArrayList<Title> titleList = new ArrayList<Title>();
        for (Long titleId : titleIdList) {
            Title title = PersistenceUtil.getTitleFromDB(titleId);
            if (title == null) continue;
            titleList.add(title);
        }
        return titleList;
    }

    private List<String> getPreviousFailedTitleIds(String fileName) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        ArrayList<String> prevFailedtitleIds = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            prevFailedtitleIds.add(line);
        }
        reader.close();
        return prevFailedtitleIds;
    }

    private void printProgress(long count, long t1, TimeMetrics tm, PrintWriter out) {
        long t2 = System.currentTimeMillis();
        long timeSec = (t2 - t1) / 1000L;
        int min = (int)(timeSec / 60L);
        int sec = (int)(timeSec - (long)(min * 60));
        if (tm.count != 0) {
            out.println("Count = " + count + ", time = " + min + " min " + sec + " sec, DB = " + tm.db / (long)tm.count + " ms, ES = " + tm.es / (long)tm.count + " ms");
        }
        tm.clear();
    }

    private PrintWriter getLogPrintWriter(String fileName) throws IOException {
        FileWriter fw = new FileWriter(fileName, true);
        BufferedWriter bw = new BufferedWriter(fw);
        return new PrintWriter((Writer)bw, true);
    }

    public static List<Integer> getWorkFiles() {
        File[] allFiles;
        ArrayList<Integer> workFiles = new ArrayList<Integer>();
        File dir = new File("work");
        if (!dir.exists() && !dir.mkdir()) {
            logger.error((Object)"Error: Cannot make directory \"work\"");
            return workFiles;
        }
        if (!dir.isDirectory()) {
            logger.error((Object)"Error: \"work\" is not a directory");
            return workFiles;
        }
        for (File f : allFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("titleIds-");
            }
        })) {
            String name = f.getName();
            Integer workFile = Integer.parseInt(name.substring(name.indexOf(45) + 1, name.indexOf(46)));
            if (workFiles.contains(workFile)) continue;
            workFiles.add(workFile);
        }
        return workFiles;
    }

    public static void cleanWorkFiles() {
        List<ProcessUtil.ProcInfo> list = ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
        if (!list.isEmpty()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Could not clean. Resync utility is running.");
            ProcessUtil.printProcessList(list);
            return;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Cleaning...");
        List<Integer> workFiles = ResyncElasticSearchTitlesUtil.getWorkFiles();
        for (int i = 1; i <= workFiles.size(); ++i) {
            ResyncElasticSearchTitlesUtil.deleteFile("work/titleIds-" + i + ".txt");
            ResyncElasticSearchTitlesUtil.deleteFile("work/titleIds-" + i + ".txt.stat");
            ResyncElasticSearchTitlesUtil.deleteFile("work/titleIds-" + i + ".txt.failed");
            ResyncElasticSearchTitlesUtil.deleteFile("log/titleIds-" + i + ".log");
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Done.");
    }

    public static boolean validateDatabase() {
        Properties syncProps = PropertiesUtil.getSyncProperties();
        if (syncProps == null) {
            return false;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Database Properties:");
        if (!ResyncElasticSearchTitlesUtil.validateProperty(syncProps, "jdbc.driverClassName", "JDBC Driver", "sync.properties")) {
            return false;
        }
        return ResyncElasticSearchTitlesUtil.validateProperty(syncProps, "jdbc.username", "DB user name", "sync.properties");
    }

    public static boolean validateProperty(Properties props, String name, String label, String propFileName) {
        return ResyncElasticSearchTitlesUtil.validateProperty(props, name, label, propFileName, true);
    }

    public static boolean validateProperty(Properties props, String name, String label, String propFileName, boolean required) {
        String str = props.getProperty(name);
        if (str == null || str.trim().isEmpty()) {
            String msg = label + " is not set ('" + name + "' property in '" + propFileName + "' file).";
            if (required) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("ERROR: " + msg);
                return false;
            }
            ResyncElasticSearchTitlesUtil.printConsoleLog("WARN: " + msg + " Will use default value.");
            return true;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog(label + ": " + str.replaceFirst(":", " "));
        return true;
    }

    public static void printConsoleLog(String log) {
        System.out.println(log);
        logger.info((Object)log);
    }

    public static List<ProcessUtil.ProcInfo> getResyncElasticSearchTitlesMainProcess() {
        return ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
    }

    private static void deleteFile(String name) {
        File file = new File(name);
        file.delete();
    }

    private String getSpecificTitleIds(String titleIds, String titleIdsFilePath) {
        String specificTitleIdStr;
        StringBuilder specificTitleIdBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((String)titleIds)) {
            specificTitleIdBuilder.append(titleIds.trim());
        }
        if (StringUtils.isNotEmpty((String)titleIdsFilePath)) {
            try (BufferedReader reader = new BufferedReader(new FileReader(titleIdsFilePath));){
                String line;
                while ((line = reader.readLine()) != null) {
                    specificTitleIdBuilder.append(",").append(line.trim());
                }
            }
            catch (Exception e) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Failed to read title ids from specific file path: " + titleIdsFilePath);
            }
        }
        if (StringUtils.isNotEmpty((String)(specificTitleIdStr = specificTitleIdBuilder.toString())) && specificTitleIdStr.startsWith(",")) {
            specificTitleIdStr = specificTitleIdStr.substring(1, specificTitleIdStr.length());
        }
        return specificTitleIdStr;
    }
}

