/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.neptune.es.CmsTransportClient;
import com.ericsson.utils.title.ProcessUtil;
import com.ericsson.utils.title.PropertiesUtil;
import com.ericsson.utils.title.ResyncElasticSearchTitlesUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.transport.TransportClient;

public class ResyncManagerMain {
    private static final String TITLE_IDS = "titleIds-";
    public static final String WORKFLOW_BOOKMARK_TXT = "/opt/tandbergtv/cms/scripts/sync_utils/work/workflowBookmark.txt";
    public static final String STATUS = "status";
    public static final String STATUS_FAILED = "Failed";
    public static final String STATUS_SUCCESSFUL = "Successful";
    public static final String ELASTIC_SEARCH_PROPERTIES = "/opt/tandbergtv/cms/conf/contentMgmt/ElasticSearch.properties";
    private static CommandLine cl;
    private static String database;
    private static String databasePort;
    private static CmsTransportClient esClient;
    private static boolean isGeoRedundantSite;

    public static void main(String[] args) throws Exception {
        ResyncElasticSearchTitlesUtil.printConsoleLog("Running ResyncManagerMain ");
        for (String arg : args) {
            ResyncElasticSearchTitlesUtil.printConsoleLog(" <" + arg + ">");
        }
        BasicParser parser = new BasicParser();
        try {
            cl = parser.parse(ResyncManagerMain.getOptions(), args);
        }
        catch (ParseException e) {
            ResyncManagerMain.printUsageAndExit();
        }
        if (args.length == 0 || cl.hasOption("h")) {
            ResyncManagerMain.printUsageAndExit();
        }
        ResyncManagerMain.checkOS();
        ResyncManagerMain.checkParameter(cl);
        String cmd = args[0];
        if (STATUS.equalsIgnoreCase(cmd)) {
            ResyncManagerMain.doStatus();
        } else if ("stop".equalsIgnoreCase(cmd)) {
            ResyncManagerMain.doStop();
        } else if ("start".equalsIgnoreCase(cmd)) {
            ResyncManagerMain.doStart();
        } else if ("clean".equalsIgnoreCase(cmd)) {
            ResyncManagerMain.doClean();
        } else {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Invalid command: " + cmd);
            ResyncManagerMain.printUsageAndExit();
        }
        if (esClient != null) {
            esClient.close();
        }
        System.exit(0);
    }

    private static void checkParameter(CommandLine commandLine) {
        if ((commandLine.hasOption("w") || commandLine.hasOption("a")) && !commandLine.hasOption("db")) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("db is required when sync workflow");
            ResyncManagerMain.printUsageAndExit();
        }
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("a", "all", false, "Resyncs all titles and all work orders.");
        options.addOption("s", "starttime", true, "All entries that were updated later than starttime are selected for synchronization. Expected format is yyyy-MM-dd HH:mm:ss.");
        options.addOption("t", "titles", false, "Sync titles only.");
        options.addOption("w", "workflow", false, "Sync workflow only.");
        options.addOption("c", "concurrency", true, "Sets the number of parallel threads or writing to ElasticSearch. Defaults to 5.");
        options.addOption("q", "queuelimit", true, "Sets the internal queue size and intern the SQL query batch size. Defaults to 100.");
        options.addOption("p", "variableprocesslimit", true, "Max number of processids to use in variable isntance query, defaults to 50");
        options.addOption("v", "variableconcurrency", true, "Sets the number of parallel connections to DB while gathering VARIABLE INSTANCE information. Defaults to 20.");
        options.addOption("g", "geo", false, "Only use when running on georedundant site. Keeps ElasticSearch in sync with last database streaming.");
        options.addOption("db", "database", true, "Explicitly specify database.");
        options.addOption("dp", "databaseport", true, "Explicitly specify database port. Default value is 5432");
        options.addOption("h", "help", false, "Show help.");
        return options;
    }

    private static synchronized TransportClient getTransportClient() {
        if (esClient == null) {
            esClient = new CmsTransportClient(ELASTIC_SEARCH_PROPERTIES);
        }
        return esClient.getTransportClient();
    }

    private static void doStatus() throws Exception {
        ResyncStatus status = ResyncManagerMain.checkResyncStatus();
        if (status == null) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync status is null, Something went wrong.");
            return;
        }
        switch (status) {
            case NOT_CURRENT_HOST: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is probably running on the other host.");
                break;
            }
            case STOPPED: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is stopped. Please run START to resume.");
                break;
            }
            case RUNNING: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is running.");
                ResyncManagerMain.printProcessesList();
                break;
            }
            case DONE: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync has completed successfully! Please run CLEAN.");
                break;
            }
            case READY: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is ready to run.");
                break;
            }
            case CLEANING: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is cleaning.");
                break;
            }
            default: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync Status Error!");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void doStart() throws Exception {
        concurrency = -1;
        queueLimit = -1;
        variableProcessLimit = -1;
        variableConcurrency = -1;
        hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (ResyncManagerMain.cl.hasOption("db")) {
            db = ResyncManagerMain.cl.getOptionValue("db");
            if (!"dbserver".equals(db) && !db.startsWith("db")) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Invalid database! Must be \"dbserver\" or \"db#\": \"" + db + "\"");
                return;
            }
            ResyncManagerMain.database = db;
        }
        if (ResyncManagerMain.cl.hasOption("dp")) {
            ResyncManagerMain.databasePort = ResyncManagerMain.cl.getOptionValue("dp");
        }
        if (ResyncManagerMain.cl.hasOption("g")) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("GEOREDUNDANCY = TRUE");
            ResyncManagerMain.isGeoRedundantSite = true;
        }
        if ((status = ResyncManagerMain.checkResyncStatus()) == ResyncStatus.ERROR) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync status is ERROR, Something went wrong.");
            return;
        }
        i = 0;
        block16: while (true) lbl-1000:
        // 5 sources

        {
            switch (1.$SwitchMap$com$ericsson$utils$title$ResyncManagerMain$ResyncStatus[status.ordinal()]) {
                case 4: {
                    if (!ResyncManagerMain.isGeoRedundantSite) ** GOTO lbl48
                    currentRuntime = null;
                    currentRun = PropertiesUtil.getStringFromTimeProperties("currentRuntime");
                    if (currentRun != null) {
                        try {
                            currentRuntime = PropertiesUtil.colonDF.parse(currentRun.replaceAll("\\\\", ""));
                        }
                        catch (java.text.ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    if (currentRuntime != null && System.currentTimeMillis() - currentRuntime.getTime() < TimeUnit.MINUTES.toMillis(PropertiesUtil.getTimeoutMinutes())) ** GOTO lbl46
                    PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                    ResyncManagerMain.clean();
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) ** GOTO lbl-1000
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Problem switching currentHost! Check timestamp.properties");
                    return;
lbl46:
                    // 1 sources

                    ResyncManagerMain.doStop();
                    return;
lbl48:
                    // 1 sources

                    ResyncElasticSearchTitlesUtil.printConsoleLog("Previous resync had completed successfully! Running CLEAN.");
                    PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                    ResyncManagerMain.clean();
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) ** GOTO lbl-1000
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Couldn't clean properly! Check file permissions.");
                    return;
                }
                case 5: {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Resync utility is ready.");
                    break block16;
                }
                case 3: {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Resync utility is running.");
                    ResyncManagerMain.printProcessesList();
                    return;
                }
                case 1: {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is probably running on the other host.");
                    if (!ResyncManagerMain.isGeoRedundantSite) break block16;
                    currentRuntime = null;
                    timeProps = PropertiesUtil.readTimeProperties();
                    if (timeProps == null) {
                        timeProps = new Properties();
                    } else {
                        currentRun = timeProps.getProperty("currentRuntime");
                        if (currentRun != null) {
                            try {
                                currentRuntime = PropertiesUtil.colonDF.parse(currentRun.replaceAll("\\\\", ""));
                            }
                            catch (java.text.ParseException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (currentRuntime != null && System.currentTimeMillis() - currentRuntime.getTime() < TimeUnit.MINUTES.toMillis(PropertiesUtil.getTimeoutMinutes())) ** GOTO lbl87
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Switching running host to this.");
                    timeProps.setProperty("currentHost", hostname);
                    PropertiesUtil.saveTimeProperties(timeProps);
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) ** GOTO lbl-1000
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Problem switching currentHost! Check timestamp.properties");
                    return;
lbl87:
                    // 1 sources

                    ResyncManagerMain.doStop();
                    return;
                }
                case 2: {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Last resync was incomplete.");
                    timeProps = PropertiesUtil.readTimeProperties();
                    if (timeProps == null) {
                        timeProps = new Properties();
                    }
                    if (ResyncManagerMain.isGeoRedundantSite) {
                        ResyncElasticSearchTitlesUtil.printConsoleLog("Setting currentHost: " + hostname);
                        timeProps.setProperty("currentHost", hostname);
                    }
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                    timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
                    PropertiesUtil.saveTimeProperties(timeProps);
                    if (ResyncManagerMain.checkTitlesResyncStatus() == ResyncStatus.STOPPED) {
                        ResyncElasticSearchTitlesUtil.printConsoleLog("Resuming titles resync.");
                        ResyncManagerMain.resumeTitlesResync();
                    }
                    if (ResyncManagerMain.checkWorkflowResyncStatus() == ResyncStatus.STOPPED) {
                        ResyncElasticSearchTitlesUtil.printConsoleLog("Resuming workflow resync.");
                        ResyncManagerMain.resumeWorkflowResync();
                    }
                    ResyncManagerMain.waitForCompletion();
                    return;
                }
                case 6: {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Currently cleaning...");
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) continue block16;
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Couldn't clean properly! Check file permissions.");
                    return;
                }
                default: {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Resync Status Error!");
                    return;
                }
            }
            break;
        }
        if (ResyncManagerMain.cl.hasOption("a")) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("ALL = TRUE");
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resyncing from: 1970-01-01:00:00:00");
            modifiedSince = ResyncManagerMain.determineModifiedSince(new Date(0L), false);
            timeProps = PropertiesUtil.readTimeProperties();
            if (timeProps == null) {
                timeProps = new Properties();
            }
            if (ResyncManagerMain.isGeoRedundantSite) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Setting currentHost: " + hostname);
                timeProps.setProperty("currentHost", hostname);
            }
            if (modifiedSince != null) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
            }
            PropertiesUtil.saveTimeProperties(timeProps);
            ResyncElasticSearchTitlesUtil.printConsoleLog("Starting Titles Resync.");
            ResyncManagerMain.startTitleResync(modifiedSince);
            ResyncElasticSearchTitlesUtil.printConsoleLog("Starting Workflow Resync.");
            ResyncManagerMain.startWorkflowResync(modifiedSince, concurrency, queueLimit, variableProcessLimit, variableConcurrency);
        } else {
            if (ResyncManagerMain.cl.hasOption("s")) {
                try {
                    startTime = PropertiesUtil.spaceDF.parse(ResyncManagerMain.cl.getOptionValue("s"));
                    ResyncElasticSearchTitlesUtil.printConsoleLog("STARTTIME = " + PropertiesUtil.spaceDF.format(startTime));
                }
                catch (java.text.ParseException e) {
                    epoch = Long.parseLong(ResyncManagerMain.cl.getOptionValue("s"));
                    if (epoch < 0L) {
                        ResyncElasticSearchTitlesUtil.printConsoleLog("Invalid date format (yyyy-MM-dd HH:mm:ss): " + ResyncManagerMain.cl.getOptionValue("s"));
                        System.exit(1);
                    }
                    startTime = new Date(epoch);
                    ResyncElasticSearchTitlesUtil.printConsoleLog("STARTTIME = " + PropertiesUtil.spaceDF.format(startTime));
                }
                modifiedSince = ResyncManagerMain.determineModifiedSince(startTime, ResyncManagerMain.isGeoRedundantSite);
            } else {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resyncing from: 1970-01-01 00:00:00");
                modifiedSince = ResyncManagerMain.determineModifiedSince(new Date(0L), ResyncManagerMain.isGeoRedundantSite);
            }
            if (modifiedSince != null) {
                timeProps = PropertiesUtil.readTimeProperties();
                if (timeProps == null) {
                    timeProps = new Properties();
                }
                if (ResyncManagerMain.isGeoRedundantSite) {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Setting currentHost: " + hostname);
                    timeProps.setProperty("currentHost", hostname);
                }
                ResyncElasticSearchTitlesUtil.printConsoleLog("MODIFIEDSINCE = " + PropertiesUtil.spaceDF.format(modifiedSince));
                ResyncElasticSearchTitlesUtil.printConsoleLog("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
                if (ResyncManagerMain.isGeoRedundantSite) {
                    ResyncManagerMain.recordStartSyncDate(timeProps);
                }
                PropertiesUtil.saveTimeProperties(timeProps);
                if (ResyncManagerMain.cl.hasOption("t") || !ResyncManagerMain.cl.hasOption("w")) {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Starting Titles Resync.");
                    ResyncManagerMain.startTitleResync(modifiedSince);
                }
                if (ResyncManagerMain.cl.hasOption("w") || !ResyncManagerMain.cl.hasOption("t")) {
                    if (ResyncManagerMain.cl.hasOption("c")) {
                        concurrency = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("c"));
                    }
                    if (ResyncManagerMain.cl.hasOption("q")) {
                        queueLimit = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("q"));
                    }
                    if (ResyncManagerMain.cl.hasOption("p")) {
                        variableProcessLimit = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("p"));
                    }
                    if (ResyncManagerMain.cl.hasOption("v")) {
                        variableConcurrency = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("v"));
                    }
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Starting Workflow Resync.");
                    ResyncManagerMain.startWorkflowResync(modifiedSince, concurrency, queueLimit, variableProcessLimit, variableConcurrency);
                }
            }
        }
        TimeUnit.SECONDS.sleep(PropertiesUtil.getStatusCheckInitialDelay());
        ResyncManagerMain.waitForCompletion();
    }

    private static void recordStartSyncDate(Properties timeProps) throws Exception {
        ResyncElasticSearchTitlesUtil.printConsoleLog("Setting startSyncDate: " + PropertiesUtil.spaceDF.format(new Date()));
        timeProps.setProperty("startSyncDate", PropertiesUtil.colonDF.format(new Date()));
        HashMap<String, Object> kv = new HashMap<String, Object>(3);
        kv.put("startSyncDate", PropertiesUtil.spaceDF.format(new Date()));
        kv.put("endSyncDate", "");
        kv.put(STATUS, "");
        PropertiesUtil.publishReplicationTimeToEs(ResyncManagerMain.getTransportClient(), kv);
    }

    private static void startTitleResync(Date modifiedSince) {
        String contentCommand = "./content_elasticsearch_sync.sh start -db " + database + " -dp " + databasePort + " -modifiedSince \"" + PropertiesUtil.spaceDF.format(modifiedSince) + "\"";
        ResyncElasticSearchTitlesUtil.printConsoleLog("content command: " + contentCommand);
        try {
            Process process = Runtime.getRuntime().exec(ResyncManagerMain.getCommandArray(contentCommand));
            PropertiesUtil.updateTimeProperties("titleSyncPid", ProcessUtil.getProcessId(process));
        }
        catch (Exception e) {
            e.printStackTrace();
            ResyncElasticSearchTitlesUtil.printConsoleLog("Error in executing content_elasticsearch_sync.sh script to start title sync!");
        }
    }

    private static String[] getCommandArray(String command) {
        return new String[]{"/bin/bash", "-c", "cd /opt/tandbergtv/cms/scripts/sync_utils/bin; " + command};
    }

    private static void waitForCompletion() throws Exception {
        while (true) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("\n\n--------------------------------------\n\n");
            ResyncElasticSearchTitlesUtil.printConsoleLog("Query time: " + PropertiesUtil.spaceDF.format(new Date()));
            ResyncStatus resyncStatus = ResyncManagerMain.checkResyncStatus();
            if (resyncStatus == ResyncStatus.READY || resyncStatus == ResyncStatus.DONE) {
                PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                break;
            }
            if (resyncStatus == ResyncStatus.STOPPED) {
                return;
            }
            if (resyncStatus == ResyncStatus.NOT_CURRENT_HOST) {
                ResyncManagerMain.doStop();
                return;
            }
            ResyncElasticSearchTitlesUtil.printConsoleLog("\n");
            ResyncManagerMain.printProcessesList();
            if (isGeoRedundantSite) {
                Properties timeProps = PropertiesUtil.readTimeProperties();
                if (timeProps == null) {
                    timeProps = new Properties();
                }
                ResyncElasticSearchTitlesUtil.printConsoleLog("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
                PropertiesUtil.saveTimeProperties(timeProps);
            }
            try {
                TimeUnit.SECONDS.sleep(PropertiesUtil.getQuerySeconds());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        ResyncManagerMain.clean();
    }

    private static void doClean() throws Exception {
        ResyncStatus status = ResyncManagerMain.checkResyncStatus();
        if (status == null) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync status is null, Something went wrong.");
            return;
        }
        switch (status) {
            case STOPPED: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Previous resync was incomplete.");
                break;
            }
            case RUNNING: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is running! Please run STOP before cleaning.");
                ResyncManagerMain.printProcessesList();
                return;
            }
            case NOT_CURRENT_HOST: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync utility is probably running on the other host.");
                break;
            }
            case DONE: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync has completed successfully!");
                PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                break;
            }
            case CLEANING: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync utility is currently cleaning.");
                return;
            }
            case READY: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync utility is ready.");
                break;
            }
            default: {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Resync Status Error!");
            }
        }
        ResyncManagerMain.clean();
    }

    private static void doStop() {
        ResyncManagerMain.killTitleSyncProcess();
        ResyncManagerMain.killWorkflowSyncProcess();
    }

    private static void killWorkflowSyncProcess() {
        ResyncElasticSearchTitlesUtil.printConsoleLog("Stopping workflow resync...");
        Integer workflowSyncPid = PropertiesUtil.getIntFromTimeProperties("workflowSyncPid");
        if (workflowSyncPid == null || ProcessUtil.kill(workflowSyncPid)) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow sync stopped.");
        } else {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow sync stop failed.");
        }
    }

    private static void killTitleSyncProcess() {
        ResyncElasticSearchTitlesUtil.printConsoleLog("Stopping titles resync...");
        Integer titleSyncPid = PropertiesUtil.getIntFromTimeProperties("titleSyncPid");
        if (titleSyncPid == null || ProcessUtil.kill(titleSyncPid)) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Titles sync stopped.");
        } else {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Titles sync stopped failed.");
        }
    }

    private static boolean clean() throws Exception {
        boolean cleanStatus = false;
        ResyncManagerMain.killTitleSyncProcess();
        ResyncElasticSearchTitlesUtil.printConsoleLog("Cleaning...");
        Properties timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps == null) {
            timeProps = new Properties();
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Setting isCleaning: true");
        timeProps.setProperty("isCleaning", "true");
        PropertiesUtil.saveTimeProperties(timeProps);
        File workDir = new File("work");
        File logDir = new File("log");
        while (!cleanStatus) {
            File[] allGeoLogFiles;
            File[] allLogFiles;
            cleanStatus = true;
            File[] allWorkFiles = workDir.listFiles();
            if (allWorkFiles != null) {
                for (File file : allWorkFiles) {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Deleting " + file.getName() + "...");
                    if (file.delete()) continue;
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Could not delete " + file.getName() + "!!!");
                    cleanStatus = false;
                }
            }
            if ((allLogFiles = logDir.listFiles((dir, name) -> name.startsWith(TITLE_IDS) || name.startsWith("work"))) != null) {
                for (File file : allLogFiles) {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Deleting " + file.getName() + "...");
                    if (file.delete()) continue;
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Could not delete " + file.getName() + "!!!");
                    cleanStatus = false;
                }
            }
            if ((allGeoLogFiles = logDir.listFiles((dir, name) -> name.startsWith("geo_sync_"))) != null) {
                Arrays.sort(allGeoLogFiles, Comparator.comparingLong(File::lastModified));
                for (int i = 0; i < allGeoLogFiles.length - 6; ++i) {
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Deleting " + allGeoLogFiles[i].getName() + "...");
                    if (allGeoLogFiles[i].delete()) continue;
                    ResyncElasticSearchTitlesUtil.printConsoleLog("Could not delete " + allGeoLogFiles[i].getName() + "!!!");
                    cleanStatus = false;
                }
            }
            if (cleanStatus) continue;
            TimeUnit.SECONDS.sleep(3L);
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Done cleaning.");
        timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps != null) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Removing isCleaning");
            timeProps.remove("isCleaning");
            PropertiesUtil.saveTimeProperties(timeProps);
        }
        return cleanStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Date determineModifiedSince(Date newModifiedSince, boolean isGeoredundantSite) throws Exception {
        if (newModifiedSince == null) {
            try {
                return PropertiesUtil.getModifiedSinceDate(null);
            }
            catch (Exception ex) {
                ResyncElasticSearchTitlesUtil.printConsoleLog(ex.getMessage());
                return null;
            }
        }
        Properties timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps == null) {
            return null;
        }
        Date lastSuccessfulRun = ResyncManagerMain.parseDate(timeProps, "lastSuccessfulRun", "Last modification time");
        if (lastSuccessfulRun == null) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("No lastSuccessfulRun. Defaulting to: 1970-01-01 00:00:00");
            lastSuccessfulRun = new Date(0L);
        }
        if (isGeoredundantSite) {
            Date lastDBReplication = ResyncManagerMain.parseDate(timeProps, "lastDBReplication", "Last database replication time");
            if (lastDBReplication == null) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("No lastDBReplication. Defaulting to: 1970-01-01 00:00:00");
                lastDBReplication = new Date(0L);
            }
            if (newModifiedSince.after(lastDBReplication)) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Old replication date: " + PropertiesUtil.spaceDF.format(lastDBReplication));
                ResyncElasticSearchTitlesUtil.printConsoleLog("New replication date: " + PropertiesUtil.spaceDF.format(newModifiedSince));
                ResyncElasticSearchTitlesUtil.printConsoleLog("Last successful run: " + PropertiesUtil.spaceDF.format(lastSuccessfulRun));
                return lastDBReplication.after(lastSuccessfulRun) ? lastSuccessfulRun : lastDBReplication;
            }
            ResyncElasticSearchTitlesUtil.printConsoleLog("Old replication date: " + PropertiesUtil.spaceDF.format(lastDBReplication));
            ResyncElasticSearchTitlesUtil.printConsoleLog("New replication date: " + PropertiesUtil.spaceDF.format(newModifiedSince));
            ResyncElasticSearchTitlesUtil.printConsoleLog("No database replication since " + PropertiesUtil.spaceDF.format(lastDBReplication));
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync utility will not run.");
            return null;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Last successful run: " + PropertiesUtil.spaceDF.format(lastSuccessfulRun));
        ResyncElasticSearchTitlesUtil.printConsoleLog("New run: " + PropertiesUtil.spaceDF.format(newModifiedSince));
        return newModifiedSince.after(lastSuccessfulRun) ? lastSuccessfulRun : newModifiedSince;
    }

    private static void resumeTitlesResync() {
        if (!ResyncElasticSearchTitlesUtil.validateDatabase()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Invalid Database Properties.");
            return;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Resuming title resync...");
        try {
            Process process = Runtime.getRuntime().exec("./bin/content_elasticsearch_sync.sh resume -db " + database + " -dp " + databasePort);
            PropertiesUtil.updateTimeProperties("titleSyncPid", ProcessUtil.getProcessId(process));
        }
        catch (Exception e) {
            e.printStackTrace();
            ResyncElasticSearchTitlesUtil.printConsoleLog("Error in executing content_elasticsearch_sync.sh script to resume title sync!");
        }
    }

    private static void startWorkflowResync(Date date, int concurrency, int queueLimit, int variableProcessLimit, int variableConcurrency) throws Exception {
        String workflowCommand = "./workflow_elasticsearch_sync.sh " + database + " -port " + databasePort;
        workflowCommand = workflowCommand + " -starttime \"" + PropertiesUtil.spaceDF.format(date) + "\"";
        if (concurrency > 0) {
            workflowCommand = workflowCommand + " -concurrency " + concurrency;
        }
        if (queueLimit > 0) {
            workflowCommand = workflowCommand + " -queuelimit " + queueLimit;
        }
        if (variableProcessLimit > 0) {
            workflowCommand = workflowCommand + " -variableprocesslimit " + variableProcessLimit;
        }
        if (variableConcurrency > 0) {
            workflowCommand = workflowCommand + " -variableconcurrency " + variableConcurrency;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow command: " + workflowCommand);
        try {
            Process process = Runtime.getRuntime().exec(ResyncManagerMain.getCommandArray(workflowCommand));
            PropertiesUtil.updateTimeProperties("workflowSyncPid", ProcessUtil.getProcessId(process));
        }
        catch (IOException e) {
            e.printStackTrace();
            ResyncElasticSearchTitlesUtil.printConsoleLog("Error in executing workflow script!");
            return;
        }
        Properties timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps == null) {
            timeProps = new Properties();
        }
        timeProps.setProperty("workflowRuntime", PropertiesUtil.spaceDF.format(date));
        PropertiesUtil.saveTimeProperties(timeProps);
        ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow resync started running.");
    }

    private static void resumeWorkflowResync() throws Exception {
        Date date = ResyncManagerMain.getWorkflowRuntime();
        if (date == null) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Can't resume workflow! Property was deleted.");
            return;
        }
        String workflowCommand = "./workflow_elasticsearch_sync.sh " + database + " -port " + databasePort;
        workflowCommand = workflowCommand + " -starttime \"" + PropertiesUtil.spaceDF.format(date) + "\"";
        ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow command: " + workflowCommand);
        Process process = Runtime.getRuntime().exec(ResyncManagerMain.getCommandArray(workflowCommand));
        PropertiesUtil.updateTimeProperties("workflowSyncPid", ProcessUtil.getProcessId(process));
        try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = input.readLine()) != null) {
                ResyncElasticSearchTitlesUtil.printConsoleLog(line);
                if (!line.contains("WFSElasticSearchService.start()")) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ResyncElasticSearchTitlesUtil.printConsoleLog("Error in executing workflow script!");
            return;
        }
        if (ProcessUtil.getProcessList("WoRdbmsToEsSynchronizer").size() == 0) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow resync did not run!");
            return;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow resync started running.");
    }

    private static Date parseDate(Properties props, String name, String label) {
        ResyncElasticSearchTitlesUtil.validateProperty(props, name, label, "timestamp.properties", false);
        try {
            Date date = PropertiesUtil.colonDF.parse(props.getProperty(name));
            if (date == null) {
                throw new Exception();
            }
            return date;
        }
        catch (Exception e) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Date unparseable: " + props.getProperty(name));
            return null;
        }
    }

    private static void checkOS() {
        if (!ProcessUtil.isLinux()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Unsupported operating system, Can only run on Linux");
            System.exit(1);
        }
    }

    private static void printUsageAndExit() {
        ResyncElasticSearchTitlesUtil.printConsoleLog("USAGE:");
        ResyncElasticSearchTitlesUtil.printConsoleLog("ResyncManagerMain <command> [<parameter 1, parameter 2, ..., parameter N] <options>");
        ResyncElasticSearchTitlesUtil.printConsoleLog("Commands:");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  START");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  STOP");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  STATUS");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  CLEAN");
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("");
        help.printHelp("Options:", ResyncManagerMain.getOptions());
        System.exit(1);
    }

    private static ResyncStatus checkResyncStatus() throws Exception {
        if (PropertiesUtil.isCleaning()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync Status: " + ResyncStatus.CLEANING.toString());
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is currently cleaning.");
            return ResyncStatus.CLEANING;
        }
        if (!PropertiesUtil.isCurrentHost()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync Status: " + ResyncStatus.NOT_CURRENT_HOST.toString());
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is probably still running on other host.");
            return ResyncStatus.NOT_CURRENT_HOST;
        }
        ResyncStatus titleStatus = ResyncManagerMain.checkTitlesResyncStatus();
        ResyncStatus workflowStatus = ResyncManagerMain.checkWorkflowResyncStatus();
        if (titleStatus == ResyncStatus.ERROR || workflowStatus == ResyncStatus.ERROR) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync Status: Corrupted work files!");
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resetting timestamp.properties.");
            PropertiesUtil.resetTimeProperties();
            if (isGeoRedundantSite) {
                PropertiesUtil.publishReplicationTimeToEs(ResyncManagerMain.getTransportClient(), STATUS, STATUS_FAILED);
            }
            ResyncManagerMain.clean();
            return ResyncManagerMain.checkResyncStatus();
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Content Resync Status: " + (Object)((Object)titleStatus));
        ResyncElasticSearchTitlesUtil.printConsoleLog("Workflow Resync Status: " + (Object)((Object)workflowStatus));
        if (titleStatus == ResyncStatus.READY && workflowStatus == ResyncStatus.READY) {
            return titleStatus;
        }
        if (titleStatus == ResyncStatus.STOPPED || workflowStatus == ResyncStatus.STOPPED) {
            return ResyncStatus.STOPPED;
        }
        if (titleStatus == ResyncStatus.RUNNING || workflowStatus == ResyncStatus.RUNNING) {
            return ResyncStatus.RUNNING;
        }
        if (titleStatus == ResyncStatus.DONE || workflowStatus == ResyncStatus.DONE) {
            return ResyncStatus.DONE;
        }
        return ResyncStatus.ERROR;
    }

    private static void printProcessesList() {
        String workflowSyncPid;
        String titleSyncPid = PropertiesUtil.getStringFromTimeProperties("titleSyncPid");
        if (titleSyncPid != null) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("titleSyncProcess status:" + titleSyncPid);
        }
        if ((workflowSyncPid = PropertiesUtil.getStringFromTimeProperties("workflowSyncPid")) != null) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("workflowSyncProcess status:" + workflowSyncPid);
        }
    }

    private static ResyncStatus checkTitlesResyncStatus() {
        File workDir = new File("work");
        if (!workDir.exists() && !workDir.mkdir()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Error: Cannot make directory \"work\"");
            return ResyncStatus.ERROR;
        }
        File logDir = new File("log");
        if (!logDir.exists() && !logDir.mkdir()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Error: Cannot make directory \"log\"");
            return ResyncStatus.ERROR;
        }
        if (!workDir.isDirectory()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Error: \"work\" is not a directory");
            return ResyncStatus.ERROR;
        }
        File[] allFiles = workDir.listFiles(file -> file.getName().startsWith(TITLE_IDS));
        if (allFiles.length == 0) {
            return ResyncStatus.READY;
        }
        for (File file2 : allFiles) {
            String statusFileContent;
            if (!file2.getName().contains(".stat")) continue;
            try (FileInputStream in = new FileInputStream(file2);){
                statusFileContent = IOUtils.toString((InputStream)in, (String)"UTF-8");
            }
            catch (Exception e) {
                ResyncElasticSearchTitlesUtil.printConsoleLog(String.format("ERROR: reading stat file [%s] error: %s", file2.getAbsolutePath(), e.getMessage()));
                if (ResyncManagerMain.isProcessRunning("titleSyncPid")) {
                    return ResyncStatus.RUNNING;
                }
                return ResyncStatus.STOPPED;
            }
            if (statusFileContent.contains("FINISH")) continue;
            if (ResyncManagerMain.isProcessRunning("titleSyncPid")) {
                return ResyncStatus.RUNNING;
            }
            return ResyncStatus.STOPPED;
        }
        return ResyncStatus.DONE;
    }

    private static boolean isProcessRunning(String key) {
        if (ProcessUtil.isProcessRunning(PropertiesUtil.getIntFromTimeProperties(key))) {
            return true;
        }
        try {
            PropertiesUtil.removeKeyInTimeProperties(key);
        }
        catch (Exception ex) {
            PropertiesUtil.logger.error((Object)ex);
        }
        return false;
    }

    private static ResyncStatus checkWorkflowResyncStatus() {
        if (ResyncManagerMain.isProcessRunning("workflowSyncPid")) {
            return ResyncStatus.RUNNING;
        }
        String bookMark = null;
        File f = new File(WORKFLOW_BOOKMARK_TXT);
        if (!f.exists()) {
            return ResyncStatus.READY;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#") || line.trim().split(":").length != 4) continue;
                bookMark = line;
                break;
            }
        }
        catch (Exception e) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Encountered exception during bookmark initialization: " + e);
        }
        if (StringUtils.isNotBlank(bookMark)) {
            String[] arr = bookMark.split(":");
            if (arr.length == 4) {
                if (!"-1".equals(arr[1])) {
                    return ResyncStatus.STOPPED;
                }
                return ResyncStatus.DONE;
            }
        } else {
            return ResyncStatus.READY;
        }
        ResyncElasticSearchTitlesUtil.printConsoleLog("Error!");
        return ResyncStatus.ERROR;
    }

    private static Date getWorkflowRuntime() throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        if (props != null && props.containsKey("workflowRuntime")) {
            String runtime = props.getProperty("workflowRuntime");
            try {
                return PropertiesUtil.spaceDF.parse(runtime);
            }
            catch (java.text.ParseException e) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Wrong format (yyyy-mm-dd HH:mm:ss): " + runtime);
                return null;
            }
        }
        return null;
    }

    static {
        database = "dbserver";
        databasePort = "5432";
        isGeoRedundantSite = false;
    }

    private static enum ResyncStatus {
        READY,
        RUNNING,
        STOPPED,
        NOT_CURRENT_HOST,
        DONE,
        CLEANING,
        ERROR;

    }
}

