/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.hibernate.jdbc.Work;

public class SaveTitleIdsWork
implements Work {
    private static final String SQL = "select case when titlestatusid = 5 then id_*-1 else id_ end from pmm_title";
    private int numShards;
    private int batchSize;
    private Timestamp fromDate;
    private boolean success = false;
    private String specificTitleIds;

    public SaveTitleIdsWork(int numShards, int batchSize, Date fromDate, String specificTitleIds) {
        this.numShards = numShards;
        this.batchSize = batchSize;
        this.specificTitleIds = specificTitleIds;
        if (fromDate != null) {
            this.fromDate = new Timestamp(fromDate.getTime());
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection con) throws SQLException {
        FileWriter[] writers = new FileWriter[this.numShards];
        RandomAccessFile[] writerStats = new RandomAccessFile[this.numShards];
        PreparedStatement st = null;
        ResultSet rs = null;
        long count = 0L;
        try {
            if (StringUtils.isNotEmpty((String)this.specificTitleIds)) {
                st = con.prepareStatement("select case when titlestatusid = 5 then id_*-1 else id_ end from pmm_title where id_ in (" + this.specificTitleIds + ") order by createdate asc");
            } else if (this.fromDate != null) {
                st = con.prepareStatement("select case when titlestatusid = 5 then id_*-1 else id_ end from pmm_title where createdate >= ?1 order by createdate asc");
                st.setTimestamp(1, this.fromDate);
            } else {
                st = con.prepareStatement(SQL);
            }
            rs = st.executeQuery();
            try {
                for (int i = 0; i < this.numShards && rs.next(); ++i) {
                    String fileName = "titleIds-" + (i + 1) + ".txt";
                    writers[i] = new FileWriter(new File("work", fileName));
                    String statusFileName = fileName + ".stat";
                    writerStats[i] = new RandomAccessFile(new File("work", statusFileName), "rw");
                    ++count;
                    String id = rs.getString(1);
                    writers[i].write(id + "\n");
                    for (int j = 0; j < this.batchSize && rs.next(); ++j) {
                        ++count;
                        id = rs.getString(1);
                        writers[i].write(id + "\n");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.success = false;
                for (FileWriter fileWriter : writers) {
                    try {
                        fileWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (Closeable closeable : writerStats) {
                    try {
                        ((RandomAccessFile)closeable).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception fileName) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception fileName) {
                        // empty catch block
                    }
                }
                return;
            }
            while (rs.next()) {
                int shard = (int)((++count - 1L) % (long)this.numShards);
                String id = rs.getString(1);
                writers[shard].write(id + "\n");
            }
            this.success = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            for (FileWriter fileWriter : writers) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {}
            }
            for (Closeable closeable : writerStats) {
                try {
                    ((RandomAccessFile)closeable).close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

