/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.utils.title.ProcessUtil;
import com.ericsson.utils.title.PropertiesUtil;
import com.ericsson.utils.title.ResyncElasticSearchTitlesUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.PropertyConfigurator;

public class TitleManagerMain {
    private static String database = "dbserver";
    private static String databasePort = "5432";
    private static String titleIds = "";
    private static String titleIdsFilePath = "";
    private static String modifiedSince = null;

    private TitleManagerMain() {
    }

    public static void main(String[] args) throws Exception {
        try {
            PropertyConfigurator.configure((String)"conf/log4j.properties");
            ResyncElasticSearchTitlesUtil.printConsoleLog("Running TitleManagerMain ");
            TitleManagerMain.checkOS();
            BasicParser parser = new BasicParser();
            CommandLine cl = parser.parse(TitleManagerMain.getOptions(), args);
            if (args.length == 0 || cl.hasOption("h")) {
                TitleManagerMain.printUsageAndExit();
            }
            String cmd = args[0];
            if (cl.hasOption("db")) {
                database = cl.getOptionValue("db");
            }
            if (cl.hasOption("dp")) {
                databasePort = cl.getOptionValue("dp");
            }
            if (cl.hasOption("titleIds")) {
                titleIds = cl.getOptionValue("titleIds");
            }
            if (cl.hasOption("titleIdsFilePath")) {
                titleIdsFilePath = cl.getOptionValue("titleIdsFilePath");
            }
            if (cl.hasOption("modifiedSince")) {
                modifiedSince = cl.getOptionValue("modifiedSince");
            }
            if (cmd.equalsIgnoreCase("status")) {
                TitleManagerMain.doStatus();
            } else if (cmd.equalsIgnoreCase("stop")) {
                TitleManagerMain.doStop();
            } else if (cmd.equalsIgnoreCase("start")) {
                TitleManagerMain.doStart();
            } else if (cmd.equalsIgnoreCase("clean")) {
                TitleManagerMain.doClean();
            } else if (cmd.equalsIgnoreCase("resume")) {
                TitleManagerMain.doResume();
            } else {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Unknown command: " + cmd);
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            ResyncElasticSearchTitlesUtil.printConsoleLog("Exception happened, abort the title sync process.");
            System.exit(1);
        }
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("db", "database", true, "Explicitly specify database. Default value is dbserver");
        options.addOption("dp", "databaseport", true, "Explicitly specify database port. Default value is 5432");
        options.addOption("titleIds", "titleIds", true, "Explicitly specify title id. Multiple title id should separate by ','");
        options.addOption("titleIdsFilePath", "titleids file path", true, "Explicitly specify file path, the file content contains multiple title ids.");
        options.addOption("modifiedSince", "modifiedSince", true, "Sync the titles that their create date is after the given date.");
        return options;
    }

    private static void doStart() throws Exception {
        ResyncElasticSearchTitlesUtil resyncElasticSearchTitlesUtil = new ResyncElasticSearchTitlesUtil(database, databasePort);
        resyncElasticSearchTitlesUtil.startTitlesResync(PropertiesUtil.getModifiedSinceDate(modifiedSince), titleIds, titleIdsFilePath);
    }

    private static void doClean() {
        ResyncElasticSearchTitlesUtil.cleanWorkFiles();
    }

    private static void doStatus() {
        List<ProcessUtil.ProcInfo> list = ResyncElasticSearchTitlesUtil.getResyncElasticSearchTitlesMainProcess();
        if (list.isEmpty()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is not running.");
        } else {
            ResyncElasticSearchTitlesUtil.printConsoleLog("The following processes are running:");
            ProcessUtil.printProcessList(list);
        }
    }

    private static void doStop() {
        ResyncElasticSearchTitlesUtil.printConsoleLog("Stopping...");
        List<ProcessUtil.ProcInfo> list = ResyncElasticSearchTitlesUtil.getResyncElasticSearchTitlesMainProcess();
        if (list.isEmpty()) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Resync is not running.");
        } else {
            for (ProcessUtil.ProcInfo info : list) {
                TitleManagerMain.kill(info.procId);
            }
            TitleManagerMain.sleep(1);
            list = ResyncElasticSearchTitlesUtil.getResyncElasticSearchTitlesMainProcess();
            if (!list.isEmpty()) {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Could not stop the following processes:");
                ProcessUtil.printProcessList(list);
            } else {
                ResyncElasticSearchTitlesUtil.printConsoleLog("Stopped.");
            }
        }
    }

    private static void doResume() throws Exception {
        ResyncElasticSearchTitlesUtil resyncElasticSearchTitlesUtil = new ResyncElasticSearchTitlesUtil(database, databasePort);
        resyncElasticSearchTitlesUtil.startProcessTitleIds();
    }

    private static void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkOS() {
        String osName = System.getProperty("os.name");
        if (osName == null || !osName.toLowerCase().contains("linux")) {
            ResyncElasticSearchTitlesUtil.printConsoleLog("Unsupported operating system: " + osName);
            ResyncElasticSearchTitlesUtil.printConsoleLog("Can only run on Linux");
            System.exit(1);
        }
    }

    private static void printUsageAndExit() {
        ResyncElasticSearchTitlesUtil.printConsoleLog("USAGE:");
        ResyncElasticSearchTitlesUtil.printConsoleLog("TitleManagerMain <command> [database] [database port]");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  Commands:");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  START");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  STOP");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  STATUS");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  CLEAN");
        ResyncElasticSearchTitlesUtil.printConsoleLog("  RESUME");
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("");
        help.printHelp("Options:", TitleManagerMain.getOptions());
        System.exit(1);
    }

    private static boolean kill(int procId) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec("kill " + procId);
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = err.readLine()) != null) {
                ResyncElasticSearchTitlesUtil.printConsoleLog(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }
}

