/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.search.utils;

import com.ericsson.cms.search.ElasticSearchService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class TitleToElasticSearchTask
implements Callable<Integer> {
    private Integer lowestOffset = Integer.MIN_VALUE;
    private List<Title> titles = new LinkedList<Title>();
    private int maxESWriteMillis;

    public TitleToElasticSearchTask(Integer lowestOffset, List<Title> titles, int maxESWriteMillis) {
        this.setLowestOffset(lowestOffset);
        this.setTitles(titles);
        this.setMaxESWriteMillis(maxESWriteMillis);
    }

    public List<Title> getTitles() {
        return this.titles;
    }

    public void setTitles(List<Title> titles) {
        this.titles = titles;
    }

    public Integer getLowestOffset() {
        return this.lowestOffset;
    }

    public void setLowestOffset(Integer lowestOffset) {
        this.lowestOffset = lowestOffset;
    }

    public int getMaxESWriteMillis() {
        return this.maxESWriteMillis;
    }

    public void setMaxESWriteMillis(int maxESWriteMillis) {
        this.maxESWriteMillis = maxESWriteMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        ElasticSearchService elasticSearch = new ElasticSearchService();
        elasticSearch.start();
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction t = session.beginTransaction();
        try {
            for (Title title : this.titles) {
                elasticSearch.saveTitle(title);
            }
            Integer n = this.lowestOffset;
            return n;
        }
        finally {
            elasticSearch.stop();
            t.commit();
        }
    }
}

