/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class Activator {
    public void start() {
        try {
            Configuration configuration = new Configuration();
            configuration.configure("/hibernate.cfg.xml");
            SessionFactory sessionFactory = configuration.buildSessionFactory();
            HibernateUtil.setSessionFactory((SessionFactory)sessionFactory);
            this.addService((Service)new WFSElasticSearchService(sessionFactory));
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public void stop() {
        this.removeService(IProcessSearchService.class);
        this.removeService(IPersistenceService.class);
        HibernateUtil.close();
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

