/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.Bookmark;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.ESWriter;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.WoRdbmsToEsSynchronizer;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BlockingExecutor
extends ThreadPoolExecutor {
    private Bookmark bookmark;

    public BlockingExecutor(int poolSize, Bookmark bookmark) {
        super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.bookmark = bookmark;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        int next;
        int current;
        super.afterExecute(r, t);
        ESWriter wr = (ESWriter)r;
        List<Long> woIds = wr.getWoIds();
        int size = woIds.size();
        if (size == 0) {
            return;
        }
        while (!WoRdbmsToEsSynchronizer.savedCount.compareAndSet(current = WoRdbmsToEsSynchronizer.savedCount.get(), next = current + size)) {
        }
        this.bookmark.update(woIds.get(size - 1));
    }
}

