/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.internal.ConvertorFactory;
import com.tandbergtv.workflow.driver.internal.CustomTokenConvertor;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.Bookmark;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.TokenCommentsComparator;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.WoRdbmsToEsSynchronizer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.jbpm.graph.exe.Comment;

public class DBReader
implements Runnable {
    private Logger logger = Logger.getLogger(DBReader.class);
    private BlockingQueue<Long> woQueue;
    private Map<Long, Object[]> workOrderData;
    private Map<Long, Object[]> tokenData;
    private Map<Long, String> templates;
    private Map<String, List<Object[]>> variables;
    private Date startTime;
    private int variableQueryLimit = 2000;
    private long lastWOId = Long.MAX_VALUE;
    private Bookmark bookmark;
    private String woIds;
    private String fileWoIds;
    private String workOrderStatus;
    private SessionFactory sessionFactory;
    private CustomTokenConvertor tokenConvertor;
    private static final String EMPTY_TEXT = "\"\"";

    public DBReader(BlockingQueue<Long> woQueue, Date startTime, Bookmark bookmark, String woIds, String fileWoIds, String workOrderStatus, Map<Long, Object[]> workOrderData, Map<Long, Object[]> tokenData, Map<Long, String> templates, Map<String, List<Object[]>> variables) {
        this.woQueue = woQueue;
        this.startTime = startTime;
        this.woIds = woIds;
        this.fileWoIds = fileWoIds;
        this.workOrderStatus = workOrderStatus;
        this.bookmark = bookmark;
        this.workOrderData = workOrderData;
        this.tokenData = tokenData;
        this.templates = templates;
        this.variables = variables;
        this.sessionFactory = HibernateUtil.getSessionFactory();
        this.tokenConvertor = ConvertorFactory.createCustomTokenConvertor((SessionFactory)this.sessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String allWOIds = this.getAllWorkOrderIds();
        if (StringUtils.isEmpty((String)allWOIds)) {
            this.syncDBDataFull();
            return;
        }
        String[] allWoIdsArray = allWOIds.split(",");
        try (Session session = null;){
            if (allWoIdsArray.length < 1) {
                this.writeLastRecordToQueue();
                return;
            }
            WoRdbmsToEsSynchronizer.setTotalCount(allWoIdsArray.length);
            session = this.sessionFactory.openSession();
            this.loadTemplate(session);
            while (allWoIdsArray.length > 0) {
                String fileWOIds = this.getBachQueryId(allWoIdsArray);
                allWoIdsArray = allWoIdsArray.length > this.variableQueryLimit ? Arrays.copyOfRange(allWoIdsArray, this.variableQueryLimit, allWoIdsArray.length) : new String[]{};
                this.syncDBDataByWorkOrderId(this.getProcessIdSql(fileWOIds), session);
            }
            this.writeLastRecordToQueue();
        }
    }

    private void writeLastRecordToQueue() throws InterruptedException {
        this.woQueue.put(WoRdbmsToEsSynchronizer.LAST_RECORD);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Reached end of result, wrote " + WoRdbmsToEsSynchronizer.LAST_RECORD + " at the end of queue before exiting thread"));
        }
    }

    private void syncDBDataByWorkOrderId(String processIdQuerySql, Session session) throws InterruptedException {
        String processIdQueryStr = processIdQuerySql + this.variableQueryLimit;
        NativeQuery processIdQuery = session.createSQLQuery(processIdQueryStr);
        processIdQuery.setParameter(1, (Object)this.startTime);
        this.logger.info((Object)("Searching for next " + this.variableQueryLimit + " eligible WOIds"));
        long startEx = System.currentTimeMillis();
        List result = processIdQuery.list();
        this.logExecuteTime(processIdQueryStr, startEx);
        if (result.isEmpty()) {
            return;
        }
        this.bookmark.addStart(((BigDecimal)result.get(0)).longValue());
        this.loadProcessData(session, result);
        this.loadTokenData(session, result);
        try {
            for (BigDecimal id : result) {
                this.woQueue.put(id.longValue());
            }
            this.logger.info((Object)"Done caching data for this batch");
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"DBReader interrupted unexpectedly", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncDBDataFull() {
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            this.loadTemplate(session);
            BigInteger totalCount = this.getTotalCount(session);
            if (totalCount.intValue() == 0) {
                this.woQueue.put(WoRdbmsToEsSynchronizer.LAST_RECORD);
                this.logger.info((Object)("No records to sync, write " + WoRdbmsToEsSynchronizer.LAST_RECORD + " at the end of queue before exiting thread"));
                return;
            }
            StringBuilder sb = new StringBuilder("select pi.processid as woId from ttv_processinstance pi, ttv_template tp ");
            sb.append(" where pi.templateid=tp.id and tp.typeid=2 and pi.updatedate >= ?1 and pi.processid < ?2 ");
            if (!"-1".equals(this.workOrderStatus)) {
                sb.append(" and exists (select 1 from ttv_token tt where tt.processid=pi.processid and tt.operationalstatus in (");
                sb.append(this.workOrderStatus);
                sb.append(" )) ");
            }
            sb.append(" order by pi.processid desc limit " + this.variableQueryLimit);
            String processIdQueryStr = sb.toString();
            NativeQuery processIdQuery = session.createSQLQuery(processIdQueryStr);
            processIdQuery.setParameter(1, (Object)this.startTime);
            while (true) {
                processIdQuery.setParameter(2, (Object)this.lastWOId);
                this.logger.info((Object)("Searching for next " + this.variableQueryLimit + " eligible WOIds starting from " + this.lastWOId + " in descending order"));
                long startEx = System.currentTimeMillis();
                List result = processIdQuery.list();
                this.logExecuteTime(processIdQueryStr, startEx);
                if (result.isEmpty()) {
                    this.writeLastRecordToQueue();
                    break;
                }
                this.putDataToQueue(session, result);
            }
        }
    }

    private void putDataToQueue(Session session, List<BigDecimal> result) throws InterruptedException {
        try {
            this.bookmark.addStart(result.get(0).longValue());
            this.loadProcessData(session, result);
            this.loadTokenData(session, result);
            for (BigDecimal id : result) {
                this.lastWOId = id.longValue();
                this.woQueue.put(this.lastWOId);
            }
            this.logger.info((Object)"Done caching data for this batch");
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"DBReader interrupted unexpectedly", (Throwable)e);
            throw e;
        }
    }

    private BigInteger getTotalCount(Session session) {
        StringBuilder totalCountQuery = new StringBuilder("select count(1) as totalCount from ttv_processinstance pi, ttv_template tp ");
        totalCountQuery.append(" where pi.templateid=tp.id and tp.typeid=2 and pi.updatedate >= ?1 ");
        if (this.bookmark.getLastWrittenBookmark() != 0L) {
            this.lastWOId = this.bookmark.getLastWrittenBookmark();
            this.logger.info((Object)("Starting lookup from " + this.lastWOId));
            totalCountQuery.append(" and pi.processid < ").append(this.lastWOId);
        }
        if (!"-1".equals(this.workOrderStatus)) {
            totalCountQuery.append(" and exists (select 1 from ttv_token tt where tt.processid=pi.processid and tt.operationalstatus in ( ");
            totalCountQuery.append(this.workOrderStatus);
            totalCountQuery.append(" )) ");
        }
        this.logger.debug((Object)("Query total count:" + totalCountQuery.toString()));
        NativeQuery countQuery = session.createSQLQuery(totalCountQuery.toString());
        countQuery.setParameter(1, (Object)this.startTime);
        BigInteger totalCount = (BigInteger)countQuery.uniqueResult();
        WoRdbmsToEsSynchronizer.setTotalCount(totalCount.intValue());
        this.logger.info((Object)("Total " + totalCount + " workorders to be synchronized"));
        return totalCount;
    }

    private void loadTemplate(Session session) {
        this.logger.info((Object)"Loading templates");
        String statement = "SELECT tt.id, tt.name, tt.version FROM ttv_template tt where tt.typeid=2";
        this.logger.debug((Object)("Executing query:" + statement));
        NativeQuery templateQuery = session.createSQLQuery(statement);
        List tRes = templateQuery.list();
        for (Object[] re : tRes) {
            this.templates.put(((BigDecimal)re[0]).longValue(), (String)re[1] + " - v" + ((BigDecimal)re[2]).longValue());
        }
    }

    public void loadProcessData(Session session, List<BigDecimal> result) {
        this.logger.info((Object)"Loading WorkOrder Data");
        String idList = this.buildIdList(result);
        String statement = "SELECT pi.processid as Id, t.startdate as start, t.enddate as end, pi.templateid as nodeDefId, pi.roottokenid as RootToken, t.parenttokenid as ParentToken, pi.isactive as active, t.adminstatus as adminStatus, t.operationalstatus as status, pi.priority as priority, pi.parentprocessid as parentprocessId, cast(pi.notes as varchar) as notes, pi.createid as createId, (select count(1) from ttv_token tt where tt.parenttokenid=pi.roottokenid  and tt.processid = pi.processid and pi.parentprocessid=0 and tt.operationalstatus=2) as failedBranchCount FROM ttv_processinstance pi LEFT OUTER JOIN ttv_token t on t.tokenid = pi.roottokenid WHERE pi.processid IN (" + idList + ")";
        long startEx = System.currentTimeMillis();
        NativeQuery query = session.createSQLQuery(statement);
        List woRes = query.list();
        this.logExecuteTime(statement, startEx);
        WorkflowProcessNote processNote = new WorkflowProcessNote();
        for (Object[] wor : woRes) {
            Long processId = ((BigDecimal)wor[0]).longValue();
            ArrayList<Object> oneWOData = new ArrayList<Object>(Arrays.asList(wor));
            if (wor[11] == null || EMPTY_TEXT.equals(wor[11]) || StringUtils.isEmpty((String)wor[11].toString())) {
                oneWOData.add(null);
            } else {
                processNote.setNotes("");
                processNote.setNotes(wor[11].toString());
                oneWOData.add(processNote.getFormatedNotes());
            }
            this.workOrderData.put(processId, oneWOData.toArray());
        }
    }

    private void logExecuteTime(String statement, long startEx) {
        this.logger.debug((Object)("Time taken [" + (System.currentTimeMillis() - startEx) + "] to execute: " + statement));
    }

    public void loadTokenData(Session session, List<BigDecimal> result) {
        this.logger.info((Object)"Loading Token Data");
        String idList = this.buildIdList(result);
        String subProcessSql = " select t2.processid as processId, t2.tokenid as tokenId, t2.currentnodename as node,  (select count(1) from ttv_token tt where tt.parenttokenid = t2.tokenId and tt.parenttokenid > 0) as hasChildToken, cast('-1' as character varying) as subProcessid,  cast(t2.comments as varchar) as comments, t2.enddate as enddate, t2.tokenname as tokenname,  cast(t2.vars as varchar) as vars  from ttv_token t2 where t2.parenttokenid > 0 and t2.processid in(" + idList + ") and exists (select 1 from ttv_processinstance tp where t2.processid = tp.processid and tp.parentprocessid >0) ";
        long startEx = System.currentTimeMillis();
        NativeQuery subProcessQuery = session.createSQLQuery(subProcessSql);
        List tokenRes = subProcessQuery.list();
        this.logExecuteTime(subProcessSql, startEx);
        this.storeTokenData(tokenRes);
        String parentProcessSql = " select t.processid as processId, t.tokenid as tokenId, t.currentnodename as node, (select count(1) from ttv_token tt where tt.parenttokenid = t.tokenId) as hasChildToken, cast('-1' as character varying) as subProcessid,  cast(t.comments as varchar) as comments, t.enddate as enddate, t.tokenname as tokenname,  cast(t.vars as varchar) as vars  from ttv_token t where t.parenttokenid = 0 and t.processid in(" + idList + ")";
        long startEx1 = System.currentTimeMillis();
        NativeQuery parentProcessQuery = session.createSQLQuery(parentProcessSql);
        List parentProcessRes = parentProcessQuery.list();
        this.logExecuteTime(parentProcessSql, startEx1);
        this.storeTokenData(parentProcessRes);
        String failedSubProcessSql = "select processid from ttv_processinstance tp where tp.parentprocessid = ?1 and exists (select 1 from ttv_token token where tp.processid = token.processid and token.adminstatus=2)";
        long startEx2 = System.currentTimeMillis();
        for (Object[] parentProRow : parentProcessRes) {
            if (parentProRow[5] == null || !parentProRow[5].equals("CHILD_PROCESS_FAILED")) continue;
            NativeQuery failedChildProcessQuery = session.createSQLQuery(failedSubProcessSql);
            failedChildProcessQuery.setParameter(1, (Object)((BigDecimal)parentProRow[0]).longValue());
            parentProRow[4] = this.buildIdList(failedChildProcessQuery.list());
        }
        this.logExecuteTime(failedSubProcessSql, startEx2);
    }

    private void storeTokenData(List<Object[]> tokenRes) {
        for (Object[] tokenRow : tokenRes) {
            long processId = ((BigDecimal)tokenRow[0]).longValue();
            long tokenId = ((BigDecimal)tokenRow[1]).longValue();
            String jsonComments = (String)tokenRow[5];
            String vars = (String)tokenRow[8];
            Comment comment = this.getComment(jsonComments);
            tokenRow[5] = comment.getActorId();
            tokenRow[6] = this.getFormatDate(comment.getTime());
            tokenRow[7] = comment.getMessage();
            this.tokenData.put(processId, tokenRow);
            this.loadDenorTableVariables(processId, tokenId, vars);
        }
    }

    private String getFormatDate(Date date) {
        return date == null ? "" : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(date);
    }

    private Comment getComment(String jsonComments) {
        List comments = this.tokenConvertor.convertComments(jsonComments);
        if (comments.isEmpty()) {
            return new Comment();
        }
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(comments.toArray()));
        Collections.sort(list, new TokenCommentsComparator());
        return (Comment)list.get(0);
    }

    private void loadDenorTableVariables(Long processId, Long tokenId, String varsJson) {
        String id = processId + "_" + tokenId;
        List tokenVars = this.variables.computeIfAbsent(id, k -> new ArrayList());
        ArrayList<Object> parsedVars = null;
        Map denormalizedVars = JsonObjectMapper.toMap((String)varsJson);
        for (Map.Entry entry : denormalizedVars.entrySet()) {
            Map valueMap = (Map)entry.getValue();
            String dataType = (String)valueMap.get("type");
            Object dataValue = this.tokenConvertor.getValueByDataType(valueMap);
            parsedVars = new ArrayList<Object>();
            parsedVars.add(entry.getKey());
            parsedVars.add(dataType);
            if (dataType.equalsIgnoreCase(Datatype.LIST.toString())) {
                parsedVars.add("List");
            } else {
                parsedVars.add(dataValue);
            }
            tokenVars.add(parsedVars.toArray());
        }
    }

    private String buildIdList(List<BigDecimal> result) {
        if (result.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (BigDecimal id : result) {
            builder.append(id).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private String getAllWorkOrderIds() {
        String allWorkOrderIds = "";
        if (!"-1".equals(this.woIds)) {
            allWorkOrderIds = this.woIds;
        }
        if (!"-1".equals(this.fileWoIds)) {
            if ("".equals(allWorkOrderIds)) {
                return this.fileWoIds;
            }
            allWorkOrderIds = allWorkOrderIds + "," + this.fileWoIds;
        }
        return allWorkOrderIds;
    }

    private String getBachQueryId(String[] ids) {
        Object[] tmpIds = ids;
        if (ids.length > this.variableQueryLimit) {
            tmpIds = Arrays.copyOf(ids, this.variableQueryLimit);
        }
        return StringUtils.join((Object[])tmpIds, (String)",");
    }

    private String getProcessIdSql(String ids) {
        StringBuilder sb = new StringBuilder("select pi.processid as woId from ttv_processinstance pi, ttv_template tp");
        sb.append(" where pi.templateid=tp.id and tp.typeid=2 and pi.updatedate >= ?1");
        this.appendExtendCriteria(ids, sb);
        sb.append(" order by pi.processid desc limit ");
        return sb.toString();
    }

    private void appendExtendCriteria(String ids, StringBuilder sb) {
        if (StringUtils.isNotEmpty((String)ids)) {
            sb.append(" and pi.processid in ( ");
            sb.append(ids);
            sb.append(" ) ");
        }
        if (!"-1".equals(this.workOrderStatus)) {
            sb.append(" and exists (select 1 from ttv_token tt where tt.processid=pi.processid and tt.operationalstatus in (");
            sb.append(this.workOrderStatus);
            sb.append(" )) ");
        }
    }
}

