/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.Bookmark;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.DBReader;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.ESSynchronizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WoRdbmsToEsSynchronizer {
    public static final String QUEUELIMIT_ARG = "queuelimit";
    public static final String CONCURRENCY_ARG = "concurrency";
    public static final String STARTTIME_ARG = "starttime";
    public static final String STATUS_ARG = "status";
    public static final String ID_FILE_ARG = "idFile";
    private static Logger logger = Logger.getLogger(WoRdbmsToEsSynchronizer.class);
    public static final Long LAST_RECORD = -1L;
    public static final SimpleDateFormat INPUT_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final int DEFAULT_QUEUE_LIMIT = 200;
    private static final int DEFAULT_CONCURRENCY = 5;
    private static final String ACTIVATORS_XML = "conf/syncActivators.xml";
    protected static final String DEFAULT_WORKORDER_IDS = "-1";
    protected static final String DEFAULT_WORKORDER_STATUS = "-1";
    protected static final String DEFAULT_WORKORDER_ID_FILE = "-1";
    private static final String MULTIPLE_COMMA_REGEX = "[,]+";
    private static final String SPECIAL_SUPPORT_REGEX = "[\\s]+";
    private static final String COMMA_SPLIT = ",";
    private static final int WORKORDER_ID_MAXIMUM = 50;
    private static final String CUSTOM_MAPPING_FILE = System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms") + "/conf/workflow/custom_wfs_mappings.json";
    private static final String DEFAULT_MAPPING_FILE = "/opt/tandbergtv/cms/scripts/sync_utils/bin/wfs_index.json";
    private static final String EDB_DATABASE_PORT = "5432";
    private static BlockingQueue<Long> woQueue;
    private static Map<Long, Object[]> workOrderData;
    private static Map<Long, Object[]> tokenData;
    private static Map<Long, String> templates;
    private static Map<String, List<Object[]>> variables;
    public static int totalCount;
    public static final AtomicInteger savedCount;
    public static final AtomicInteger deletedCount;
    private static List<String> defaultMappingFields;
    protected static List<String> customMappingFields;

    public static void setTotalCount(int value) {
        totalCount = value;
    }

    public static void main(String[] args) throws Exception {
        String workOrderIdFile;
        INPUT_DATE_FORMATTER.parse("1900-01-01 00:00:00");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(WoRdbmsToEsSynchronizer.getOptions(), args);
        }
        catch (ParseException pe) {
            WoRdbmsToEsSynchronizer.printUsageAndExit();
            return;
        }
        if (cmd.hasOption("h")) {
            WoRdbmsToEsSynchronizer.printUsageAndExit();
        }
        int queueLimit = cmd.hasOption(QUEUELIMIT_ARG) ? Integer.parseInt(cmd.getOptionValue(QUEUELIMIT_ARG)) : 200;
        int concurrency = cmd.hasOption(CONCURRENCY_ARG) ? Integer.parseInt(cmd.getOptionValue(CONCURRENCY_ARG)) : 5;
        Date startTime = cmd.hasOption(STARTTIME_ARG) ? INPUT_DATE_FORMATTER.parse(cmd.getOptionValue(STARTTIME_ARG)) : INPUT_DATE_FORMATTER.parse("1900-01-01 00:00:00");
        String defaultMappingFile = cmd.hasOption("defaultMappingFile") ? cmd.getOptionValue("defaultMappingFile") : DEFAULT_MAPPING_FILE;
        String customMappingFile = cmd.hasOption("customMappingFile") ? cmd.getOptionValue("customMappingFile") : CUSTOM_MAPPING_FILE;
        String workOrderIds = cmd.hasOption("ids") ? cmd.getOptionValue("ids") : "-1";
        String workOrderStatus = cmd.hasOption(STATUS_ARG) ? cmd.getOptionValue(STATUS_ARG) : "-1";
        String string = workOrderIdFile = cmd.hasOption(ID_FILE_ARG) ? cmd.getOptionValue(ID_FILE_ARG) : "-1";
        if (!"-1".equals(workOrderIds) && WoRdbmsToEsSynchronizer.workOrderIdLenthValidation(workOrderIds = WoRdbmsToEsSynchronizer.replaceMultipleCommaToOne(workOrderIds))) {
            logger.error((Object)"Input workorder ids maximum is 50. ");
            WoRdbmsToEsSynchronizer.printUsageAndExit();
        }
        if (!"-1".equals(workOrderStatus)) {
            workOrderStatus = WoRdbmsToEsSynchronizer.replaceMultipleCommaToOne(workOrderStatus);
        }
        String fileWoIds = "-1";
        if (!"-1".equals(workOrderIdFile) && StringUtils.isEmpty((String)(fileWoIds = WoRdbmsToEsSynchronizer.readIdsFromFile(workOrderIdFile)))) {
            WoRdbmsToEsSynchronizer.printUsageAndExit();
        }
        if (queueLimit <= 0 || queueLimit > 1000) {
            logger.warn((Object)(queueLimit + " is invalid queuelimit range. Using default of " + 200));
            queueLimit = 200;
        }
        if (concurrency <= 0 || concurrency > 100) {
            logger.warn((Object)(concurrency + " is invalid concurrency range. Using default of " + 5));
            concurrency = 5;
        }
        woQueue = new ArrayBlockingQueue<Long>(queueLimit);
        workOrderData = new ConcurrentHashMap<Long, Object[]>();
        tokenData = new ConcurrentHashMap<Long, Object[]>();
        templates = new HashMap<Long, String>();
        variables = new ConcurrentHashMap<String, List<Object[]>>();
        Bookmark bookmark = new Bookmark(startTime);
        WoRdbmsToEsSynchronizer.setHibernateProperties(cmd);
        Platform.getPlatform().start(ACTIVATORS_XML);
        DBReader producer = new DBReader(woQueue, startTime, bookmark, workOrderIds, fileWoIds, workOrderStatus, workOrderData, tokenData, templates, variables);
        Thread producerThread = new Thread(producer);
        producerThread.start();
        WoRdbmsToEsSynchronizer.initializeMappingFields(defaultMappingFile, customMappingFile);
        ESSynchronizer consumer = new ESSynchronizer(woQueue, concurrency, bookmark, workOrderData, tokenData, templates, variables);
        Thread consumerThread = new Thread(consumer);
        consumerThread.start();
        Thread bookmarkThread = new Thread(bookmark);
        bookmarkThread.start();
        producerThread.join();
        consumerThread.join();
        bookmark.terminate();
        bookmarkThread.join();
        Platform.getPlatform().stop(ACTIVATORS_XML);
        System.exit(0);
    }

    private static void initializeMappingFields(String defaultMappingFile, String customMappingFile) {
        WoRdbmsToEsSynchronizer.addMappingFields(defaultMappingFile, defaultMappingFields);
        if (WoRdbmsToEsSynchronizer.isCustomMappingFileExists(customMappingFile)) {
            WoRdbmsToEsSynchronizer.addMappingFields(customMappingFile, customMappingFields);
        }
    }

    private static void addMappingFields(String file, List<String> mappingFields) {
        try (FileInputStream is = new FileInputStream(file);){
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree((InputStream)is);
            Iterator nodeIterator = root.findPath("properties").fieldNames();
            while (nodeIterator.hasNext()) {
                String field = (String)nodeIterator.next();
                if (!defaultMappingFields.contains(field) && !customMappingFields.contains(field)) {
                    mappingFields.add(field);
                    logger.info((Object)("Adding " + field));
                    continue;
                }
                logger.warn((Object)("The fieldName: " + field + " already exist."));
            }
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)("Error occurred while processing " + file), (Throwable)jpe);
        }
        catch (IOException ioe) {
            logger.error((Object)("Error occurred reading " + file), (Throwable)ioe);
        }
    }

    private static void printUsageAndExit() {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("workflow_elasticsearch_sync.sh <database server DNS name or IP> <parameter 1 parameter 2 ... parameter N>", WoRdbmsToEsSynchronizer.getOptions());
        System.exit(1);
    }

    private static Options getOptions() {
        Options cliOptions = new Options();
        cliOptions.addOption(STARTTIME_ARG, true, "Modified since date in yyyy-MM-dd hh:mm:ss format. If missing, considered as Rebuild Index for All Workorders");
        cliOptions.addOption(QUEUELIMIT_ARG, true, "Size of internal queue, also used as query batch size, defaults to 100");
        cliOptions.addOption(CONCURRENCY_ARG, true, "Number of parallel threads, defaults to 10");
        cliOptions.addOption("port", true, "Database connection port which listen in connections from client applications . default to 5432");
        cliOptions.addOption("ids", true, "List of workorder ids to be specified sync, it split with comma and maximum is 50 workorder ids. Example: 23456,23357,23566...");
        cliOptions.addOption(STATUS_ARG, true, "List of workorder status to be specified sync, include [1:In-Process,2:Failed,3:PAUSED,4:QUEUED,5:CANCELLED,6:COMPLETED,7:BUSY,8:BRANCHED]");
        cliOptions.addOption(ID_FILE_ARG, true, "Absolute url of a txt file which store the workorder ids, it's only support one work order id to be each in a line.");
        cliOptions.addOption("h", "help", false, "Show help.");
        return cliOptions;
    }

    private static void setHibernateProperties(CommandLine cmd) {
        Properties props = new Properties();
        try (InputStream is = WoRdbmsToEsSynchronizer.class.getClassLoader().getResourceAsStream("sync.properties");){
            if (is == null) {
                System.out.println("Could not load 'sync.properties' from classpath.");
            } else {
                props.load(is);
            }
        }
        catch (Exception ex) {
            System.out.println("Could not load 'sync.properties' from classpath. " + ex.getMessage());
        }
        String connUrl = System.getProperty("hibernate.connection.url", props.getProperty("jdbc.connectionUrl"));
        String driverClassName = System.getProperty("hibernate.connection.driver_class", props.getProperty("jdbc.driverClassName"));
        String username = System.getProperty("hibernate.connection.username", props.getProperty("jdbc.username"));
        String password = System.getProperty("hibernate.connection.password", props.getProperty("jdbc.password"));
        connUrl = cmd.hasOption("port") ? connUrl.replaceAll("DBPORT", cmd.getOptionValue("port")) : connUrl.replaceAll("DBPORT", EDB_DATABASE_PORT);
        logger.info((Object)("DB connection url: " + connUrl));
        System.setProperty("hibernate.connection.url", connUrl);
        System.setProperty("hibernate.connection.driver_class", driverClassName);
        System.setProperty("hibernate.connection.username", username);
        System.setProperty("hibernate.connection.password", password);
    }

    private static boolean isCustomMappingFileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    private static String replaceMultipleCommaToOne(String ids) {
        if (StringUtils.isEmpty((String)ids)) {
            return "-1";
        }
        Pattern pattern = Pattern.compile(MULTIPLE_COMMA_REGEX);
        Matcher matcher = pattern.matcher(ids.replaceAll(SPECIAL_SUPPORT_REGEX, COMMA_SPLIT));
        String normalizedIds = matcher.replaceAll(COMMA_SPLIT);
        if (normalizedIds.endsWith(COMMA_SPLIT)) {
            normalizedIds = normalizedIds.substring(0, normalizedIds.lastIndexOf(COMMA_SPLIT));
        }
        if (normalizedIds.startsWith(COMMA_SPLIT)) {
            normalizedIds = normalizedIds.substring(1);
        }
        return normalizedIds;
    }

    private static boolean workOrderIdLenthValidation(String ids) {
        if ("-1".equals(ids)) {
            return false;
        }
        return ids.split(COMMA_SPLIT).length > 50;
    }

    /*
     * Exception decompiling
     */
    private static String readIdsFromFile(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        totalCount = 0;
        savedCount = new AtomicInteger(0);
        deletedCount = new AtomicInteger(0);
        defaultMappingFields = new ArrayList<String>();
        customMappingFields = new ArrayList<String>();
    }
}

