/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.criteria;

import com.ericsson.cms.criteria.ParamType;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum LogicalOperator {
    EQUAL,
    LESSTHAN,
    GREATERTHAN,
    LESSTHANEQUAL,
    GREATERTHANEQUAL,
    ISEMPTY(ParamType.NONE),
    ISNOTEMPTY(ParamType.NONE),
    NOTEQUAL,
    CONTAINS,
    DOESNOTCONTAIN,
    LISTCONTAINS,
    DOESNOTLISTCONTAIN,
    IN(ParamType.LIST),
    NOTIN(ParamType.LIST),
    STARTSWITH,
    ENDSWITH,
    DOESNOTSTARTWITH,
    DOESNOTENDWITH,
    EVALCHILDFIELDS(ParamType.COMPLEX),
    LENGTHEQUALS,
    LENGTHLESSTHAN,
    LENGTHGREATERTHAN,
    REGEX,
    ISVALIDTIMECODE,
    GREATERTHANTODAY,
    LESSTHANTODAY,
    EQUALTOTODAY(ParamType.NONE),
    NOTEQUALTOTODAY(ParamType.NONE),
    CONTAINSUNPARSABLE(ParamType.NONE),
    NOTGREATERTHANTODAY,
    NOTLESSTHANTODAY,
    DOESNOTCONTAINUNPARSABLE(ParamType.NONE),
    FIELDINVALID(ParamType.NONE),
    TIER1EQUALS,
    TIER2EQUALS,
    TIER3EQUALS,
    TIER4EQUALS,
    MISSINGCONTENT(ParamType.NONE),
    NOTMISSINGCONTENT(ParamType.NONE),
    BETWEEN(ParamType.RANGE),
    NUMINSTANCESEQUAL(true, ParamType.VALUE),
    NUMINSTANCESGREATERTHAN(true, ParamType.VALUE),
    NUMINSTANCESLESSTHAN(true, ParamType.VALUE),
    TOTALLENGTHGREATERTHAN(true, ParamType.VALUE),
    TOTALLENGTHLESSTHAN(true, ParamType.VALUE),
    TOTALLENGTHEQUALS(true, ParamType.VALUE),
    TIMEEQUALS,
    TIMELESSTHAN,
    TIMEGREATERTHAN,
    ISNULL(ParamType.NONE),
    ISNOTNULL(ParamType.NONE);

    private boolean multiField;
    private ParamType paramType;

    private LogicalOperator() {
        this.setMultiField(false);
        this.setParamType(ParamType.VALUE);
    }

    private LogicalOperator(ParamType paramType) {
        this.setMultiField(false);
        this.setParamType(paramType);
    }

    private LogicalOperator(boolean multiField, ParamType paramType) {
        this.setMultiField(multiField);
    }

    public static LogicalOperator lookUp(String operator) {
        LogicalOperator[] allOper;
        for (LogicalOperator oper : allOper = LogicalOperator.values()) {
            if (!oper.name().equalsIgnoreCase(operator)) continue;
            return oper;
        }
        throw new IllegalArgumentException("No value found for " + operator);
    }

    public boolean isMultiField() {
        return this.multiField;
    }

    public void setMultiField(boolean multiField) {
        this.multiField = multiField;
    }

    public LogicalOperator invert() {
        switch (this) {
            case EQUAL: {
                return NOTEQUAL;
            }
            case LESSTHAN: {
                return GREATERTHANEQUAL;
            }
            case GREATERTHAN: {
                return LESSTHANEQUAL;
            }
            case LESSTHANEQUAL: {
                return GREATERTHAN;
            }
            case GREATERTHANEQUAL: {
                return LESSTHAN;
            }
            case ISEMPTY: {
                return ISNOTEMPTY;
            }
            case ISNOTEMPTY: {
                return ISEMPTY;
            }
            case NOTEQUAL: {
                return EQUAL;
            }
            case CONTAINS: {
                return DOESNOTCONTAIN;
            }
            case DOESNOTCONTAIN: {
                return CONTAINS;
            }
            case LISTCONTAINS: {
                return DOESNOTLISTCONTAIN;
            }
            case DOESNOTLISTCONTAIN: {
                return LISTCONTAINS;
            }
            case IN: {
                return NOTIN;
            }
            case NOTIN: {
                return IN;
            }
            case STARTSWITH: {
                return DOESNOTSTARTWITH;
            }
            case DOESNOTSTARTWITH: {
                return STARTSWITH;
            }
            case ENDSWITH: {
                return DOESNOTENDWITH;
            }
            case DOESNOTENDWITH: {
                return ENDSWITH;
            }
            case GREATERTHANTODAY: {
                return NOTGREATERTHANTODAY;
            }
            case NOTGREATERTHANTODAY: {
                return GREATERTHANTODAY;
            }
            case LESSTHANTODAY: {
                return NOTLESSTHANTODAY;
            }
            case NOTLESSTHANTODAY: {
                return LESSTHANTODAY;
            }
            case CONTAINSUNPARSABLE: {
                return DOESNOTCONTAINUNPARSABLE;
            }
            case DOESNOTCONTAINUNPARSABLE: {
                return CONTAINSUNPARSABLE;
            }
            case MISSINGCONTENT: {
                return NOTMISSINGCONTENT;
            }
            case NOTMISSINGCONTENT: {
                return MISSINGCONTENT;
            }
            case EQUALTOTODAY: {
                return NOTEQUALTOTODAY;
            }
            case NOTEQUALTOTODAY: {
                return EQUALTOTODAY;
            }
        }
        return this;
    }

    public boolean containsNot() {
        switch (this) {
            case ISNOTEMPTY: 
            case NOTEQUAL: 
            case DOESNOTCONTAIN: 
            case DOESNOTLISTCONTAIN: 
            case NOTIN: 
            case DOESNOTSTARTWITH: 
            case DOESNOTENDWITH: 
            case NOTGREATERTHANTODAY: 
            case NOTLESSTHANTODAY: 
            case DOESNOTCONTAINUNPARSABLE: 
            case NOTMISSINGCONTENT: 
            case NOTEQUALTOTODAY: {
                return true;
            }
        }
        return false;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public void setParamType(ParamType paramType) {
        this.paramType = paramType;
    }
}

