/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.service.api;

import com.ericsson.cms.service.api.ResponseEntity;
import com.ericsson.cms.service.api.exception.RequestException;
import com.ericsson.cms.service.api.util.ApiUtil;
import com.ericsson.cms.service.api.util.SSLUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public abstract class AbstractClient {
    protected String userName;
    protected String password;
    protected String accessToken;
    protected String baseURL;
    protected int socketTimeOut;
    protected int connectionTimeOut;
    protected int connectionRequestTimeOut;
    private HttpClient trustAllClient;
    private HttpClient certClient;
    private static final String FAIL_TO_REQUEST = "fail to request ";
    private static Map<String, String> wpclHeaderMap = new HashMap<String, String>();

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public int getSocketTimeOut() {
        return this.socketTimeOut;
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
    }

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public int getConnectionRequestTimeOut() {
        return this.connectionRequestTimeOut;
    }

    public void setConnectionRequestTimeOut(int connectionRequestTimeOut) {
        this.connectionRequestTimeOut = connectionRequestTimeOut;
    }

    public ResponseEntity sendHttpGetRequest(String url, Map<String, String> headers) {
        try {
            return this.sendHttpRequest(url, null, "GET", headers);
        }
        catch (Exception e) {
            throw new RequestException(FAIL_TO_REQUEST + url, e);
        }
    }

    public ResponseEntity sendHttpGetRequestReturnBytes(String url, Map<String, String> headers) {
        try {
            return this.sendHttpRequestReturnBytes(url, null, "GET", headers);
        }
        catch (Exception e) {
            throw new RequestException(FAIL_TO_REQUEST + url, e);
        }
    }

    public ResponseEntity sendHttpPostRequest(String url, String body, Map<String, String> headers) {
        try {
            return this.sendHttpRequest(url, body, "POST", headers);
        }
        catch (Exception e) {
            throw new RequestException(FAIL_TO_REQUEST + url, e);
        }
    }

    private HttpResponse getHttpResponse(String url, String body, String method, Map<String, String> headers) throws Exception {
        HttpResponse httpResponse;
        RequestBuilder requestBuilder = RequestBuilder.create((String)method).setUri(url);
        if (StringUtils.isNotEmpty((String)body)) {
            requestBuilder.setEntity(EntityBuilder.create().setStream(IOUtils.toInputStream((String)body, (String)"UTF-8")).build());
        }
        if (headers != null && !headers.isEmpty()) {
            headers.entrySet().forEach(e -> requestBuilder.setHeader((String)e.getKey(), (String)e.getValue()));
        }
        if (this.getSocketTimeOut() > 0) {
            requestBuilder.setConfig(RequestConfig.custom().setSocketTimeout(this.getSocketTimeOut()).build());
        }
        if (this.getConnectionTimeOut() > 0) {
            requestBuilder.setConfig(RequestConfig.custom().setConnectTimeout(this.getConnectionTimeOut()).build());
        }
        if (this.getConnectionRequestTimeOut() > 0) {
            requestBuilder.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.getConnectionRequestTimeOut()).build());
        }
        if (StringUtils.isNotEmpty((String)this.accessToken)) {
            requestBuilder.addParameter("access_token", this.accessToken);
            httpResponse = this.getTrustAllClient().execute(requestBuilder.build());
        } else if (StringUtils.isNotEmpty((String)this.userName) && StringUtils.isNotEmpty((String)this.password)) {
            requestBuilder.setHeader("Authorization", "Basic " + this.encodeBasicAuth(this.userName, this.password));
            httpResponse = this.getTrustAllClient().execute(requestBuilder.build());
        } else {
            httpResponse = this.getCertClient().execute(requestBuilder.build());
        }
        return httpResponse;
    }

    public ResponseEntity sendHttpRequest(String url, String body, String method, Map<String, String> headers) throws Exception {
        HttpResponse httpResponse = this.getHttpResponse(url, body, method, headers);
        return this.convertRespoinseEntityToString(httpResponse);
    }

    public ResponseEntity sendHttpRequestReturnBytes(String url, String body, String method, Map<String, String> headers) throws Exception {
        HttpResponse httpResponse = this.getHttpResponse(url, body, method, headers);
        return this.convertRespoinseEntityToBytes(httpResponse);
    }

    protected Map<String, String> sendWPCLRequest(String url, String uID, Map<String, String> params) {
        String requestPayload = ApiUtil.getDeviceRequestPayload(uID, params);
        ResponseEntity entity = this.sendHttpPostRequest(url, requestPayload, wpclHeaderMap);
        this.validateResponse(entity);
        return ApiUtil.parseWPCLResponse(entity.getBody());
    }

    protected void validateResponse(ResponseEntity entity) {
        if (entity.getStatusCode() >= 400) {
            throw new RequestException("fail to send the request. response status code: " + entity.getStatusCode() + ", the response body is " + entity.getBody());
        }
    }

    public byte[] decodeImageContent(String imageStr) {
        byte[] imageContent;
        if (StringUtils.isEmpty((String)imageStr)) {
            return null;
        }
        String base64img = imageStr.substring(imageStr.indexOf(44) + 1);
        try {
            imageContent = Base64.getDecoder().decode(base64img);
            for (int i = 0; i < imageContent.length; ++i) {
                if (imageContent[i] >= 0) continue;
                int n = i;
                imageContent[n] = (byte)(imageContent[n] + 256);
            }
        }
        catch (Exception e) {
            throw new RequestException("failed to decode base64 image content " + e);
        }
        return imageContent;
    }

    private ResponseEntity convertResponseEntity(HttpResponse httpResponse) throws Exception {
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Header[] headers = httpResponse.getAllHeaders();
        if (headers != null && headers.length > 0) {
            for (Header header : headers) {
                headerMap.put(header.getName(), header.getValue());
            }
        }
        responseEntity.setResponseHeaders(headerMap);
        return responseEntity;
    }

    private ResponseEntity convertRespoinseEntityToString(HttpResponse httpResponse) throws Exception {
        ResponseEntity responseEntity = this.convertResponseEntity(httpResponse);
        responseEntity.setBody(EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8"));
        return responseEntity;
    }

    private ResponseEntity convertRespoinseEntityToBytes(HttpResponse httpResponse) throws Exception {
        ResponseEntity responseEntity = this.convertResponseEntity(httpResponse);
        responseEntity.setBytes(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()));
        return responseEntity;
    }

    private HttpClient getTrustAllClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        if (this.trustAllClient == null) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            this.trustAllClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).build();
        }
        return this.trustAllClient;
    }

    private HttpClient getCertClient() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException, Exception {
        if (this.certClient == null) {
            SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(SSLUtil.getKeyStore("/var/lib/nobody/client_auth_keystore.jks"), SSLUtil.getStorePassword().toCharArray()).loadTrustMaterial(SSLUtil.getKeyStore("/var/lib/nobody/cms_truststore.jks"), (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            this.certClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).build();
        }
        return this.certClient;
    }

    private String encodeBasicAuth(String userName, String password) {
        return Base64.getMimeEncoder().encodeToString((userName + ":" + password).getBytes());
    }

    static {
        wpclHeaderMap.put("Content-Type", "application/xml");
        wpclHeaderMap.put("Accept", "application/xml");
        wpclHeaderMap.put("SOAPAction", "");
    }

    public static abstract class AbstractClientBuilder<B extends AbstractClientBuilder, T extends AbstractClient>
    implements IBuilder<T> {
        protected String baseURL;
        protected String userName;
        protected String password;
        protected String accessToken;
        protected int socketTimeOut;
        protected int connectionTimeOut;
        protected int connectionRequestTimeOut;

        public B baseURL(String baseURL) {
            this.baseURL = baseURL;
            return (B)this;
        }

        public B userName(String userName) {
            this.userName = userName;
            return (B)this;
        }

        public B password(String password) {
            this.password = password;
            return (B)this;
        }

        public B accessToken(String accessToken) {
            this.accessToken = accessToken;
            return (B)this;
        }

        public B socketTimeOut(int socketTimeOut) {
            this.socketTimeOut = socketTimeOut;
            return (B)this;
        }

        public B connectionTimeOut(int connectionTimeOut) {
            this.connectionTimeOut = connectionTimeOut;
            return (B)this;
        }

        public B connectionRequestTimeOut(int connectionRequestTimeOut) {
            this.connectionRequestTimeOut = connectionRequestTimeOut;
            return (B)this;
        }
    }

    @FunctionalInterface
    static interface IBuilder<T> {
        public T build();
    }
}

