/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.service.api.content;

import com.ericsson.cms.service.api.AbstractClient;
import com.ericsson.cms.service.api.ResponseEntity;
import com.ericsson.cms.service.api.content.ContentServerUtil;
import com.ericsson.cms.service.api.exception.RequestException;
import com.ericsson.cms.service.api.exception.ResourceNotFoundRequestException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class ContentServerClient
extends AbstractClient {
    private static final String SPACE_SEGMENT_URLENCODED = "%20";
    private static final String SPACE_FORM_URLENCODED = "\\+";
    static final String PARAM_RESPONSE_TYPE = "responseType";
    static final String RESPONSE_TYPE_BASE64 = "BASE64";

    public ContentServerClient() {
        this.baseURL = ContentServerUtil.getContentServerURL();
    }

    public String getFileContent(String contentPath) {
        String fullUrl = String.join((CharSequence)"/", this.baseURL, this.getEncodedContentPath(contentPath));
        ResponseEntity entity = this.sendHttpGetRequest(fullUrl, null);
        this.validateResponse(entity, fullUrl);
        return entity.getBody();
    }

    public String getFileContentWithRetry(String contentPath) {
        String fullUrl = String.join((CharSequence)"/", this.baseURL, this.getEncodedContentPath(contentPath));
        fullUrl = fullUrl + "?checkFileExisting=true";
        ResponseEntity entity = this.sendHttpGetRequest(fullUrl, null);
        this.validateResponse(entity, fullUrl);
        return entity.getBody();
    }

    public byte[] getFileContentAsBytes(String contentPath) {
        String fullUrl = String.join((CharSequence)"/", this.baseURL, this.getEncodedContentPath(contentPath));
        ResponseEntity entity = this.sendHttpGetRequestReturnBytes(fullUrl, null);
        this.validateResponse(entity, fullUrl);
        return entity.getBytes();
    }

    public byte[] getImageFileContent(String contentPath) {
        String url = this.getEncodedContentPath(contentPath) + "?" + PARAM_RESPONSE_TYPE + "=" + RESPONSE_TYPE_BASE64;
        String fullUrl = String.join((CharSequence)"/", this.baseURL, url);
        ResponseEntity entity = this.sendHttpGetRequest(fullUrl, null);
        this.validateResponse(entity, fullUrl);
        return this.decodeImageContent(entity.getBody());
    }

    public void saveBase64ImageContent(String filePath, String base64ImageContent) {
        String fullUrl = this.baseURL + "/fileuploader/base64ImageUpload?path=" + this.getEncodedContentPath(filePath);
        ResponseEntity entity = this.sendHttpPostRequest(fullUrl, base64ImageContent, null);
        this.validateResponse(entity, fullUrl);
    }

    protected String getEncodedContentPath(String contentPath) {
        try {
            CharSequence[] dirs = contentPath.split("/");
            for (int i = 0; i < dirs.length; ++i) {
                dirs[i] = URLEncoder.encode((String)dirs[i], "utf-8");
            }
            return String.join((CharSequence)"/", dirs).replaceAll(SPACE_FORM_URLENCODED, SPACE_SEGMENT_URLENCODED);
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestException("failed to encode the contentPath: " + contentPath, e);
        }
    }

    private void validateResponse(ResponseEntity entity, String uri) {
        if (entity.getStatusCode() == 404) {
            throw new ResourceNotFoundRequestException(uri);
        }
        this.validateResponse(entity);
    }

    public Map<String, String> invokeFileManager(String uID, Map<String, String> params) {
        String fullURL = String.join((CharSequence)"/", this.baseURL, "filemanager/services/FileSubsystemWebservice");
        return this.sendWPCLRequest(fullURL, uID, params);
    }

    public Map<String, String> invokeImageMagick(String uID, Map<String, String> params) {
        String fullURL = String.join((CharSequence)"/", this.baseURL, "imagemagick/services/ImageMagickWebService");
        return this.sendWPCLRequest(fullURL, uID, params);
    }

    public Map<String, String> invokeFFmpeg(String uID, Map<String, String> params) {
        String fullURL = String.join((CharSequence)"/", this.baseURL, "ffmpeg/services/FfmpegWebservice");
        return this.sendWPCLRequest(fullURL, uID, params);
    }

    public static class ContentServerClientBuilder
    extends AbstractClient.AbstractClientBuilder<ContentServerClientBuilder, ContentServerClient> {
        @Override
        public ContentServerClient build() {
            ContentServerClient contentServer = new ContentServerClient();
            if (this.baseURL != null) {
                contentServer.setBaseURL(this.baseURL);
            }
            contentServer.setAccessToken(this.accessToken);
            contentServer.setPassword(this.password);
            contentServer.setUserName(this.userName);
            contentServer.setSocketTimeOut(this.socketTimeOut);
            contentServer.setConnectionTimeOut(this.connectionTimeOut);
            contentServer.setConnectionRequestTimeOut(this.connectionRequestTimeOut);
            return contentServer;
        }
    }
}

