/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.service.api.content;

import com.ericsson.cms.service.api.exception.RequestException;
import com.ericsson.cms.service.api.neptunesetting.NeptuneSettingClient;
import java.util.logging.Logger;

public class ContentServerUtil {
    private static String contentServerURL;
    private static final String CONTENTSERVER_SETTING_GROUP = "com.ericsson.cms.filemanager.contentserver";
    private static final String COTENTSERVER_URL_SETTING = "internalContentServerURL";
    private static final Logger logger;

    private ContentServerUtil() {
    }

    public static String getContentServerURL() {
        if (contentServerURL == null) {
            try {
                contentServerURL = new NeptuneSettingClient().getSetting(CONTENTSERVER_SETTING_GROUP, COTENTSERVER_URL_SETTING);
            }
            catch (RequestException e) {
                logger.warning("fail to get the content server URL from content server. " + contentServerURL);
                contentServerURL = "https://app:8444";
            }
        }
        return contentServerURL;
    }

    static {
        logger = Logger.getLogger("ContentServerUtil");
    }
}

