/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.service.api.device;

import com.ericsson.cms.service.api.AbstractClient;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DeviceServiceClient
extends AbstractClient {
    public static final String CONTENT_MGMT_SERVICE = "CMAdaptorService";
    private String adaptorService;

    public DeviceServiceClient() {
        this.baseURL = "https://app:8443";
        this.adaptorService = CONTENT_MGMT_SERVICE;
    }

    public Map<String, String> execute(String uID, Map<String, String> parameters) {
        String fullURL = StringUtils.join(Arrays.asList(this.baseURL, "cms/resource/services", this.adaptorService), (String)"/");
        return this.sendWPCLRequest(fullURL, uID, parameters);
    }

    public void setAdaptorService(String adaptorService) {
        this.adaptorService = adaptorService;
    }

    public static class DeviceServiceClientBuilder
    extends AbstractClient.AbstractClientBuilder<DeviceServiceClientBuilder, DeviceServiceClient> {
        private String adaptorService = "CMAdaptorService";

        public DeviceServiceClientBuilder adaptorService(String adaptorService) {
            this.adaptorService = adaptorService;
            return this;
        }

        @Override
        public DeviceServiceClient build() {
            DeviceServiceClient deviceClient = new DeviceServiceClient();
            if (StringUtils.isNotEmpty((String)this.baseURL)) {
                deviceClient.setBaseURL(this.baseURL);
            }
            if (StringUtils.isNotEmpty((String)this.adaptorService)) {
                deviceClient.setAdaptorService(this.adaptorService);
            }
            deviceClient.setUserName(this.userName);
            deviceClient.setPassword(this.password);
            deviceClient.setAccessToken(this.accessToken);
            deviceClient.setSocketTimeOut(this.socketTimeOut);
            deviceClient.setConnectionTimeOut(this.connectionTimeOut);
            deviceClient.setConnectionRequestTimeOut(this.connectionRequestTimeOut);
            return deviceClient;
        }
    }
}

